/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;

public class ObjectWriter {
    private static final byte[] htree = Constants.encodeASCII("tree");
    private static final byte[] hparent = Constants.encodeASCII("parent");
    private static final byte[] hauthor = Constants.encodeASCII("author");
    private static final byte[] hcommitter = Constants.encodeASCII("committer");
    private static final byte[] hencoding = Constants.encodeASCII("encoding");
    private final Repository r;
    private final byte[] buf;
    private final MessageDigest md;

    public ObjectWriter(Repository d) {
        this.r = d;
        this.buf = new byte[8192];
        this.md = Constants.newMessageDigest();
    }

    public ObjectId writeBlob(byte[] b) throws IOException {
        return this.writeBlob(b.length, new ByteArrayInputStream(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId writeBlob(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            ObjectId objectId = this.writeBlob(f.length(), is);
            return objectId;
        }
        finally {
            is.close();
        }
    }

    public ObjectId writeBlob(long len, InputStream is) throws IOException {
        return this.writeObject(3, len, is, true);
    }

    public ObjectId writeTree(Tree t) throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        TreeEntry[] items = t.members();
        for (int k = 0; k < items.length; ++k) {
            TreeEntry e = items[k];
            ObjectId id = e.getId();
            if (id == null) {
                throw new ObjectWritingException("Object at path \"" + e.getFullName() + "\" does not have an id assigned." + "  All object ids must be assigned prior" + " to writing a tree.");
            }
            e.getMode().copyTo(o);
            o.write(32);
            o.write(e.getNameUTF8());
            o.write(0);
            id.copyRawTo(o);
        }
        return this.writeCanonicalTree(o.toByteArray());
    }

    public ObjectId writeCanonicalTree(byte[] b) throws IOException {
        return this.writeTree(b.length, new ByteArrayInputStream(b));
    }

    private ObjectId writeTree(long len, InputStream is) throws IOException {
        return this.writeObject(2, len, is, true);
    }

    public ObjectId writeCommit(Commit c) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String encoding = c.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, encoding);
        os.write(htree);
        os.write(32);
        c.getTreeId().copyTo(os);
        os.write(10);
        ObjectId[] ps = c.getParentIds();
        for (int i = 0; i < ps.length; ++i) {
            os.write(hparent);
            os.write(32);
            ps[i].copyTo(os);
            os.write(10);
        }
        os.write(hauthor);
        os.write(32);
        w.write(c.getAuthor().toExternalString());
        w.flush();
        os.write(10);
        os.write(hcommitter);
        os.write(32);
        w.write(c.getCommitter().toExternalString());
        w.flush();
        os.write(10);
        if (!encoding.equals("UTF-8")) {
            os.write(hencoding);
            os.write(32);
            os.write(Constants.encodeASCII(encoding));
            os.write(10);
        }
        os.write(10);
        w.write(c.getMessage());
        w.flush();
        return this.writeCommit(os.toByteArray());
    }

    private ObjectId writeTag(byte[] b) throws IOException {
        return this.writeTag(b.length, new ByteArrayInputStream(b));
    }

    public ObjectId writeTag(Tag c) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, Constants.CHARSET);
        w.write("object ");
        c.getObjId().copyTo(w);
        w.write(10);
        w.write("type ");
        w.write(c.getType());
        w.write("\n");
        w.write("tag ");
        w.write(c.getTag());
        w.write("\n");
        w.write("tagger ");
        w.write(c.getAuthor().toExternalString());
        w.write(10);
        w.write(10);
        w.write(c.getMessage());
        w.close();
        return this.writeTag(os.toByteArray());
    }

    private ObjectId writeCommit(byte[] b) throws IOException {
        return this.writeCommit(b.length, new ByteArrayInputStream(b));
    }

    private ObjectId writeCommit(long len, InputStream is) throws IOException {
        return this.writeObject(1, len, is, true);
    }

    private ObjectId writeTag(long len, InputStream is) throws IOException {
        return this.writeObject(4, len, is, true);
    }

    public ObjectId computeBlobSha1(long len, InputStream is) throws IOException {
        return this.writeObject(3, len, is, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectId writeObject(int type, long len, InputStream is, boolean store) throws IOException {
        DeflaterOutputStream deflateStream;
        FileOutputStream fileStream;
        File t;
        ObjectId id = null;
        Deflater def = null;
        if (store) {
            t = File.createTempFile("noz", null, this.r.getObjectsDirectory());
            fileStream = new FileOutputStream(t);
        } else {
            t = null;
            fileStream = null;
        }
        this.md.reset();
        if (store) {
            def = new Deflater(this.r.getConfig().getCore().getCompression());
            deflateStream = new DeflaterOutputStream((OutputStream)fileStream, def);
        } else {
            deflateStream = null;
        }
        try {
            int n;
            byte[] header = Constants.encodedTypeString(type);
            this.md.update(header);
            if (deflateStream != null) {
                deflateStream.write(header);
            }
            this.md.update((byte)32);
            if (deflateStream != null) {
                deflateStream.write(32);
            }
            header = Constants.encodeASCII(len);
            this.md.update(header);
            if (deflateStream != null) {
                deflateStream.write(header);
            }
            this.md.update((byte)0);
            if (deflateStream != null) {
                deflateStream.write(0);
            }
            while (len > 0L && (n = is.read(this.buf, 0, (int)Math.min(len, (long)this.buf.length))) > 0) {
                this.md.update(this.buf, 0, n);
                if (deflateStream != null) {
                    deflateStream.write(this.buf, 0, n);
                }
                len -= (long)n;
            }
            if (len != 0L) {
                throw new IOException("Input did not match supplied length. " + len + " bytes are missing.");
            }
            if (deflateStream != null) {
                deflateStream.close();
                if (t != null) {
                    t.setReadOnly();
                }
            }
            id = ObjectId.fromRaw(this.md.digest());
        }
        finally {
            if (id == null && deflateStream != null) {
                try {
                    deflateStream.close();
                }
                finally {
                    t.delete();
                }
            }
            if (def != null) {
                def.end();
            }
        }
        if (t == null) {
            return id;
        }
        if (this.r.hasObject(id)) {
            t.delete();
        } else {
            File o = this.r.toFile(id);
            if (!t.renameTo(o)) {
                o.getParentFile().mkdir();
                if (!t.renameTo(o) && !this.r.hasObject(id)) {
                    t.delete();
                    throw new ObjectWritingException("Unable to create new object: " + o);
                }
            }
        }
        return id;
    }
}

