/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ByteArrayWindow;
import org.eclipse.jgit.lib.ByteBufferWindow;
import org.eclipse.jgit.lib.ByteWindow;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.DeltaOfsPackedObjectLoader;
import org.eclipse.jgit.lib.DeltaRefPackedObjectLoader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackIndex;
import org.eclipse.jgit.lib.PackReverseIndex;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.UnpackedObjectCache;
import org.eclipse.jgit.lib.WholePackedObjectLoader;
import org.eclipse.jgit.lib.WindowCache;
import org.eclipse.jgit.lib.WindowCursor;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackFile
implements Iterable<PackIndex.MutableEntry> {
    public static Comparator<PackFile> SORT = new Comparator<PackFile>(){

        @Override
        public int compare(PackFile a, PackFile b) {
            return b.packLastModified - a.packLastModified;
        }
    };
    private final File idxFile;
    private final File packFile;
    final int hash;
    private RandomAccessFile fd;
    long length;
    private int activeWindows;
    private int activeCopyRawData;
    private int packLastModified;
    private volatile boolean invalid;
    private byte[] packChecksum;
    private PackIndex loadedIdx;
    private PackReverseIndex reverseIdx;

    public PackFile(File idxFile, File packFile) {
        this.idxFile = idxFile;
        this.packFile = packFile;
        this.packLastModified = (int)(packFile.lastModified() >> 10);
        this.hash = System.identityHashCode(this) * 31;
        this.length = Long.MAX_VALUE;
    }

    private synchronized PackIndex idx() throws IOException {
        if (this.loadedIdx == null) {
            if (this.invalid) {
                throw new PackInvalidException(this.packFile);
            }
            try {
                PackIndex idx = PackIndex.open(this.idxFile);
                if (this.packChecksum == null) {
                    this.packChecksum = idx.packChecksum;
                } else if (!Arrays.equals(this.packChecksum, idx.packChecksum)) {
                    throw new PackMismatchException("Pack checksum mismatch");
                }
                this.loadedIdx = idx;
            }
            catch (IOException e) {
                this.invalid = true;
                throw e;
            }
        }
        return this.loadedIdx;
    }

    final PackedObjectLoader resolveBase(WindowCursor curs, long ofs) throws IOException {
        return this.reader(curs, ofs);
    }

    public File getPackFile() {
        return this.packFile;
    }

    public boolean hasObject(AnyObjectId id) throws IOException {
        return this.idx().hasObject(id);
    }

    public PackedObjectLoader get(WindowCursor curs, AnyObjectId id) throws IOException {
        long offset = this.idx().findOffset(id);
        return 0L < offset ? this.reader(curs, offset) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        UnpackedObjectCache.purge(this);
        WindowCache.purge(this);
        PackFile packFile = this;
        synchronized (packFile) {
            this.loadedIdx = null;
            this.reverseIdx = null;
        }
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        try {
            return this.idx().iterator();
        }
        catch (IOException e) {
            return Collections.emptyList().iterator();
        }
    }

    long getObjectCount() throws IOException {
        return this.idx().getObjectCount();
    }

    ObjectId findObjectForOffset(long offset) throws IOException {
        return this.getReverseIdx().findObject(offset);
    }

    final UnpackedObjectCache.Entry readCache(long position) {
        return UnpackedObjectCache.get(this, position);
    }

    final void saveCache(long position, byte[] data, int type) {
        UnpackedObjectCache.store(this, position, data, type);
    }

    final byte[] decompress(long position, int totalSize, WindowCursor curs) throws DataFormatException, IOException {
        byte[] dstbuf = new byte[totalSize];
        if (curs.inflate(this, position, dstbuf, 0) != totalSize) {
            throw new EOFException("Short compressed stream at " + position);
        }
        return dstbuf;
    }

    final void copyRawData(PackedObjectLoader loader, OutputStream out, byte[] buf, WindowCursor curs) throws IOException {
        long objectOffset = loader.objectOffset;
        long dataOffset = loader.dataOffset;
        int cnt = (int)(this.findEndOffset(objectOffset) - dataOffset);
        PackIndex idx = this.idx();
        if (idx.hasCRC32Support()) {
            int toRead;
            CRC32 crc = new CRC32();
            for (int headerCnt = (int)(dataOffset - objectOffset); headerCnt > 0; headerCnt -= toRead) {
                toRead = Math.min(headerCnt, buf.length);
                this.readFully(objectOffset, buf, 0, toRead, curs);
                crc.update(buf, 0, toRead);
            }
            CheckedOutputStream crcOut = new CheckedOutputStream(out, crc);
            this.copyToStream(dataOffset, buf, cnt, crcOut, curs);
            long computed = crc.getValue();
            ObjectId id = this.findObjectForOffset(objectOffset);
            long expected = idx.findCRC32(id);
            if (computed != expected) {
                throw new CorruptObjectException("Object at " + dataOffset + " in " + this.getPackFile() + " has bad zlib stream");
            }
        } else {
            try {
                curs.inflateVerify(this, dataOffset);
            }
            catch (DataFormatException dfe) {
                CorruptObjectException coe = new CorruptObjectException("Object at " + dataOffset + " in " + this.getPackFile() + " has bad zlib stream");
                coe.initCause(dfe);
                throw coe;
            }
            this.copyToStream(dataOffset, buf, cnt, out, curs);
        }
    }

    boolean supportsFastCopyRawData() throws IOException {
        return this.idx().hasCRC32Support();
    }

    boolean invalid() {
        return this.invalid;
    }

    private void readFully(long position, byte[] dstbuf, int dstoff, int cnt, WindowCursor curs) throws IOException {
        if (curs.copy(this, position, dstbuf, dstoff, cnt) != cnt) {
            throw new EOFException();
        }
    }

    private void copyToStream(long position, byte[] buf, long cnt, OutputStream out, WindowCursor curs) throws IOException, EOFException {
        while (cnt > 0L) {
            int toRead = (int)Math.min(cnt, (long)buf.length);
            this.readFully(position, buf, 0, toRead, curs);
            position += (long)toRead;
            cnt -= (long)toRead;
            out.write(buf, 0, toRead);
        }
    }

    synchronized void beginCopyRawData() throws IOException {
        if (++this.activeCopyRawData == 1 && this.activeWindows == 0) {
            this.doOpen();
        }
    }

    synchronized void endCopyRawData() {
        if (--this.activeCopyRawData == 0 && this.activeWindows == 0) {
            this.doClose();
        }
    }

    synchronized boolean beginWindowCache() throws IOException {
        if (++this.activeWindows == 1) {
            if (this.activeCopyRawData == 0) {
                this.doOpen();
            }
            return true;
        }
        return false;
    }

    synchronized boolean endWindowCache() {
        boolean r;
        boolean bl = r = --this.activeWindows == 0;
        if (r && this.activeCopyRawData == 0) {
            this.doClose();
        }
        return r;
    }

    private void doOpen() throws IOException {
        try {
            if (this.invalid) {
                throw new PackInvalidException(this.packFile);
            }
            this.fd = new RandomAccessFile(this.packFile, "r");
            this.length = this.fd.length();
            this.onOpenPack();
        }
        catch (IOException ioe) {
            this.openFail();
            throw ioe;
        }
        catch (RuntimeException re) {
            this.openFail();
            throw re;
        }
        catch (Error re) {
            this.openFail();
            throw re;
        }
    }

    private void openFail() {
        this.activeWindows = 0;
        this.activeCopyRawData = 0;
        this.invalid = true;
        this.doClose();
    }

    private void doClose() {
        if (this.fd != null) {
            try {
                this.fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fd = null;
        }
    }

    ByteArrayWindow read(long pos, int size) throws IOException {
        if (this.length < pos + (long)size) {
            size = (int)(this.length - pos);
        }
        byte[] buf = new byte[size];
        IO.readFully(this.fd.getChannel(), pos, buf, 0, size);
        return new ByteArrayWindow(this, pos, buf);
    }

    ByteWindow mmap(long pos, int size) throws IOException {
        MappedByteBuffer map;
        if (this.length < pos + (long)size) {
            size = (int)(this.length - pos);
        }
        try {
            map = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, size);
        }
        catch (IOException ioe1) {
            System.gc();
            System.runFinalization();
            map = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, pos, size);
        }
        if (map.hasArray()) {
            return new ByteArrayWindow(this, pos, map.array());
        }
        return new ByteBufferWindow(this, pos, map);
    }

    private void onOpenPack() throws IOException {
        PackIndex idx = this.idx();
        byte[] buf = new byte[20];
        IO.readFully(this.fd.getChannel(), 0L, buf, 0, 12);
        if (RawParseUtils.match(buf, 0, Constants.PACK_SIGNATURE) != 4) {
            throw new IOException("Not a PACK file.");
        }
        long vers = NB.decodeUInt32(buf, 4);
        long packCnt = NB.decodeUInt32(buf, 8);
        if (vers != 2L && vers != 3L) {
            throw new IOException("Unsupported pack version " + vers + ".");
        }
        if (packCnt != idx.getObjectCount()) {
            throw new PackMismatchException("Pack object count mismatch: pack " + packCnt + " index " + idx.getObjectCount() + ": " + this.getPackFile());
        }
        IO.readFully(this.fd.getChannel(), this.length - 20L, buf, 0, 20);
        if (!Arrays.equals(buf, this.packChecksum)) {
            throw new PackMismatchException("Pack checksum mismatch: pack " + ObjectId.fromRaw(buf).name() + " index " + ObjectId.fromRaw(idx.packChecksum).name() + ": " + this.getPackFile());
        }
    }

    private PackedObjectLoader reader(WindowCursor curs, long objOffset) throws IOException {
        long pos = objOffset;
        int p = 0;
        byte[] ib = curs.tempId;
        this.readFully(pos, ib, 0, 20, curs);
        int c = ib[p++] & 0xFF;
        int typeCode = c >> 4 & 7;
        long dataSize = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
            dataSize += (long)((c & 0x7F) << shift);
            shift += 7;
        }
        pos += (long)p;
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new WholePackedObjectLoader(this, pos, objOffset, typeCode, (int)dataSize);
            }
            case 6: {
                this.readFully(pos, ib, 0, 20, curs);
                p = 0;
                c = ib[p++] & 0xFF;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = ib[p++] & 0xFF;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                return new DeltaOfsPackedObjectLoader(this, pos + (long)p, objOffset, (int)dataSize, objOffset - ofs);
            }
            case 7: {
                this.readFully(pos, ib, 0, 20, curs);
                return new DeltaRefPackedObjectLoader(this, pos + (long)ib.length, objOffset, (int)dataSize, ObjectId.fromRaw(ib));
            }
        }
        throw new IOException("Unknown object type " + typeCode + ".");
    }

    private long findEndOffset(long startOffset) throws IOException, CorruptObjectException {
        long maxOffset = this.length - 20L;
        return this.getReverseIdx().findNextOffset(startOffset, maxOffset);
    }

    private synchronized PackReverseIndex getReverseIdx() throws IOException {
        if (this.reverseIdx == null) {
            this.reverseIdx = new PackReverseIndex(this.idx());
        }
        return this.reverseIdx;
    }
}

