/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.WindowCursor;

abstract class PackedObjectLoader
extends ObjectLoader {
    protected final PackFile pack;
    protected final long dataOffset;
    protected final long objectOffset;
    protected int objectType;
    protected int objectSize;
    protected byte[] cachedBytes;

    PackedObjectLoader(PackFile pr, long dataOffset, long objectOffset) {
        this.pack = pr;
        this.dataOffset = dataOffset;
        this.objectOffset = objectOffset;
    }

    public abstract void materialize(WindowCursor var1) throws IOException;

    public final int getType() {
        return this.objectType;
    }

    public final long getSize() {
        return this.objectSize;
    }

    public final byte[] getCachedBytes() {
        return this.cachedBytes;
    }

    public final long getObjectOffset() {
        return this.objectOffset;
    }

    public final long getDataOffset() {
        return this.dataOffset;
    }

    public void beginCopyRawData() throws IOException {
        this.pack.beginCopyRawData();
    }

    public void copyRawData(OutputStream out, byte[] buf, WindowCursor curs) throws IOException {
        this.pack.copyRawData(this, out, buf, curs);
    }

    public void endCopyRawData() {
        this.pack.endCopyRawData();
    }

    public boolean supportsFastCopyRawData() throws IOException {
        return this.pack.supportsFastCopyRawData();
    }

    public abstract ObjectId getDeltaBase() throws IOException;
}

