/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.FileBasedConfig;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.IndexChangedEvent;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectDirectory;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefDirectory;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.RefsChangedEvent;
import org.eclipse.jgit.lib.RepositoryConfig;
import org.eclipse.jgit.lib.RepositoryListener;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.Treeish;
import org.eclipse.jgit.lib.WindowCursor;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    private final AtomicInteger useCnt = new AtomicInteger(1);
    private final File gitDir;
    private final RepositoryConfig config;
    private final RefDatabase refs;
    private final ObjectDirectory objectDatabase;
    private GitIndex index;
    private final List<RepositoryListener> listeners = new Vector<RepositoryListener>();
    private static final List<RepositoryListener> allListeners = new Vector<RepositoryListener>();
    private File workDir;
    private File indexFile;

    public Repository(File d) throws IOException {
        this(d, null, null, null, null);
    }

    public Repository(File d, File workTree) throws IOException {
        this(d, workTree, null, null, null);
    }

    public Repository(File d, File workTree, File objectDir, File[] alternateObjectDir, File indexFile) throws IOException {
        String repositoryFormatVersion;
        if (workTree != null) {
            this.workDir = workTree;
            this.gitDir = d == null ? new File(workTree, ".git") : d;
        } else if (d != null) {
            this.gitDir = d;
        } else {
            throw new IllegalArgumentException("Either GIT_DIR or GIT_WORK_TREE must be passed to Repository constructor");
        }
        FileBasedConfig userConfig = SystemReader.getInstance().openUserConfig();
        try {
            userConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException("User config file " + userConfig.getFile().getAbsolutePath() + " invalid: " + e1);
            e2.initCause(e1);
            throw e2;
        }
        this.config = new RepositoryConfig(userConfig, FS.resolve(this.gitDir, "config"));
        try {
            this.getConfig().load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException("Unknown repository format");
            e2.initCause(e1);
            throw e2;
        }
        if (this.workDir == null) {
            String workTreeConfig = this.getConfig().getString("core", null, "worktree");
            this.workDir = workTreeConfig != null ? FS.resolve(d, workTreeConfig) : this.gitDir.getParentFile();
        }
        this.refs = new RefDirectory(this);
        this.objectDatabase = objectDir != null ? new ObjectDirectory(FS.resolve(objectDir, ""), alternateObjectDir) : new ObjectDirectory(FS.resolve(this.gitDir, "objects"), alternateObjectDir);
        this.indexFile = indexFile != null ? indexFile : new File(this.gitDir, "index");
        if (this.objectDatabase.exists() && !"0".equals(repositoryFormatVersion = this.getConfig().getString("core", null, "repositoryFormatVersion"))) {
            throw new IOException("Unknown repository format \"" + repositoryFormatVersion + "\"; expected \"0\".");
        }
    }

    public synchronized void create() throws IOException {
        this.create(false);
    }

    public void create(boolean bare) throws IOException {
        RepositoryConfig cfg = this.getConfig();
        if (cfg.getFile().exists()) {
            throw new IllegalStateException("Repository already exists: " + this.gitDir);
        }
        this.gitDir.mkdirs();
        this.refs.create();
        this.objectDatabase.create();
        new File(this.gitDir, "branches").mkdir();
        RefUpdate head = this.updateRef("HEAD");
        head.disableRefLog();
        head.link("refs/heads/master");
        cfg.setInt("core", null, "repositoryformatversion", 0);
        cfg.setBoolean("core", null, "filemode", true);
        if (bare) {
            cfg.setBoolean("core", null, "bare", true);
        }
        cfg.setBoolean("core", null, "logallrefupdates", !bare);
        cfg.setBoolean("core", null, "autocrlf", false);
        cfg.save();
    }

    public File getDirectory() {
        return this.gitDir;
    }

    public File getObjectsDirectory() {
        return this.objectDatabase.getDirectory();
    }

    public ObjectDatabase getObjectDatabase() {
        return this.objectDatabase;
    }

    public RefDatabase getRefDatabase() {
        return this.refs;
    }

    public RepositoryConfig getConfig() {
        return this.config;
    }

    public File toFile(AnyObjectId objectId) {
        return this.objectDatabase.fileFor(objectId);
    }

    public boolean hasObject(AnyObjectId objectId) {
        return this.objectDatabase.hasObject(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLoader openObject(AnyObjectId id) throws IOException {
        WindowCursor wc = new WindowCursor();
        try {
            ObjectLoader objectLoader = this.openObject(wc, id);
            return objectLoader;
        }
        finally {
            wc.release();
        }
    }

    public ObjectLoader openObject(WindowCursor curs, AnyObjectId id) throws IOException {
        return this.objectDatabase.openObject(curs, id);
    }

    public Collection<PackedObjectLoader> openObjectInAllPacks(AnyObjectId objectId, WindowCursor curs) throws IOException {
        LinkedList<PackedObjectLoader> result = new LinkedList<PackedObjectLoader>();
        this.openObjectInAllPacks(objectId, result, curs);
        return result;
    }

    void openObjectInAllPacks(AnyObjectId objectId, Collection<PackedObjectLoader> resultLoaders, WindowCursor curs) throws IOException {
        this.objectDatabase.openObjectInAllPacks(resultLoaders, curs, objectId);
    }

    public ObjectLoader openBlob(ObjectId id) throws IOException {
        return this.openObject(id);
    }

    public ObjectLoader openTree(ObjectId id) throws IOException {
        return this.openObject(id);
    }

    public Commit mapCommit(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapCommit(id) : null;
    }

    public Object mapObject(ObjectId id, String refName) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        switch (or.getType()) {
            case 2: {
                return this.makeTree(id, raw);
            }
            case 1: {
                return this.makeCommit(id, raw);
            }
            case 4: {
                return this.makeTag(id, refName, raw);
            }
            case 3: {
                return raw;
            }
        }
        throw new IncorrectObjectTypeException(id, "COMMIT nor TREE nor BLOB nor TAG");
    }

    public Commit mapCommit(ObjectId id) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        if (1 == or.getType()) {
            return new Commit(this, id, raw);
        }
        throw new IncorrectObjectTypeException(id, "commit");
    }

    private Commit makeCommit(ObjectId id, byte[] raw) {
        Commit ret = new Commit(this, id, raw);
        return ret;
    }

    public Tree mapTree(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapTree(id) : null;
    }

    public Tree mapTree(ObjectId id) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        switch (or.getType()) {
            case 2: {
                return new Tree(this, id, raw);
            }
            case 1: {
                return this.mapTree(ObjectId.fromString(raw, 5));
            }
        }
        throw new IncorrectObjectTypeException(id, "tree");
    }

    private Tree makeTree(ObjectId id, byte[] raw) throws IOException {
        Tree ret = new Tree(this, id, raw);
        return ret;
    }

    private Tag makeTag(ObjectId id, String refName, byte[] raw) {
        Tag ret = new Tag(this, id, refName, raw);
        return ret;
    }

    public Tag mapTag(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapTag(revstr, id) : null;
    }

    public Tag mapTag(String refName, ObjectId id) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        if (4 == or.getType()) {
            return new Tag(this, id, refName, raw);
        }
        return new Tag(this, id, refName, null);
    }

    public RefUpdate updateRef(String ref) throws IOException {
        return this.updateRef(ref, false);
    }

    public RefUpdate updateRef(String ref, boolean detach) throws IOException {
        return this.refs.newUpdate(ref, detach);
    }

    public RefRename renameRef(String fromRef, String toRef) throws IOException {
        return this.refs.newRename(fromRef, toRef);
    }

    public ObjectId resolve(String revstr) throws IOException {
        char[] rev = revstr.toCharArray();
        Object ref = null;
        ObjectId refId = null;
        block13: for (int i = 0; i < rev.length; ++i) {
            switch (rev[i]) {
                case '^': {
                    Tag tag;
                    String refstr;
                    if (refId == null && (refId = this.resolveSimple(refstr = new String(rev, 0, i))) == null) {
                        return null;
                    }
                    if (i + 1 < rev.length) {
                        switch (rev[i + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int pnum;
                                int j;
                                ref = this.mapObject(refId, null);
                                while (ref instanceof Tag) {
                                    Tag tag2 = (Tag)ref;
                                    refId = tag2.getObjId();
                                    ref = this.mapObject(refId, null);
                                }
                                if (!(ref instanceof Commit)) {
                                    throw new IncorrectObjectTypeException(refId, "commit");
                                }
                                for (j = i + 1; j < rev.length && Character.isDigit(rev[j]); ++j) {
                                }
                                String parentnum = new String(rev, i + 1, j - i - 1);
                                try {
                                    pnum = Integer.parseInt(parentnum);
                                }
                                catch (NumberFormatException e) {
                                    throw new RevisionSyntaxException("Invalid commit parent number", revstr);
                                }
                                if (pnum != 0) {
                                    ObjectId[] parents = ((Commit)ref).getParentIds();
                                    refId = pnum > parents.length ? null : parents[pnum - 1];
                                }
                                i = j - 1;
                                continue block13;
                            }
                            case '{': {
                                int k;
                                String item = null;
                                for (k = i + 2; k < rev.length; ++k) {
                                    if (rev[k] != '}') continue;
                                    item = new String(rev, i + 2, k - i - 2);
                                    break;
                                }
                                i = k;
                                if (item != null) {
                                    Tag t;
                                    if (item.equals("tree")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        if (ref instanceof Treeish) {
                                            refId = ((Treeish)ref).getTreeId();
                                            continue block13;
                                        }
                                        throw new IncorrectObjectTypeException(refId, "tree");
                                    }
                                    if (item.equals("commit")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        if (ref instanceof Commit) continue block13;
                                        throw new IncorrectObjectTypeException(refId, "commit");
                                    }
                                    if (item.equals("blob")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        if (ref instanceof byte[]) continue block13;
                                        throw new IncorrectObjectTypeException(refId, "blob");
                                    }
                                    if (item.equals("")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        continue block13;
                                    }
                                    throw new RevisionSyntaxException(revstr);
                                }
                                throw new RevisionSyntaxException(revstr);
                            }
                            default: {
                                ref = this.mapObject(refId, null);
                                if (ref instanceof Commit) {
                                    ObjectId[] parents = ((Commit)ref).getParentIds();
                                    if (parents.length == 0) {
                                        refId = null;
                                        continue block13;
                                    }
                                    refId = parents[0];
                                    continue block13;
                                }
                                throw new IncorrectObjectTypeException(refId, "commit");
                            }
                        }
                    }
                    ref = this.mapObject(refId, null);
                    while (ref instanceof Tag) {
                        tag = (Tag)ref;
                        refId = tag.getObjId();
                        ref = this.mapObject(refId, null);
                    }
                    if (ref instanceof Commit) {
                        ObjectId[] parents = ((Commit)ref).getParentIds();
                        if (parents.length == 0) {
                            refId = null;
                            continue block13;
                        }
                        refId = parents[0];
                        continue block13;
                    }
                    throw new IncorrectObjectTypeException(refId, "commit");
                }
                case '~': {
                    int l;
                    Tag tag;
                    String refstr;
                    if (ref == null) {
                        refstr = new String(rev, 0, i);
                        refId = this.resolveSimple(refstr);
                        if (refId == null) {
                            return null;
                        }
                        ref = this.mapObject(refId, null);
                    }
                    while (ref instanceof Tag) {
                        tag = (Tag)ref;
                        refId = tag.getObjId();
                        ref = this.mapObject(refId, null);
                    }
                    if (!(ref instanceof Commit)) {
                        throw new IncorrectObjectTypeException(refId, "commit");
                    }
                    for (l = i + 1; l < rev.length && Character.isDigit(rev[l]); ++l) {
                    }
                    String distnum = new String(rev, i + 1, l - i - 1);
                    try {
                    }
                    catch (NumberFormatException e) {
                        throw new RevisionSyntaxException("Invalid ancestry length", revstr);
                    }
                    for (int dist = Integer.parseInt(distnum); dist > 0; --dist) {
                        ObjectId[] parents = ((Commit)ref).getParentIds();
                        if (parents.length == 0) {
                            refId = null;
                            break;
                        }
                        refId = parents[0];
                        ref = this.mapCommit(refId);
                    }
                    i = l - 1;
                    continue block13;
                }
                case '@': {
                    int m;
                    String time = null;
                    for (m = i + 2; m < rev.length; ++m) {
                        if (rev[m] != '}') continue;
                        time = new String(rev, i + 2, m - i - 2);
                        break;
                    }
                    if (time != null) {
                        throw new RevisionSyntaxException("reflogs not yet supported by revision parser", revstr);
                    }
                    i = m - 1;
                    continue block13;
                }
                default: {
                    if (refId == null) continue block13;
                    throw new RevisionSyntaxException(revstr);
                }
            }
        }
        if (refId == null) {
            refId = this.resolveSimple(revstr);
        }
        return refId;
    }

    private ObjectId resolveSimple(String revstr) throws IOException {
        if (ObjectId.isId(revstr)) {
            return ObjectId.fromString(revstr);
        }
        Ref r = this.refs.getRef(revstr);
        return r != null ? r.getObjectId() : null;
    }

    public void incrementOpen() {
        this.useCnt.incrementAndGet();
    }

    public void close() {
        if (this.useCnt.decrementAndGet() == 0) {
            this.objectDatabase.close();
            this.refs.close();
        }
    }

    public void openPack(File pack, File idx) throws IOException {
        this.objectDatabase.openPack(pack, idx);
    }

    public String toString() {
        return "Repository[" + this.getDirectory() + "]";
    }

    public String getFullBranch() throws IOException {
        Ref head = this.getRef("HEAD");
        if (head == null) {
            return null;
        }
        if (head.isSymbolic()) {
            return head.getTarget().getName();
        }
        if (head.getObjectId() != null) {
            return head.getObjectId().name();
        }
        return null;
    }

    public String getBranch() throws IOException {
        String name = this.getFullBranch();
        if (name != null) {
            return this.shortenRefName(name);
        }
        return name;
    }

    public Ref getRef(String name) throws IOException {
        return this.refs.getRef(name);
    }

    public Map<String, Ref> getAllRefs() {
        try {
            return this.refs.getRefs("");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    public Map<String, Ref> getTags() {
        try {
            return this.refs.getRefs("refs/tags/");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    public Ref peel(Ref ref) {
        try {
            return this.refs.peel(ref);
        }
        catch (IOException e) {
            return ref;
        }
    }

    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() {
        Map<String, Ref> allRefs = this.getAllRefs();
        HashMap<AnyObjectId, Set<Ref>> ret = new HashMap<AnyObjectId, Set<Ref>>(allRefs.size());
        for (Ref ref : allRefs.values()) {
            Set<Ref> oset;
            ObjectId target = (ref = this.peel(ref)).getPeeledObjectId();
            if (target == null) {
                target = ref.getObjectId();
            }
            if ((oset = ret.put(target, Collections.singleton(ref))) == null) continue;
            if (oset.size() == 1) {
                oset = new HashSet<Ref>(oset);
            }
            ret.put(target, oset);
            oset.add(ref);
        }
        return ret;
    }

    public GitIndex getIndex() throws IOException {
        if (this.index == null) {
            this.index = new GitIndex(this);
            this.index.read();
        } else {
            this.index.rereadIfNecessary();
        }
        return this.index;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    static byte[] gitInternalSlash(byte[] bytes) {
        if (File.separatorChar == '/') {
            return bytes;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != File.separatorChar) continue;
            bytes[i] = 47;
        }
        return bytes;
    }

    public RepositoryState getRepositoryState() {
        if (new File(this.getWorkDir(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.gitDir, ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.gitDir, "MERGE_HEAD").exists()) {
            return RepositoryState.MERGING;
        }
        if (new File(this.gitDir, "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String refName) {
        int len = refName.length();
        if (len == 0) {
            return false;
        }
        if (refName.endsWith(".lock")) {
            return false;
        }
        int components = 1;
        int p = 0;
        for (int i = 0; i < len; ++i) {
            char c = refName.charAt(i);
            if (c <= ' ') {
                return false;
            }
            switch (c) {
                case '.': {
                    switch (p) {
                        case 0: 
                        case 46: 
                        case 47: {
                            return false;
                        }
                    }
                    if (i != len - 1) break;
                    return false;
                }
                case '/': {
                    if (i == 0 || i == len - 1) {
                        return false;
                    }
                    ++components;
                    break;
                }
                case '{': {
                    if (p != 64) break;
                    return false;
                }
                case '*': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '~': {
                    return false;
                }
            }
            p = c;
        }
        return components > 1;
    }

    public static String stripWorkDir(File workDir, File file) {
        String filePath = file.getPath();
        String workDirPath = workDir.getPath();
        if (filePath.length() <= workDirPath.length() || filePath.charAt(workDirPath.length()) != File.separatorChar || !filePath.startsWith(workDirPath)) {
            File absFile;
            File absWd = workDir.isAbsolute() ? workDir : workDir.getAbsoluteFile();
            File file2 = absFile = file.isAbsolute() ? file : file.getAbsoluteFile();
            if (absWd == workDir && absFile == file) {
                return "";
            }
            return Repository.stripWorkDir(absWd, absFile);
        }
        String relName = filePath.substring(workDirPath.length() + 1);
        if (File.separatorChar != '/') {
            relName = relName.replace(File.separatorChar, '/');
        }
        return relName;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workTree) {
        this.workDir = workTree;
    }

    public void addRepositoryChangedListener(RepositoryListener l) {
        this.listeners.add(l);
    }

    public void removeRepositoryChangedListener(RepositoryListener l) {
        this.listeners.remove(l);
    }

    public static void addAnyRepositoryChangedListener(RepositoryListener l) {
        allListeners.add(l);
    }

    public static void removeAnyRepositoryChangedListener(RepositoryListener l) {
        allListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRefsChanged() {
        ArrayList<RepositoryListener> all;
        RefsChangedEvent event = new RefsChangedEvent(this);
        List<RepositoryListener> list = this.listeners;
        synchronized (list) {
            all = new ArrayList<RepositoryListener>(this.listeners);
        }
        list = allListeners;
        synchronized (list) {
            all.addAll(allListeners);
        }
        for (RepositoryListener l : all) {
            l.refsChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireIndexChanged() {
        ArrayList<RepositoryListener> all;
        IndexChangedEvent event = new IndexChangedEvent(this);
        List<RepositoryListener> list = this.listeners;
        synchronized (list) {
            all = new ArrayList<RepositoryListener>(this.listeners);
        }
        list = allListeners;
        synchronized (list) {
            all.addAll(allListeners);
        }
        for (RepositoryListener l : all) {
            l.indexChanged(event);
        }
    }

    public void scanForRepoChanges() throws IOException {
        this.getAllRefs();
        this.getIndex();
    }

    public String shortenRefName(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return refName.substring("refs/heads/".length());
        }
        if (refName.startsWith("refs/tags/")) {
            return refName.substring("refs/tags/".length());
        }
        if (refName.startsWith("refs/remotes/")) {
            return refName.substring("refs/remotes/".length());
        }
        return refName;
    }

    public ReflogReader getReflogReader(String refName) throws IOException {
        Ref ref = this.getRef(refName);
        if (ref != null) {
            return new ReflogReader(this, ref.getName());
        }
        return null;
    }
}

