/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class RepositoryCache {
    private static final RepositoryCache cache = new RepositoryCache();
    private final ConcurrentHashMap<Key, Reference<Repository>> cacheMap = new ConcurrentHashMap();
    private final Lock[] openLocks = new Lock[4];

    public static Repository open(Key location) throws IOException, RepositoryNotFoundException {
        return RepositoryCache.open(location, true);
    }

    public static Repository open(Key location, boolean mustExist) throws IOException {
        return cache.openRepository(location, mustExist);
    }

    public static void register(Repository db) {
        cache.registerRepository(FileKey.exact(db.getDirectory()), db);
    }

    public static void close(Repository db) {
        cache.unregisterRepository(FileKey.exact(db.getDirectory()));
    }

    public static void clear() {
        cache.clearAll();
    }

    private RepositoryCache() {
        for (int i = 0; i < this.openLocks.length; ++i) {
            this.openLocks[i] = new Lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository openRepository(Key location, boolean mustExist) throws IOException {
        Repository db;
        Reference<Repository> ref = this.cacheMap.get(location);
        Repository repository = db = ref != null ? ref.get() : null;
        if (db == null) {
            Lock lock = this.lockFor(location);
            synchronized (lock) {
                ref = this.cacheMap.get(location);
                Repository repository2 = db = ref != null ? ref.get() : null;
                if (db == null) {
                    db = location.open(mustExist);
                    ref = new SoftReference<Repository>(db);
                    this.cacheMap.put(location, ref);
                }
            }
        }
        db.incrementOpen();
        return db;
    }

    private void registerRepository(Key location, Repository db) {
        Repository oldDb;
        db.incrementOpen();
        SoftReference<Repository> newRef = new SoftReference<Repository>(db);
        Reference oldRef = this.cacheMap.put(location, newRef);
        Repository repository = oldDb = oldRef != null ? (Repository)oldRef.get() : null;
        if (oldDb != null) {
            oldDb.close();
        }
    }

    private void unregisterRepository(Key location) {
        Repository oldDb;
        Reference<Repository> oldRef = this.cacheMap.remove(location);
        Repository repository = oldDb = oldRef != null ? oldRef.get() : null;
        if (oldDb != null) {
            oldDb.close();
        }
    }

    private void clearAll() {
        for (int stage = 0; stage < 2; ++stage) {
            Iterator<Map.Entry<Key, Reference<Repository>>> i = this.cacheMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Key, Reference<Repository>> e = i.next();
                Repository db = e.getValue().get();
                if (db != null) {
                    db.close();
                }
                i.remove();
            }
        }
    }

    private Lock lockFor(Key location) {
        return this.openLocks[(location.hashCode() >>> 1) % this.openLocks.length];
    }

    public static class FileKey
    implements Key {
        private final File path;

        public static FileKey exact(File directory) {
            return new FileKey(directory);
        }

        public static FileKey lenient(File directory) {
            File gitdir = FileKey.resolve(directory);
            return new FileKey(gitdir != null ? gitdir : directory);
        }

        protected FileKey(File directory) {
            this.path = FileKey.canonical(directory);
        }

        private static File canonical(File path) {
            try {
                return path.getCanonicalFile();
            }
            catch (IOException e) {
                return path.getAbsoluteFile();
            }
        }

        public final File getFile() {
            return this.path;
        }

        public Repository open(boolean mustExist) throws IOException {
            if (mustExist && !FileKey.isGitRepository(this.path)) {
                throw new RepositoryNotFoundException(this.path);
            }
            return new Repository(this.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof FileKey && this.path.equals(((FileKey)o).path);
        }

        public String toString() {
            return this.path.toString();
        }

        public static boolean isGitRepository(File dir) {
            return FS.resolve(dir, "objects").exists() && FS.resolve(dir, "refs").exists() && FileKey.isValidHead(new File(dir, "HEAD"));
        }

        private static boolean isValidHead(File head) {
            String ref = FileKey.readFirstLine(head);
            return ref != null && (ref.startsWith("ref: refs/") || ObjectId.isId(ref));
        }

        private static String readFirstLine(File head) {
            try {
                byte[] buf = IO.readFully(head, 4096);
                int n = buf.length;
                if (n == 0) {
                    return null;
                }
                if (buf[n - 1] == 10) {
                    --n;
                }
                return RawParseUtils.decode(buf, 0, n);
            }
            catch (IOException e) {
                return null;
            }
        }

        public static File resolve(File directory) {
            if (FileKey.isGitRepository(directory)) {
                return directory;
            }
            if (FileKey.isGitRepository(new File(directory, ".git"))) {
                return new File(directory, ".git");
            }
            String name = directory.getName();
            File parent = directory.getParentFile();
            if (FileKey.isGitRepository(new File(parent, name + ".git"))) {
                return new File(parent, name + ".git");
            }
            return null;
        }
    }

    public static interface Key {
        public Repository open(boolean var1) throws IOException, RepositoryNotFoundException;
    }

    private static class Lock {
        private Lock() {
        }
    }
}

