/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class UnpackedObjectLoader
extends ObjectLoader {
    private final int objectType;
    private final int objectSize;
    private final byte[] bytes;

    public UnpackedObjectLoader(File path, AnyObjectId id) throws IOException {
        this(IO.readFully(path), id);
    }

    public UnpackedObjectLoader(byte[] compressed) throws CorruptObjectException {
        this(compressed, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnpackedObjectLoader(byte[] compressed, AnyObjectId id) throws CorruptObjectException {
        Inflater inflater = InflaterCache.get();
        try {
            int fb = compressed[0] & 0xFF;
            if (fb == 120 && (fb << 8 | compressed[1] & 0xFF) % 31 == 0) {
                int avail;
                inflater.setInput(compressed);
                byte[] hdr = new byte[64];
                for (avail = 0; !inflater.finished() && avail < hdr.length; avail += inflater.inflate(hdr, avail, hdr.length - avail)) {
                    try {
                        continue;
                    }
                    catch (DataFormatException dfe) {
                        CorruptObjectException coe = new CorruptObjectException(id, "bad stream");
                        coe.initCause(dfe);
                        inflater.end();
                        throw coe;
                    }
                }
                if (avail < 5) {
                    throw new CorruptObjectException(id, "no header");
                }
                MutableInteger p = new MutableInteger();
                this.objectType = Constants.decodeTypeString(id, hdr, (byte)32, p);
                this.objectSize = RawParseUtils.parseBase10(hdr, p.value, p);
                if (this.objectSize < 0) {
                    throw new CorruptObjectException(id, "negative size");
                }
                if (hdr[p.value++] != 0) {
                    throw new CorruptObjectException(id, "garbage after size");
                }
                this.bytes = new byte[this.objectSize];
                if (p.value < avail) {
                    System.arraycopy(hdr, p.value, this.bytes, 0, avail - p.value);
                }
                this.decompress(id, inflater, avail - p.value);
            } else {
                int p = 0;
                int c = compressed[p++] & 0xFF;
                int typeCode = c >> 4 & 7;
                int size = c & 0xF;
                int shift = 4;
                while ((c & 0x80) != 0) {
                    c = compressed[p++] & 0xFF;
                    size += (c & 0x7F) << shift;
                    shift += 7;
                }
                switch (typeCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.objectType = typeCode;
                        break;
                    }
                    default: {
                        throw new CorruptObjectException(id, "invalid type");
                    }
                }
                this.objectSize = size;
                this.bytes = new byte[this.objectSize];
                inflater.setInput(compressed, p, compressed.length - p);
                this.decompress(id, inflater, 0);
            }
        }
        finally {
            InflaterCache.release(inflater);
        }
    }

    private void decompress(AnyObjectId id, Inflater inf, int p) throws CorruptObjectException {
        try {
            while (!inf.finished()) {
                p += inf.inflate(this.bytes, p, this.objectSize - p);
            }
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException(id, "bad stream");
            coe.initCause(dfe);
            throw coe;
        }
        if (p != this.objectSize) {
            throw new CorruptObjectException(id, "incorrect length");
        }
    }

    public int getType() {
        return this.objectType;
    }

    public long getSize() {
        return this.objectSize;
    }

    public byte[] getCachedBytes() {
        return this.bytes;
    }

    public int getRawType() {
        return this.objectType;
    }

    public long getRawSize() {
        return this.objectSize;
    }
}

