/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.UnpackedObjectCache;
import org.eclipse.jgit.lib.WindowCursor;

class WholePackedObjectLoader
extends PackedObjectLoader {
    private static final int OBJ_COMMIT = 1;

    WholePackedObjectLoader(PackFile pr, long dataOffset, long objectOffset, int type, int size) {
        super(pr, dataOffset, objectOffset);
        this.objectType = type;
        this.objectSize = size;
    }

    public void materialize(WindowCursor curs) throws IOException {
        UnpackedObjectCache.Entry cache;
        if (this.cachedBytes != null) {
            return;
        }
        if (this.objectType != 1 && (cache = this.pack.readCache(this.dataOffset)) != null) {
            curs.release();
            this.cachedBytes = cache.data;
            return;
        }
        try {
            this.cachedBytes = this.pack.decompress(this.dataOffset, this.objectSize, curs);
            curs.release();
            if (this.objectType != 1) {
                this.pack.saveCache(this.dataOffset, this.cachedBytes, this.objectType);
            }
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException("Object at " + this.dataOffset + " in " + this.pack.getPackFile() + " has bad zlib stream");
            coe.initCause(dfe);
            throw coe;
        }
    }

    public int getRawType() {
        return this.objectType;
    }

    public long getRawSize() {
        return this.objectSize;
    }

    public ObjectId getDeltaBase() {
        return null;
    }
}

