/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jgit.lib.ByteWindow;
import org.eclipse.jgit.lib.OffsetCache;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.UnpackedObjectCache;
import org.eclipse.jgit.lib.WindowCacheConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowCache
extends OffsetCache<ByteWindow, WindowRef> {
    private static volatile WindowCache cache;
    private final int maxFiles;
    private final long maxBytes;
    private final boolean mmap;
    private final int windowSizeShift;
    private final int windowSize;
    private final AtomicInteger openFiles;
    private final AtomicLong openBytes;

    private static final int bits(int newSize) {
        if (newSize < 4096) {
            throw new IllegalArgumentException("Invalid window size");
        }
        if (Integer.bitCount(newSize) != 1) {
            throw new IllegalArgumentException("Window size must be power of 2");
        }
        return Integer.numberOfTrailingZeros(newSize);
    }

    public static void reconfigure(int packedGitLimit, int packedGitWindowSize, boolean packedGitMMAP, int deltaBaseCacheLimit) {
        WindowCacheConfig c = new WindowCacheConfig();
        c.setPackedGitLimit(packedGitLimit);
        c.setPackedGitWindowSize(packedGitWindowSize);
        c.setPackedGitMMAP(packedGitMMAP);
        c.setDeltaBaseCacheLimit(deltaBaseCacheLimit);
        WindowCache.reconfigure(c);
    }

    public static void reconfigure(WindowCacheConfig cfg) {
        WindowCache nc = new WindowCache(cfg);
        WindowCache oc = cache;
        if (oc != null) {
            oc.removeAll();
        }
        cache = nc;
        UnpackedObjectCache.reconfigure(cfg);
    }

    static WindowCache getInstance() {
        return cache;
    }

    static final ByteWindow get(PackFile pack, long offset) throws IOException {
        WindowCache c = cache;
        ByteWindow r = (ByteWindow)c.getOrLoad(pack, c.toStart(offset));
        if (c != cache) {
            c.removeAll();
        }
        return r;
    }

    static final void purge(PackFile pack) {
        cache.removeAll(pack);
    }

    private WindowCache(WindowCacheConfig cfg) {
        super(WindowCache.tableSize(cfg), WindowCache.lockCount(cfg));
        this.maxFiles = cfg.getPackedGitOpenFiles();
        this.maxBytes = cfg.getPackedGitLimit();
        this.mmap = cfg.isPackedGitMMAP();
        this.windowSizeShift = WindowCache.bits(cfg.getPackedGitWindowSize());
        this.windowSize = 1 << this.windowSizeShift;
        this.openFiles = new AtomicInteger();
        this.openBytes = new AtomicLong();
        if (this.maxFiles < 1) {
            throw new IllegalArgumentException("Open files must be >= 1");
        }
        if (this.maxBytes < (long)this.windowSize) {
            throw new IllegalArgumentException("Window size must be < limit");
        }
    }

    int getOpenFiles() {
        return this.openFiles.get();
    }

    long getOpenBytes() {
        return this.openBytes.get();
    }

    @Override
    protected int hash(int packHash, long off) {
        return packHash + (int)(off >>> this.windowSizeShift);
    }

    @Override
    protected ByteWindow load(PackFile pack, long offset) throws IOException {
        if (pack.beginWindowCache()) {
            this.openFiles.incrementAndGet();
        }
        try {
            if (this.mmap) {
                return pack.mmap(offset, this.windowSize);
            }
            return pack.read(offset, this.windowSize);
        }
        catch (IOException e) {
            this.close(pack);
            throw e;
        }
        catch (RuntimeException e) {
            this.close(pack);
            throw e;
        }
        catch (Error e) {
            this.close(pack);
            throw e;
        }
    }

    @Override
    protected WindowRef createRef(PackFile p, long o, ByteWindow v) {
        WindowRef ref = new WindowRef(p, o, v, this.queue);
        this.openBytes.addAndGet(ref.size);
        return ref;
    }

    @Override
    protected void clear(WindowRef ref) {
        this.openBytes.addAndGet(-ref.size);
        this.close(ref.pack);
    }

    private void close(PackFile pack) {
        if (pack.endWindowCache()) {
            this.openFiles.decrementAndGet();
        }
    }

    @Override
    protected boolean isFull() {
        return this.maxFiles < this.openFiles.get() || this.maxBytes < this.openBytes.get();
    }

    private long toStart(long offset) {
        return offset >>> this.windowSizeShift << this.windowSizeShift;
    }

    private static int tableSize(WindowCacheConfig cfg) {
        int wsz = cfg.getPackedGitWindowSize();
        long limit = cfg.getPackedGitLimit();
        if (wsz <= 0) {
            throw new IllegalArgumentException("Invalid window size");
        }
        if (limit < (long)wsz) {
            throw new IllegalArgumentException("Window size must be < limit");
        }
        return (int)Math.min(5L * (limit / (long)wsz) / 2L, 2000000000L);
    }

    private static int lockCount(WindowCacheConfig cfg) {
        return Math.max(cfg.getPackedGitOpenFiles(), 32);
    }

    static {
        WindowCache.reconfigure(new WindowCacheConfig());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WindowRef
    extends OffsetCache.Ref<ByteWindow> {
        final int size;

        WindowRef(PackFile pack, long position, ByteWindow v, ReferenceQueue<ByteWindow> queue) {
            super(pack, position, v, queue);
            this.size = v.size();
        }
    }
}

