/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseConnection
implements Connection {
    private Map<String, Ref> advertisedRefs = Collections.emptyMap();
    private boolean startedOperation;

    BaseConnection() {
    }

    @Override
    public Map<String, Ref> getRefsMap() {
        return this.advertisedRefs;
    }

    @Override
    public final Collection<Ref> getRefs() {
        return this.advertisedRefs.values();
    }

    @Override
    public final Ref getRef(String name) {
        return this.advertisedRefs.get(name);
    }

    @Override
    public abstract void close();

    protected void available(Map<String, Ref> all) {
        this.advertisedRefs = Collections.unmodifiableMap(all);
    }

    protected void markStartedOperation() throws TransportException {
        if (this.startedOperation) {
            throw new TransportException("Only one operation call per connection is supported.");
        }
        this.startedOperation = true;
    }
}

