/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BinaryDelta;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PackIndexWriter;
import org.eclipse.jgit.lib.PackLock;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.WindowCursor;
import org.eclipse.jgit.transport.LongMap;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPack {
    public static final String PROGRESS_DOWNLOAD = "Receiving objects";
    public static final String PROGRESS_RESOLVE_DELTA = "Resolving deltas";
    public static final int BUFFER_SIZE = 8192;
    private final Repository repo;
    private final ObjectDatabase objectDatabase;
    private Inflater inflater;
    private final MessageDigest objectDigest;
    private final MutableObjectId tempObjectId;
    private InputStream in;
    private byte[] buf;
    private long bBase;
    private int bOffset;
    private int bAvail;
    private ObjectChecker objCheck;
    private boolean fixThin;
    private boolean keepEmpty;
    private boolean needBaseObjectIds;
    private int outputVersion;
    private final File dstPack;
    private final File dstIdx;
    private long objectCount;
    private PackedObjectInfo[] entries;
    private Set<ObjectId> newObjectIds;
    private int deltaCount;
    private int entryCount;
    private final CRC32 crc = new CRC32();
    private ObjectIdSubclassMap<DeltaChain> baseById;
    private Set<ObjectId> baseIds;
    private LongMap<UnresolvedDelta> baseByPos;
    private byte[] objectData;
    private MessageDigest packDigest;
    private RandomAccessFile packOut;
    private byte[] packcsum;
    private long originalEOF;
    private WindowCursor readCurs;

    public static IndexPack create(Repository db, InputStream is) throws IOException {
        String suffix = ".pack";
        File objdir = db.getObjectsDirectory();
        File tmp = File.createTempFile("incoming_", ".pack", objdir);
        String n = tmp.getName();
        File base = new File(objdir, n.substring(0, n.length() - ".pack".length()));
        IndexPack ip = new IndexPack(db, is, base);
        ip.setIndexVersion(db.getConfig().getCore().getPackIndexVersion());
        return ip;
    }

    public IndexPack(Repository db, InputStream src, File dstBase) throws IOException {
        this.repo = db;
        this.objectDatabase = db.getObjectDatabase().newCachedDatabase();
        this.in = src;
        this.inflater = InflaterCache.get();
        this.readCurs = new WindowCursor();
        this.buf = new byte[8192];
        this.objectData = new byte[8192];
        this.objectDigest = Constants.newMessageDigest();
        this.tempObjectId = new MutableObjectId();
        this.packDigest = Constants.newMessageDigest();
        if (dstBase != null) {
            File dir = dstBase.getParentFile();
            String nam = dstBase.getName();
            this.dstPack = new File(dir, nam + ".pack");
            this.dstIdx = new File(dir, nam + ".idx");
            this.packOut = new RandomAccessFile(this.dstPack, "rw");
            this.packOut.setLength(0L);
        } else {
            this.dstPack = null;
            this.dstIdx = null;
        }
    }

    public void setIndexVersion(int version) {
        this.outputVersion = version;
    }

    public void setFixThin(boolean fix) {
        this.fixThin = fix;
    }

    public void setKeepEmpty(boolean empty) {
        this.keepEmpty = empty;
    }

    public void setNeedNewObjectIds(boolean b) {
        this.newObjectIds = b ? new HashSet<ObjectId>() : null;
    }

    private boolean needNewObjectIds() {
        return this.newObjectIds != null;
    }

    public void setNeedBaseObjectIds(boolean b) {
        this.needBaseObjectIds = b;
    }

    public Set<ObjectId> getNewObjectIds() {
        return this.newObjectIds == null ? Collections.emptySet() : this.newObjectIds;
    }

    public Set<ObjectId> getBaseObjectIds() {
        return this.baseIds == null ? Collections.emptySet() : this.baseIds;
    }

    public void setObjectChecker(ObjectChecker oc) {
        this.objCheck = oc;
    }

    public void setObjectChecking(boolean on) {
        this.setObjectChecker(on ? new ObjectChecker() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(ProgressMonitor progress) throws IOException {
        progress.start(2);
        try {
            Object v1;
            block22: {
                try {
                    this.readPackHeader();
                    this.entries = new PackedObjectInfo[(int)this.objectCount];
                    this.baseById = new ObjectIdSubclassMap();
                    this.baseByPos = new LongMap();
                    progress.beginTask(PROGRESS_DOWNLOAD, (int)this.objectCount);
                    int done = 0;
                    while ((long)done < this.objectCount) {
                        this.indexOneObject();
                        progress.update(1);
                        if (progress.isCancelled()) {
                            throw new IOException("Download cancelled");
                        }
                        ++done;
                    }
                    this.readPackFooter();
                    this.endInput();
                    progress.endTask();
                    if (this.deltaCount > 0) {
                        if (this.packOut == null) {
                            throw new IOException("need packOut");
                        }
                        this.resolveDeltas(progress);
                        if (this.needBaseObjectIds) {
                            this.baseIds = new HashSet<ObjectId>();
                            for (DeltaChain c : this.baseById) {
                                this.baseIds.add(c);
                            }
                        }
                        if ((long)this.entryCount < this.objectCount) {
                            if (!this.fixThin) {
                                throw new IOException("pack has " + (this.objectCount - (long)this.entryCount) + " unresolved deltas");
                            }
                            this.fixThinPack(progress);
                        }
                    }
                    if (this.packOut != null && (this.keepEmpty || this.entryCount > 0)) {
                        this.packOut.getChannel().force(true);
                    }
                    this.packDigest = null;
                    this.baseById = null;
                    this.baseByPos = null;
                    if (this.dstIdx != null && (this.keepEmpty || this.entryCount > 0)) {
                        this.writeIdx();
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var5_7 = null;
                    try {
                        InflaterCache.release(this.inflater);
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        v0 = null;
                    }
                    Object var7_11 = v0;
                    this.inflater = null;
                    this.objectDatabase.close();
                    throw throwable;
                }
                try {
                    InflaterCache.release(this.inflater);
                    v1 = null;
                    break block22;
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                {
                }
            }
            Object var7_10 = v1;
            this.inflater = null;
            this.objectDatabase.close();
            if (this.keepEmpty || this.entryCount > 0) {
                if (this.dstPack != null) {
                    this.dstPack.setReadOnly();
                }
                if (this.dstIdx != null) {
                    this.dstIdx.setReadOnly();
                }
            }
        }
        catch (IOException err) {
            if (this.dstPack != null) {
                this.dstPack.delete();
            }
            if (this.dstIdx != null) {
                this.dstIdx.delete();
            }
            throw err;
        }
    }

    private void resolveDeltas(ProgressMonitor progress) throws IOException {
        progress.beginTask(PROGRESS_RESOLVE_DELTA, this.deltaCount);
        int last = this.entryCount;
        for (int i = 0; i < last; ++i) {
            int before = this.entryCount;
            this.resolveDeltas(this.entries[i]);
            progress.update(this.entryCount - before);
            if (!progress.isCancelled()) continue;
            throw new IOException("Download cancelled during indexing");
        }
        progress.endTask();
    }

    private void resolveDeltas(PackedObjectInfo oe) throws IOException {
        int oldCRC = oe.getCRC();
        if (this.baseById.get(oe) != null || this.baseByPos.containsKey(oe.getOffset())) {
            this.resolveDeltas(oe.getOffset(), oldCRC, -1, null, oe);
        }
    }

    private void resolveDeltas(long pos, int oldCRC, int type, byte[] data, PackedObjectInfo oe) throws IOException {
        this.crc.reset();
        this.position(pos);
        int c = this.readFromFile();
        int typeCode = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFromFile();
            sz += (long)((c & 0x7F) << shift);
            shift += 7;
        }
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                type = typeCode;
                data = this.inflateFromFile((int)sz);
                break;
            }
            case 6: {
                c = this.readFromFile() & 0xFF;
                while ((c & 0x80) != 0) {
                    c = this.readFromFile() & 0xFF;
                }
                data = BinaryDelta.apply(data, this.inflateFromFile((int)sz));
                break;
            }
            case 7: {
                this.crc.update(this.buf, this.fillFromFile(20), 20);
                this.use(20);
                data = BinaryDelta.apply(data, this.inflateFromFile((int)sz));
                break;
            }
            default: {
                throw new IOException("Unknown object type " + typeCode + ".");
            }
        }
        int crc32 = (int)this.crc.getValue();
        if (oldCRC != crc32) {
            throw new IOException("Corruption detected re-reading at " + pos);
        }
        if (oe == null) {
            this.objectDigest.update(Constants.encodedTypeString(type));
            this.objectDigest.update((byte)32);
            this.objectDigest.update(Constants.encodeASCII(data.length));
            this.objectDigest.update((byte)0);
            this.objectDigest.update(data);
            this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
            this.verifySafeObject(this.tempObjectId, type, data);
            oe = new PackedObjectInfo(pos, crc32, this.tempObjectId);
            this.addObjectAndTrack(oe);
        }
        this.resolveChildDeltas(pos, type, data, oe);
    }

    private UnresolvedDelta removeBaseById(AnyObjectId id) {
        DeltaChain d = this.baseById.get(id);
        return d != null ? d.remove() : null;
    }

    private static UnresolvedDelta reverse(UnresolvedDelta c) {
        UnresolvedDelta tail = null;
        while (c != null) {
            UnresolvedDelta n = c.next;
            c.next = tail;
            tail = c;
            c = n;
        }
        return tail;
    }

    private void resolveChildDeltas(long pos, int type, byte[] data, PackedObjectInfo oe) throws IOException {
        UnresolvedDelta a = IndexPack.reverse(this.removeBaseById(oe));
        UnresolvedDelta b = IndexPack.reverse(this.baseByPos.remove(pos));
        while (a != null && b != null) {
            if (a.position < b.position) {
                this.resolveDeltas(a.position, a.crc, type, data, null);
                a = a.next;
                continue;
            }
            this.resolveDeltas(b.position, b.crc, type, data, null);
            b = b.next;
        }
        this.resolveChildDeltaChain(type, data, a);
        this.resolveChildDeltaChain(type, data, b);
    }

    private void resolveChildDeltaChain(int type, byte[] data, UnresolvedDelta a) throws IOException {
        while (a != null) {
            this.resolveDeltas(a.position, a.crc, type, data, null);
            a = a.next;
        }
    }

    private void fixThinPack(ProgressMonitor progress) throws IOException {
        this.growEntries();
        this.packDigest.reset();
        this.originalEOF = this.packOut.length() - 20L;
        Deflater def = new Deflater(-1, false);
        ArrayList<DeltaChain> missing = new ArrayList<DeltaChain>(64);
        long end = this.originalEOF;
        for (DeltaChain baseId : this.baseById) {
            if (baseId.head == null) continue;
            ObjectLoader ldr = this.repo.openObject(this.readCurs, baseId);
            if (ldr == null) {
                missing.add(baseId);
                continue;
            }
            byte[] data = ldr.getCachedBytes();
            int typeCode = ldr.getType();
            this.crc.reset();
            this.packOut.seek(end);
            this.writeWhole(def, typeCode, data);
            PackedObjectInfo oe = new PackedObjectInfo(end, (int)this.crc.getValue(), baseId);
            this.entries[this.entryCount++] = oe;
            end = this.packOut.getFilePointer();
            this.resolveChildDeltas(oe.getOffset(), typeCode, data, oe);
            if (!progress.isCancelled()) continue;
            throw new IOException("Download cancelled during indexing");
        }
        def.end();
        for (DeltaChain base : missing) {
            if (base.head == null) continue;
            throw new MissingObjectException((ObjectId)base, "delta base");
        }
        this.fixHeaderFooter(this.packcsum, this.packDigest.digest());
    }

    private void writeWhole(Deflater def, int typeCode, byte[] data) throws IOException {
        int sz = data.length;
        int hdrlen = 0;
        this.buf[hdrlen++] = (byte)(typeCode << 4 | sz & 0xF);
        sz >>>= 4;
        while (sz > 0) {
            int n = hdrlen - 1;
            this.buf[n] = (byte)(this.buf[n] | 0x80);
            this.buf[hdrlen++] = (byte)(sz & 0x7F);
            sz >>>= 7;
        }
        this.packDigest.update(this.buf, 0, hdrlen);
        this.crc.update(this.buf, 0, hdrlen);
        this.packOut.write(this.buf, 0, hdrlen);
        def.reset();
        def.setInput(data);
        def.finish();
        while (!def.finished()) {
            int datlen = def.deflate(this.buf);
            this.packDigest.update(this.buf, 0, datlen);
            this.crc.update(this.buf, 0, datlen);
            this.packOut.write(this.buf, 0, datlen);
        }
    }

    private void fixHeaderFooter(byte[] origcsum, byte[] tailcsum) throws IOException {
        int n;
        MessageDigest origDigest = Constants.newMessageDigest();
        MessageDigest tailDigest = Constants.newMessageDigest();
        long origRemaining = this.originalEOF;
        this.packOut.seek(0L);
        this.bAvail = 0;
        this.bOffset = 0;
        this.fillFromFile(12);
        int origCnt = (int)Math.min((long)this.bAvail, origRemaining);
        origDigest.update(this.buf, 0, origCnt);
        if ((origRemaining -= (long)origCnt) == 0L) {
            tailDigest.update(this.buf, origCnt, this.bAvail - origCnt);
        }
        NB.encodeInt32(this.buf, 8, this.entryCount);
        this.packOut.seek(0L);
        this.packOut.write(this.buf, 0, 12);
        this.packOut.seek(this.bAvail);
        this.packDigest.reset();
        this.packDigest.update(this.buf, 0, this.bAvail);
        while ((n = this.packOut.read(this.buf)) >= 0) {
            if (origRemaining != 0L) {
                int origCnt2 = (int)Math.min((long)n, origRemaining);
                origDigest.update(this.buf, 0, origCnt2);
                if ((origRemaining -= (long)origCnt2) == 0L) {
                    tailDigest.update(this.buf, origCnt2, n - origCnt2);
                }
            } else {
                tailDigest.update(this.buf, 0, n);
            }
            this.packDigest.update(this.buf, 0, n);
        }
        if (!Arrays.equals(origDigest.digest(), origcsum) || !Arrays.equals(tailDigest.digest(), tailcsum)) {
            throw new IOException("Pack corrupted while writing to filesystem");
        }
        this.packcsum = this.packDigest.digest();
        this.packOut.write(this.packcsum);
    }

    private void growEntries() {
        PackedObjectInfo[] ne = new PackedObjectInfo[(int)this.objectCount + this.baseById.size()];
        System.arraycopy(this.entries, 0, ne, 0, this.entryCount);
        this.entries = ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIdx() throws IOException {
        Arrays.sort(this.entries, 0, this.entryCount);
        List<PackedObjectInfo> list = Arrays.asList(this.entries);
        if (this.entryCount < this.entries.length) {
            list = list.subList(0, this.entryCount);
        }
        FileOutputStream os = new FileOutputStream(this.dstIdx);
        try {
            PackIndexWriter iw = this.outputVersion <= 0 ? PackIndexWriter.createOldestPossible(os, list) : PackIndexWriter.createVersion(os, this.outputVersion);
            iw.write(list, this.packcsum);
            os.getChannel().force(true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    private void readPackHeader() throws IOException {
        int hdrln = Constants.PACK_SIGNATURE.length + 4 + 4;
        int p = this.fillFromInput(hdrln);
        for (int k = 0; k < Constants.PACK_SIGNATURE.length; ++k) {
            if (this.buf[p + k] == Constants.PACK_SIGNATURE[k]) continue;
            throw new IOException("Not a PACK file.");
        }
        long vers = NB.decodeUInt32(this.buf, p + 4);
        if (vers != 2L && vers != 3L) {
            throw new IOException("Unsupported pack version " + vers + ".");
        }
        this.objectCount = NB.decodeUInt32(this.buf, p + 8);
        this.use(hdrln);
    }

    private void readPackFooter() throws IOException {
        this.sync();
        byte[] cmpcsum = this.packDigest.digest();
        int c = this.fillFromInput(20);
        this.packcsum = new byte[20];
        System.arraycopy(this.buf, c, this.packcsum, 0, 20);
        this.use(20);
        if (this.packOut != null) {
            this.packOut.write(this.packcsum);
        }
        if (!Arrays.equals(cmpcsum, this.packcsum)) {
            throw new CorruptObjectException("Packfile checksum incorrect.");
        }
    }

    private void endInput() {
        this.in = null;
        this.objectData = null;
    }

    private void indexOneObject() throws IOException {
        long pos = this.position();
        this.crc.reset();
        int c = this.readFromInput();
        int typeCode = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFromInput();
            sz += (long)((c & 0x7F) << shift);
            shift += 7;
        }
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.whole(typeCode, pos, sz);
                break;
            }
            case 6: {
                c = this.readFromInput();
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = this.readFromInput();
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                long base = pos - ofs;
                this.skipInflateFromInput(sz);
                UnresolvedDelta n = new UnresolvedDelta(pos, (int)this.crc.getValue());
                n.next = this.baseByPos.put(base, n);
                ++this.deltaCount;
                break;
            }
            case 7: {
                c = this.fillFromInput(20);
                this.crc.update(this.buf, c, 20);
                ObjectId base = ObjectId.fromRaw(this.buf, c);
                this.use(20);
                DeltaChain r = this.baseById.get(base);
                if (r == null) {
                    r = new DeltaChain(base);
                    this.baseById.add(r);
                }
                this.skipInflateFromInput(sz);
                r.add(new UnresolvedDelta(pos, (int)this.crc.getValue()));
                ++this.deltaCount;
                break;
            }
            default: {
                throw new IOException("Unknown object type " + typeCode + ".");
            }
        }
    }

    private void whole(int type, long pos, long sz) throws IOException {
        byte[] data = this.inflateFromInput(sz);
        this.objectDigest.update(Constants.encodedTypeString(type));
        this.objectDigest.update((byte)32);
        this.objectDigest.update(Constants.encodeASCII(sz));
        this.objectDigest.update((byte)0);
        this.objectDigest.update(data);
        this.tempObjectId.fromRaw(this.objectDigest.digest(), 0);
        this.verifySafeObject(this.tempObjectId, type, data);
        int crc32 = (int)this.crc.getValue();
        this.addObjectAndTrack(new PackedObjectInfo(pos, crc32, this.tempObjectId));
    }

    private void verifySafeObject(AnyObjectId id, int type, byte[] data) throws IOException {
        ObjectLoader ldr;
        if (this.objCheck != null) {
            try {
                this.objCheck.check(type, data);
            }
            catch (CorruptObjectException e) {
                throw new IOException("Invalid " + Constants.typeString(type) + " " + id.name() + ":" + e.getMessage());
            }
        }
        if ((ldr = this.objectDatabase.openObject(this.readCurs, id)) != null) {
            byte[] existingData = ldr.getCachedBytes();
            if (ldr.getType() != type || !Arrays.equals(data, existingData)) {
                throw new IOException("Collision on " + id.name());
            }
        }
    }

    private long position() {
        return this.bBase + (long)this.bOffset;
    }

    private void position(long pos) throws IOException {
        this.packOut.seek(pos);
        this.bBase = pos;
        this.bOffset = 0;
        this.bAvail = 0;
    }

    private int readFromInput() throws IOException {
        if (this.bAvail == 0) {
            this.fillFromInput(1);
        }
        --this.bAvail;
        int b = this.buf[this.bOffset++] & 0xFF;
        this.crc.update(b);
        return b;
    }

    private int readFromFile() throws IOException {
        if (this.bAvail == 0) {
            this.fillFromFile(1);
        }
        --this.bAvail;
        int b = this.buf[this.bOffset++] & 0xFF;
        this.crc.update(b);
        return b;
    }

    private void use(int cnt) {
        this.bOffset += cnt;
        this.bAvail -= cnt;
    }

    private int fillFromInput(int need) throws IOException {
        while (this.bAvail < need) {
            int next = this.bOffset + this.bAvail;
            int free = this.buf.length - next;
            if (free + this.bAvail < need) {
                this.sync();
                next = this.bAvail;
                free = this.buf.length - next;
            }
            if ((next = this.in.read(this.buf, next, free)) <= 0) {
                throw new EOFException("Packfile is truncated.");
            }
            this.bAvail += next;
        }
        return this.bOffset;
    }

    private int fillFromFile(int need) throws IOException {
        if (this.bAvail < need) {
            int next = this.bOffset + this.bAvail;
            int free = this.buf.length - next;
            if (free + this.bAvail < need) {
                if (this.bAvail > 0) {
                    System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
                }
                this.bOffset = 0;
                next = this.bAvail;
                free = this.buf.length - next;
            }
            if ((next = this.packOut.read(this.buf, next, free)) <= 0) {
                throw new EOFException("Packfile is truncated.");
            }
            this.bAvail += next;
        }
        return this.bOffset;
    }

    private void sync() throws IOException {
        this.packDigest.update(this.buf, 0, this.bOffset);
        if (this.packOut != null) {
            this.packOut.write(this.buf, 0, this.bOffset);
        }
        if (this.bAvail > 0) {
            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
        }
        this.bBase += (long)this.bOffset;
        this.bOffset = 0;
    }

    private void skipInflateFromInput(long sz) throws IOException {
        Inflater inf = this.inflater;
        try {
            block9: {
                try {
                    byte[] dst = this.objectData;
                    int n = 0;
                    int p = -1;
                    while (!inf.finished()) {
                        int free;
                        if (inf.needsInput()) {
                            if (p >= 0) {
                                this.crc.update(this.buf, p, this.bAvail);
                                this.use(this.bAvail);
                            }
                            p = this.fillFromInput(1);
                            inf.setInput(this.buf, p, this.bAvail);
                        }
                        if ((free = dst.length - n) < 8) {
                            sz -= (long)n;
                            n = 0;
                            free = dst.length;
                        }
                        n += inf.inflate(dst, n, free);
                    }
                    if ((long)n != sz) {
                        throw new DataFormatException("wrong decompressed length");
                    }
                    n = this.bAvail - inf.getRemaining();
                    if (n <= 0) break block9;
                    this.crc.update(this.buf, p, n);
                    this.use(n);
                }
                catch (DataFormatException dfe) {
                    throw IndexPack.corrupt(dfe);
                }
            }
            Object var9_8 = null;
            inf.reset();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            inf.reset();
            throw throwable;
        }
    }

    private byte[] inflateFromInput(long sz) throws IOException {
        byte[] dst = new byte[(int)sz];
        Inflater inf = this.inflater;
        try {
            int n = 0;
            int p = -1;
            while (!inf.finished()) {
                if (inf.needsInput()) {
                    if (p >= 0) {
                        this.crc.update(this.buf, p, this.bAvail);
                        this.use(this.bAvail);
                    }
                    p = this.fillFromInput(1);
                    inf.setInput(this.buf, p, this.bAvail);
                }
                n += inf.inflate(dst, n, dst.length - n);
            }
            if ((long)n != sz) {
                throw new DataFormatException("wrong decompressed length");
            }
            n = this.bAvail - inf.getRemaining();
            if (n > 0) {
                this.crc.update(this.buf, p, n);
                this.use(n);
            }
            byte[] byArray = dst;
            Object var9_8 = null;
            inf.reset();
            return byArray;
        }
        catch (DataFormatException dfe) {
            try {
                throw IndexPack.corrupt(dfe);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                inf.reset();
                throw throwable;
            }
        }
    }

    private byte[] inflateFromFile(int sz) throws IOException {
        Inflater inf = this.inflater;
        try {
            byte[] dst = new byte[sz];
            int n = 0;
            int p = -1;
            while (!inf.finished()) {
                if (inf.needsInput()) {
                    if (p >= 0) {
                        this.crc.update(this.buf, p, this.bAvail);
                        this.use(this.bAvail);
                    }
                    p = this.fillFromFile(1);
                    inf.setInput(this.buf, p, this.bAvail);
                }
                n += inf.inflate(dst, n, sz - n);
            }
            n = this.bAvail - inf.getRemaining();
            if (n > 0) {
                this.crc.update(this.buf, p, n);
                this.use(n);
            }
            byte[] byArray = dst;
            Object var8_8 = null;
            inf.reset();
            return byArray;
        }
        catch (DataFormatException dfe) {
            try {
                throw IndexPack.corrupt(dfe);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                inf.reset();
                throw throwable;
            }
        }
    }

    private static CorruptObjectException corrupt(DataFormatException dfe) {
        return new CorruptObjectException("Packfile corruption detected: " + dfe.getMessage());
    }

    public void renameAndOpenPack() throws IOException {
        this.renameAndOpenPack(null);
    }

    public PackLock renameAndOpenPack(String lockMessage) throws IOException {
        if (!this.keepEmpty && this.entryCount == 0) {
            this.cleanupTemporaryFiles();
            return null;
        }
        MessageDigest d = Constants.newMessageDigest();
        byte[] oeBytes = new byte[20];
        for (int i = 0; i < this.entryCount; ++i) {
            PackedObjectInfo oe = this.entries[i];
            oe.copyRawTo(oeBytes, 0);
            d.update(oeBytes);
        }
        String name = ObjectId.fromRaw(d.digest()).name();
        File packDir = new File(this.repo.getObjectsDirectory(), "pack");
        File finalPack = new File(packDir, "pack-" + name + ".pack");
        File finalIdx = new File(packDir, "pack-" + name + ".idx");
        PackLock keep = new PackLock(finalPack);
        if (!(packDir.exists() || packDir.mkdir() || packDir.exists())) {
            this.cleanupTemporaryFiles();
            throw new IOException("Cannot create " + packDir.getAbsolutePath());
        }
        if (finalPack.exists()) {
            this.cleanupTemporaryFiles();
            return null;
        }
        if (lockMessage != null) {
            try {
                if (!keep.lock(lockMessage)) {
                    throw new IOException("Cannot lock pack in " + finalPack);
                }
            }
            catch (IOException e) {
                this.cleanupTemporaryFiles();
                throw e;
            }
        }
        if (!this.dstPack.renameTo(finalPack)) {
            this.cleanupTemporaryFiles();
            keep.unlock();
            throw new IOException("Cannot move pack to " + finalPack);
        }
        if (!this.dstIdx.renameTo(finalIdx)) {
            this.cleanupTemporaryFiles();
            keep.unlock();
            if (!finalPack.delete()) {
                finalPack.deleteOnExit();
            }
            throw new IOException("Cannot move index to " + finalIdx);
        }
        try {
            this.repo.openPack(finalPack, finalIdx);
        }
        catch (IOException err) {
            keep.unlock();
            finalPack.delete();
            finalIdx.delete();
            throw err;
        }
        return lockMessage != null ? keep : null;
    }

    private void cleanupTemporaryFiles() {
        if (!this.dstIdx.delete()) {
            this.dstIdx.deleteOnExit();
        }
        if (!this.dstPack.delete()) {
            this.dstPack.deleteOnExit();
        }
    }

    private void addObjectAndTrack(PackedObjectInfo oe) {
        this.entries[this.entryCount++] = oe;
        if (this.needNewObjectIds()) {
            this.newObjectIds.add(oe);
        }
    }

    private static class UnresolvedDelta {
        final long position;
        final int crc;
        UnresolvedDelta next;

        UnresolvedDelta(long headerOffset, int crc32) {
            this.position = headerOffset;
            this.crc = crc32;
        }
    }

    private static class DeltaChain
    extends ObjectId {
        UnresolvedDelta head;

        DeltaChain(AnyObjectId id) {
            super(id);
        }

        UnresolvedDelta remove() {
            UnresolvedDelta r = this.head;
            if (r != null) {
                this.head = null;
            }
            return r;
        }

        void add(UnresolvedDelta d) {
            d.next = this.head;
            this.head = d;
        }
    }
}

