/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.AmazonS3;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkPushConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.util.FS;

public class TransportAmazonS3
extends HttpTransport
implements WalkTransport {
    static final String S3_SCHEME = "amazon-s3";
    private final AmazonS3 s3;
    private final String bucket;
    private final String keyPrefix;

    static boolean canHandle(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        return S3_SCHEME.equals(uri.getScheme());
    }

    TransportAmazonS3(Repository local, URIish uri) throws NotSupportedException {
        super(local, uri);
        Properties props = null;
        File propsFile = new File(local.getDirectory(), uri.getUser());
        if (!propsFile.isFile()) {
            propsFile = new File(FS.userHome(), uri.getUser());
        }
        if (propsFile.isFile()) {
            try {
                props = AmazonS3.properties(propsFile);
            }
            catch (IOException e) {
                throw new NotSupportedException("cannot read " + propsFile, e);
            }
        } else {
            props = new Properties();
            props.setProperty("accesskey", uri.getUser());
            props.setProperty("secretkey", uri.getPass());
        }
        this.s3 = new AmazonS3(props);
        this.bucket = uri.getHost();
        String p = uri.getPath();
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        this.keyPrefix = p;
    }

    public FetchConnection openFetch() throws TransportException {
        DatabaseS3 c = new DatabaseS3(this.bucket, this.keyPrefix + "/objects");
        WalkFetchConnection r = new WalkFetchConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public PushConnection openPush() throws TransportException {
        DatabaseS3 c = new DatabaseS3(this.bucket, this.keyPrefix + "/objects");
        WalkPushConnection r = new WalkPushConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatabaseS3
    extends WalkRemoteObjectDatabase {
        private final String bucketName;
        private final String objectsKey;

        DatabaseS3(String b, String o) {
            this.bucketName = b;
            this.objectsKey = o;
        }

        private String resolveKey(String subpath) {
            if (subpath.endsWith("/")) {
                subpath = subpath.substring(0, subpath.length() - 1);
            }
            String k = this.objectsKey;
            while (subpath.startsWith("../")) {
                k = k.substring(0, k.lastIndexOf(47));
                subpath = subpath.substring(3);
            }
            return k + "/" + subpath;
        }

        @Override
        URIish getURI() {
            URIish u = new URIish();
            u = u.setScheme(TransportAmazonS3.S3_SCHEME);
            u = u.setHost(this.bucketName);
            u = u.setPath("/" + this.objectsKey);
            return u;
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/alternates");
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new DatabaseS3(this.bucketName, this.resolveKey(location));
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            HashSet<String> have = new HashSet<String>();
            have.addAll(TransportAmazonS3.this.s3.list(TransportAmazonS3.this.bucket, this.resolveKey("pack")));
            ArrayList<String> packs = new ArrayList<String>();
            for (String n : have) {
                String in;
                if (!n.startsWith("pack-") || !n.endsWith(".pack") || !have.contains(in = n.substring(0, n.length() - 5) + ".idx")) continue;
                packs.add(n);
            }
            return packs;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path) throws IOException {
            URLConnection c = TransportAmazonS3.this.s3.get(TransportAmazonS3.this.bucket, this.resolveKey(path));
            InputStream raw = c.getInputStream();
            InputStream in = TransportAmazonS3.this.s3.decrypt(c);
            int len = c.getContentLength();
            return new WalkRemoteObjectDatabase.FileStream(in, raw == in ? (long)len : -1L);
        }

        @Override
        void deleteFile(String path) throws IOException {
            TransportAmazonS3.this.s3.delete(TransportAmazonS3.this.bucket, this.resolveKey(path));
        }

        @Override
        OutputStream writeFile(String path, ProgressMonitor monitor, String monitorTask) throws IOException {
            return TransportAmazonS3.this.s3.beginPut(TransportAmazonS3.this.bucket, this.resolveKey(path), monitor, monitorTask);
        }

        @Override
        void writeFile(String path, byte[] data) throws IOException {
            TransportAmazonS3.this.s3.put(TransportAmazonS3.this.bucket, this.resolveKey(path), data);
        }

        Map<String, Ref> readAdvertisedRefs() throws TransportException {
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            this.readPackedRefs(avail);
            this.readLooseRefs(avail);
            this.readRef(avail, "HEAD");
            return avail;
        }

        private void readLooseRefs(TreeMap<String, Ref> avail) throws TransportException {
            try {
                for (String n : TransportAmazonS3.this.s3.list(TransportAmazonS3.this.bucket, this.resolveKey("../refs"))) {
                    this.readRef(avail, "refs/" + n);
                }
            }
            catch (IOException e) {
                throw new TransportException(this.getURI(), "cannot list refs", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ref readRef(TreeMap<String, Ref> avail, String rn) throws TransportException {
            String s;
            String ref = "../" + rn;
            try {
                BufferedReader br = this.openReader(ref);
                try {
                    s = br.readLine();
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    br.close();
                    throw throwable;
                }
                br.close();
                {
                }
            }
            catch (FileNotFoundException noRef) {
                return null;
            }
            catch (IOException err) {
                throw new TransportException(this.getURI(), "read " + ref, err);
            }
            if (s == null) {
                throw new TransportException(this.getURI(), "Empty ref: " + rn);
            }
            if (s.startsWith("ref: ")) {
                String target = s.substring("ref: ".length());
                Ref r = avail.get(target);
                if (r == null) {
                    r = this.readRef(avail, target);
                }
                if (r == null) {
                    r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                }
                r = new SymbolicRef(rn, r);
                avail.put(r.getName(), r);
                return r;
            }
            if (ObjectId.isId(s)) {
                ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(this.loose(avail.get(rn)), rn, ObjectId.fromString(s));
                avail.put(r.getName(), r);
                return r;
            }
            throw new TransportException(this.getURI(), "Bad ref: " + rn + ": " + s);
        }

        private Ref.Storage loose(Ref r) {
            if (r != null && r.getStorage() == Ref.Storage.PACKED) {
                return Ref.Storage.LOOSE_PACKED;
            }
            return Ref.Storage.LOOSE;
        }

        @Override
        void close() {
        }
    }
}

