/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.util.FS;

class TransportLocal
extends Transport
implements PackTransport {
    private static final String PWD = ".";
    private final File remoteGitDir;

    static boolean canHandle(URIish uri) {
        if (uri.getHost() != null || uri.getPort() > 0 || uri.getUser() != null || uri.getPass() != null || uri.getPath() == null) {
            return false;
        }
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            return FS.resolve(new File(PWD), uri.getPath()).isDirectory();
        }
        return false;
    }

    TransportLocal(Repository local, URIish uri) {
        super(local, uri);
        File d = FS.resolve(new File(PWD), uri.getPath()).getAbsoluteFile();
        if (new File(d, ".git").isDirectory()) {
            d = new File(d, ".git");
        }
        this.remoteGitDir = d;
    }

    public FetchConnection openFetch() throws TransportException {
        String up = this.getOptionUploadPack();
        if ("git-upload-pack".equals(up) || "git upload-pack".equals(up)) {
            return new InternalLocalFetchConnection();
        }
        return new ForkLocalFetchConnection();
    }

    public PushConnection openPush() throws NotSupportedException, TransportException {
        String rp = this.getOptionReceivePack();
        if ("git-receive-pack".equals(rp) || "git receive-pack".equals(rp)) {
            return new InternalLocalPushConnection();
        }
        return new ForkLocalPushConnection();
    }

    public void close() {
    }

    protected Process startProcessWithErrStream(String cmd) throws TransportException {
        try {
            String[] args;
            if (cmd.startsWith("git-")) {
                args = new String[]{"git", cmd.substring(4), PWD};
            } else {
                int gitspace = cmd.indexOf("git ");
                if (gitspace >= 0) {
                    String git = cmd.substring(0, gitspace + 3);
                    String subcmd = cmd.substring(gitspace + 4);
                    args = new String[]{git, subcmd, PWD};
                } else {
                    args = new String[]{cmd, PWD};
                }
            }
            Process proc = Runtime.getRuntime().exec(args, null, this.remoteGitDir);
            new StreamRewritingThread(cmd, proc.getErrorStream()).start();
            return proc;
        }
        catch (IOException err) {
            throw new TransportException(this.uri, err.getMessage(), err);
        }
    }

    static class StreamRewritingThread
    extends Thread {
        private final InputStream in;

        StreamRewritingThread(String cmd, InputStream in) {
            super("JGit " + cmd + " Errors");
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block9: {
                int n;
                byte[] tmp = new byte[512];
                while ((n = this.in.read(tmp)) >= 0) {
                    System.err.write(tmp, 0, n);
                    System.err.flush();
                }
                Object var4_4 = null;
                try {
                    this.in.close();
                }
                catch (IOException err2) {}
                break block9;
                {
                    catch (IOException iOException) {
                        Object var4_5 = null;
                        try {
                            this.in.close();
                        }
                        catch (IOException err2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    try {
                        this.in.close();
                    }
                    catch (IOException err2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    class ForkLocalPushConnection
    extends BasePackPushConnection {
        private Process receivePack;

        ForkLocalPushConnection() throws TransportException {
            super(TransportLocal.this);
            this.receivePack = TransportLocal.this.startProcessWithErrStream(TransportLocal.this.getOptionReceivePack());
            InputStream rpIn = this.receivePack.getInputStream();
            OutputStream rpOut = this.receivePack.getOutputStream();
            this.init(rpIn, rpOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.receivePack != null) {
                try {
                    try {
                        this.receivePack.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.receivePack = null;
                    }
                    Object var3_1 = null;
                    this.receivePack = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.receivePack = null;
                    throw throwable;
                }
            }
        }
    }

    class InternalLocalPushConnection
    extends BasePackPushConnection {
        private Thread worker;

        InternalLocalPushConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            Repository dst;
            super(TransportLocal.this);
            try {
                dst = new Repository(TransportLocal.this.remoteGitDir);
            }
            catch (IOException err) {
                throw new TransportException(this.uri, "not a git directory");
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream();
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                dst.close();
                throw new TransportException(this.uri, "cannot connect pipes", err);
            }
            this.worker = new Thread("JGit-Receive-Pack"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block17: {
                        ReceivePack rp = new ReceivePack(dst);
                        rp.receive(out_r, in_w, System.err);
                        Object var3_4 = null;
                        try {
                            out_r.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        dst.close();
                        {
                            break block17;
                            catch (IOException err) {
                                Object var3_5 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                                break block17;
                            }
                            catch (RuntimeException runtimeException) {
                                Object var3_6 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_7 = null;
                            try {
                                out_r.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                in_w.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            dst.close();
                            throw throwable;
                        }
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    try {
                        this.worker.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.worker = null;
                    }
                    Object var3_1 = null;
                    this.worker = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.worker = null;
                    throw throwable;
                }
            }
        }
    }

    class ForkLocalFetchConnection
    extends BasePackFetchConnection {
        private Process uploadPack;

        ForkLocalFetchConnection() throws TransportException {
            super(TransportLocal.this);
            this.uploadPack = TransportLocal.this.startProcessWithErrStream(TransportLocal.this.getOptionUploadPack());
            InputStream upIn = this.uploadPack.getInputStream();
            OutputStream upOut = this.uploadPack.getOutputStream();
            this.init(upIn, upOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.uploadPack != null) {
                try {
                    try {
                        this.uploadPack.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.uploadPack = null;
                    }
                    Object var3_1 = null;
                    this.uploadPack = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.uploadPack = null;
                    throw throwable;
                }
            }
        }
    }

    class InternalLocalFetchConnection
    extends BasePackFetchConnection {
        private Thread worker;

        InternalLocalFetchConnection() throws TransportException {
            PipedOutputStream out_w;
            PipedInputStream out_r;
            PipedOutputStream in_w;
            PipedInputStream in_r;
            Repository dst;
            super(TransportLocal.this);
            try {
                dst = new Repository(TransportLocal.this.remoteGitDir);
            }
            catch (IOException err) {
                throw new TransportException(this.uri, "not a git directory");
            }
            try {
                in_r = new PipedInputStream();
                in_w = new PipedOutputStream(in_r);
                out_r = new PipedInputStream(){
                    {
                        this.buffer = new byte[2952];
                    }
                };
                out_w = new PipedOutputStream(out_r);
            }
            catch (IOException err) {
                dst.close();
                throw new TransportException(this.uri, "cannot connect pipes", err);
            }
            this.worker = new Thread("JGit-Upload-Pack"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block17: {
                        UploadPack rp = new UploadPack(dst);
                        rp.upload(out_r, in_w, null);
                        Object var3_4 = null;
                        try {
                            out_r.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        dst.close();
                        {
                            break block17;
                            catch (IOException err) {
                                err.printStackTrace();
                                Object var3_5 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                                break block17;
                            }
                            catch (RuntimeException err) {
                                err.printStackTrace();
                                Object var3_6 = null;
                                try {
                                    out_r.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                try {
                                    in_w.close();
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                dst.close();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_7 = null;
                            try {
                                out_r.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                in_w.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            dst.close();
                            throw throwable;
                        }
                    }
                }
            };
            this.worker.start();
            this.init(in_r, out_w);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.worker != null) {
                try {
                    try {
                        this.worker.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var3_2 = null;
                        this.worker = null;
                    }
                    Object var3_1 = null;
                    this.worker = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.worker = null;
                    throw throwable;
                }
            }
        }
    }
}

