/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    protected static final Entry[] EOF = new Entry[0];
    private static final int BUFFER_SIZE = 2048;
    private byte[] contentId;
    private int contentIdFromPtr;
    private byte[] contentReadBuffer;
    private MessageDigest contentDigest;
    private final CharsetEncoder nameEncoder;
    private Entry[] entries;
    private int entryCnt;
    private int ptr;
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator<Entry> ENTRY_CMP = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            int cPos;
            byte[] a = o1.encodedName;
            byte[] b = o2.encodedName;
            int aLen = o1.encodedNameLen;
            int bLen = o2.encodedNameLen;
            for (cPos = 0; cPos < aLen && cPos < bLen; ++cPos) {
                int cmp = (a[cPos] & 0xFF) - (b[cPos] & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            if (cPos < aLen) {
                return (a[cPos] & 0xFF) - WorkingTreeIterator.lastPathChar(o2);
            }
            if (cPos < bLen) {
                return WorkingTreeIterator.lastPathChar(o1) - (b[cPos] & 0xFF);
            }
            return WorkingTreeIterator.lastPathChar(o1) - WorkingTreeIterator.lastPathChar(o2);
        }
    };

    protected WorkingTreeIterator() {
        this.nameEncoder = Constants.CHARSET.newEncoder();
    }

    protected WorkingTreeIterator(String prefix) {
        super(prefix);
        this.nameEncoder = Constants.CHARSET.newEncoder();
    }

    protected WorkingTreeIterator(WorkingTreeIterator p) {
        super(p);
        this.nameEncoder = p.nameEncoder;
    }

    public byte[] idBuffer() {
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        switch (this.mode & 0xF000) {
            case 32768: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 40960: {
                return zeroid;
            }
            case 57344: {
                return zeroid;
            }
        }
        return zeroid;
    }

    private void initializeDigest() {
        if (this.contentDigest != null) {
            return;
        }
        if (this.parent == null) {
            this.contentReadBuffer = new byte[2048];
            this.contentDigest = Constants.newMessageDigest();
        } else {
            WorkingTreeIterator p = (WorkingTreeIterator)this.parent;
            p.initializeDigest();
            this.contentReadBuffer = p.contentReadBuffer;
            this.contentDigest = p.contentDigest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private byte[] idBufferBlob(Entry e) {
        try {
            byte[] byArray;
            int r;
            long blobLength;
            InputStream is = e.openInputStream();
            if (is == null) {
                return zeroid;
            }
            this.initializeDigest();
            this.contentDigest.reset();
            this.contentDigest.update(hblob);
            this.contentDigest.update((byte)32);
            long sz = blobLength = e.getLength();
            if (sz == 0L) {
                this.contentDigest.update((byte)48);
            } else {
                int bufn;
                int p = bufn = this.contentReadBuffer.length;
                do {
                    this.contentReadBuffer[--p] = digits[(int)(sz % 10L)];
                } while ((sz /= 10L) > 0L);
                this.contentDigest.update(this.contentReadBuffer, p, bufn - p);
            }
            this.contentDigest.update((byte)0);
            while ((r = is.read(this.contentReadBuffer)) > 0) {
                this.contentDigest.update(this.contentReadBuffer, 0, r);
                sz += (long)r;
            }
            if (sz == blobLength) break block14;
            byte[] byArray2 = zeroid;
            Object var10_10 = null;
            try {
                is.close();
            }
            catch (IOException err2) {
                // empty catch block
            }
            {
                block14: {
                    return byArray2;
                }
                byArray = this.contentDigest.digest();
            }
            Object var10_11 = null;
            try {
                is.close();
            }
            catch (IOException err2) {
                // empty catch block
            }
            return byArray;
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    is.close();
                }
                catch (IOException err2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (IOException err) {
            return zeroid;
        }
    }

    public int idOffset() {
        return 0;
    }

    public boolean first() {
        return this.ptr == 0;
    }

    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    public void next(int delta) throws CorruptObjectException {
        this.ptr += delta;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    public void back(int delta) throws CorruptObjectException {
        this.ptr -= delta;
        this.parseEntry();
    }

    private void parseEntry() {
        Entry e = this.entries[this.ptr];
        this.mode = e.getMode().getBits();
        int nameLen = e.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + nameLen, this.pathOffset);
        System.arraycopy(e.encodedName, 0, this.path, this.pathOffset, nameLen);
        this.pathLen = this.pathOffset + nameLen;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    public long getEntryLastModified() {
        return this.current().getLastModified();
    }

    static int lastPathChar(Entry e) {
        return e.getMode() == FileMode.TREE ? 47 : 0;
    }

    protected void init(Entry[] list) {
        this.entries = list;
        int o = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            String name;
            Entry e = this.entries[i];
            if (e == null || ".".equals(name = e.getName()) || "..".equals(name) || ".git".equals(name)) continue;
            if (i != o) {
                this.entries[o] = e;
            }
            e.encodeName(this.nameEncoder);
            ++o;
        }
        this.entryCnt = o;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    protected Entry current() {
        return this.entries[this.ptr];
    }

    protected static abstract class Entry {
        byte[] encodedName;
        int encodedNameLen;

        protected Entry() {
        }

        void encodeName(CharsetEncoder enc) {
            ByteBuffer b;
            try {
                b = enc.encode(CharBuffer.wrap(this.getName()));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("Unencodeable file: " + this.getName());
            }
            this.encodedNameLen = b.limit();
            if (b.hasArray() && b.arrayOffset() == 0) {
                this.encodedName = b.array();
            } else {
                this.encodedName = new byte[this.encodedNameLen];
                b.get(this.encodedName);
            }
        }

        public String toString() {
            return this.getMode().toString() + " " + this.getName();
        }

        public abstract FileMode getMode();

        public abstract long getLength();

        public abstract long getLastModified();

        public abstract String getName();

        public abstract InputStream openInputStream() throws IOException;
    }
}

