/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class IO {
    public static final byte[] readFully(File path) throws FileNotFoundException, IOException {
        return IO.readFully(path, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFully(File path, int max) throws FileNotFoundException, IOException {
        byte[] byArray;
        FileInputStream in = new FileInputStream(path);
        try {
            long sz = in.getChannel().size();
            if (sz > (long)max) {
                throw new IOException("File is too large: " + path);
            }
            byte[] buf = new byte[(int)sz];
            IO.readFully(in, buf, 0, buf.length);
            byArray = buf;
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                in.close();
            }
            catch (IOException ignored) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return byArray;
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(dst, off, len);
            if (r <= 0) {
                throw new EOFException("Short read of block.");
            }
            off += r;
            len -= r;
        }
    }

    public static void readFully(FileChannel fd, long pos, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(ByteBuffer.wrap(dst, off, len), pos);
            if (r <= 0) {
                throw new EOFException("Short read of block.");
            }
            pos += (long)r;
            off += r;
            len -= r;
        }
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException("Short skip of block");
            }
            toSkip -= r;
        }
    }

    private IO() {
    }
}

