/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.osgi.service.http.HttpContext;

public class FilterRegistration
extends Registration {
    private Filter filter;
    private HttpContext httpContext;
    private ClassLoader registeredContextClassLoader;
    private String prefix;
    private String suffix;

    public FilterRegistration(Filter filter, HttpContext context, String alias) {
        this.filter = filter;
        this.httpContext = context;
        this.registeredContextClassLoader = Thread.currentThread().getContextClassLoader();
        int lastSlash = alias.lastIndexOf(47);
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        if (lastSegment.startsWith("*.")) {
            this.prefix = alias.substring(0, lastSlash);
            this.suffix = lastSegment.substring(1);
        } else {
            this.prefix = alias.equals("/") ? "" : alias;
        }
    }

    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            super.destroy();
            this.filter.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            this.filter.init(filterConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            if (this.httpContext.handleSecurity(request, response)) {
                this.filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public boolean matches(String dispatchPathInfo) {
        if (!dispatchPathInfo.startsWith(this.prefix)) {
            return false;
        }
        if (this.prefix.length() == dispatchPathInfo.length()) {
            return this.suffix == null;
        }
        if (dispatchPathInfo.charAt(this.prefix.length()) != '/') {
            return false;
        }
        if (this.suffix == null) {
            return true;
        }
        return dispatchPathInfo.endsWith(this.suffix) && dispatchPathInfo.length() > this.prefix.length() + this.suffix.length();
    }
}

