/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.core.rtsystem;

import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeFilterEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeInitCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeModelDefCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeStartEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeStopEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeSubmitJobCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeTerminateJobCommand;
import org.eclipse.ptp.proxy.runtime.command.ProxyRuntimeCommandFactory;
import org.eclipse.ptp.rm.slurm.core.rmsystem.ISLURMResourceManagerConfiguration;

public class SLURMProxyCommandFactory
implements IProxyRuntimeCommandFactory {
    public static final String SLURMD_PATH_ATTR = "slurmdPath";
    public static final String SLURMD_ARGS_ATTR = "slurmdArgs";
    private IProxyRuntimeCommandFactory factory = new ProxyRuntimeCommandFactory();
    private ISLURMResourceManagerConfiguration config;

    public SLURMProxyCommandFactory(ISLURMResourceManagerConfiguration config) {
        this.config = config;
    }

    public IProxyRuntimeFilterEventsCommand newProxyRuntimeFilterEventsCommand(String[] args) {
        return this.factory.newProxyRuntimeFilterEventsCommand(args);
    }

    public IProxyRuntimeInitCommand newProxyRuntimeInitCommand(int baseId) {
        IProxyRuntimeInitCommand cmd = this.factory.newProxyRuntimeInitCommand(baseId);
        if (!this.config.getUseDefaults()) {
            if (!this.config.getSlurmdPath().equals("")) {
                cmd.addArgument("slurmdPath=" + this.config.getSlurmdPath());
            }
            if (!this.config.getSlurmdArgs().equals("")) {
                String[] stringArray = this.config.getSlurmdArgs().split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    cmd.addArgument("slurmdArgs=" + arg);
                    ++n2;
                }
            }
        }
        return cmd;
    }

    public IProxyRuntimeModelDefCommand newProxyRuntimeModelDefCommand() {
        return this.factory.newProxyRuntimeModelDefCommand();
    }

    public IProxyRuntimeStartEventsCommand newProxyRuntimeStartEventsCommand() {
        return this.factory.newProxyRuntimeStartEventsCommand();
    }

    public IProxyRuntimeStopEventsCommand newProxyRuntimeStopEventsCommand() {
        return this.factory.newProxyRuntimeStopEventsCommand();
    }

    public IProxyRuntimeSubmitJobCommand newProxyRuntimeSubmitJobCommand(String[] args) {
        return this.factory.newProxyRuntimeSubmitJobCommand(args);
    }

    public IProxyRuntimeTerminateJobCommand newProxyRuntimeTerminateJobCommand(String jobId) {
        return this.factory.newProxyRuntimeTerminateJobCommand(jobId);
    }

    public IProxyCommand toCommand(ProxyPacket packet) {
        return this.factory.toCommand(packet);
    }
}

