/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerServiceProvider;
import org.eclipse.ptp.rm.slurm.core.SLURMPreferenceManager;
import org.eclipse.ptp.rm.slurm.core.rmsystem.ISLURMResourceManagerConfiguration;
import org.eclipse.ptp.rm.slurm.core.rmsystem.SLURMResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class SLURMServiceProvider
extends AbstractRemoteResourceManagerServiceProvider
implements ISLURMResourceManagerConfiguration {
    private static final String TAG_SLURMD_PATH = "slurmdPath";
    private static final String TAG_SLURMD_ARGS = "slurmdArgs";
    private static final String TAG_SLURMD_DEFAULTS = "slurmdDefaults";
    public static final String EMPTY_STRING = "";
    private Preferences preferences = SLURMPreferenceManager.getPreferences();

    public SLURMServiceProvider() {
        this.setDescription("SLURM Resource Manager");
    }

    public SLURMServiceProvider(IServiceProvider provider) {
        super(provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new SLURMServiceProvider((IServiceProvider)this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new SLURMResourceManager(Integer.valueOf(universe.getNextResourceManagerId()), universe, (IResourceManagerConfiguration)this);
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public String getSlurmdArgs() {
        return this.getString(TAG_SLURMD_ARGS, this.preferences.getString(EMPTY_STRING));
    }

    public String getSlurmdPath() {
        return this.getString(TAG_SLURMD_PATH, this.preferences.getString(EMPTY_STRING));
    }

    public boolean getUseDefaults() {
        return this.getBoolean(TAG_SLURMD_DEFAULTS, true);
    }

    public boolean isConfigured() {
        return true;
    }

    public void setDefaultNameAndDesc() {
        String name = "SLURM";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals(EMPTY_STRING)) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("SLURM Resource Manager");
    }

    public void setSlurmdArgs(String slurmdArgs) {
        this.putString(TAG_SLURMD_ARGS, slurmdArgs);
    }

    public void setSlurmdPath(String slurmdPath) {
        this.putString(TAG_SLURMD_PATH, slurmdPath);
    }

    public void setUseDefaults(boolean useDefaults) {
        this.putBoolean(TAG_SLURMD_DEFAULTS, useDefaults);
    }

    public boolean needsDebuggerLaunchHelp() {
        return false;
    }
}

