/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.dialog;

import java.util.Iterator;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;

public class DialogPageSupport {
    private DialogPage dialogPage;
    private DataBindingContext dbc;
    private IObservableValue aggregateStatus;
    private boolean uiChanged = false;
    private IChangeListener uiChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            DialogPageSupport.this.handleUIChanged();
        }
    };
    private IListChangeListener validationStatusProvidersListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                Iterator it;
                ListDiffEntry listDiffEntry = differences[i];
                ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)listDiffEntry.getElement();
                IObservableList targets = validationStatusProvider.getTargets();
                if (listDiffEntry.isAddition()) {
                    targets.addListChangeListener(DialogPageSupport.this.validationStatusProviderTargetsListener);
                    it = targets.iterator();
                    while (it.hasNext()) {
                        ((IObservable)it.next()).addChangeListener(DialogPageSupport.this.uiChangeListener);
                    }
                } else {
                    targets.removeListChangeListener(DialogPageSupport.this.validationStatusProviderTargetsListener);
                    it = targets.iterator();
                    while (it.hasNext()) {
                        ((IObservable)it.next()).removeChangeListener(DialogPageSupport.this.uiChangeListener);
                    }
                }
                ++i;
            }
        }
    };
    private IListChangeListener validationStatusProviderTargetsListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] differences = diff.getDifferences();
            int i = 0;
            while (i < differences.length) {
                ListDiffEntry listDiffEntry = differences[i];
                IObservable target = (IObservable)listDiffEntry.getElement();
                if (listDiffEntry.isAddition()) {
                    target.addChangeListener(DialogPageSupport.this.uiChangeListener);
                } else {
                    target.removeChangeListener(DialogPageSupport.this.uiChangeListener);
                }
                ++i;
            }
        }
    };
    protected IStatus currentStatus;
    protected boolean currentStatusStale;

    public static DialogPageSupport create(DialogPage wizardPage, DataBindingContext dbc) {
        return new DialogPageSupport(wizardPage, dbc);
    }

    protected DialogPageSupport(DialogPage dialogPage, DataBindingContext dbc) {
        this.dialogPage = dialogPage;
        this.dbc = dbc;
        this.init();
    }

    protected DialogPage getDialogPage() {
        return this.dialogPage;
    }

    protected void init() {
        this.aggregateStatus = new AggregateValidationStatus((IObservableCollection)this.dbc.getValidationStatusProviders(), 2);
        this.aggregateStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                DialogPageSupport.this.currentStatus = (IStatus)event.diff.getNewValue();
                DialogPageSupport.this.currentStatusStale = DialogPageSupport.this.aggregateStatus.isStale();
                DialogPageSupport.this.handleStatusChanged();
            }
        });
        this.aggregateStatus.addStaleListener(new IStaleListener(){

            public void handleStale(StaleEvent staleEvent) {
                DialogPageSupport.this.currentStatusStale = true;
                DialogPageSupport.this.handleStatusChanged();
            }
        });
        this.currentStatus = (IStatus)this.aggregateStatus.getValue();
        this.currentStatusStale = this.aggregateStatus.isStale();
        this.handleStatusChanged();
        this.dbc.getValidationStatusProviders().addListChangeListener(this.validationStatusProvidersListener);
        Iterator it = this.dbc.getValidationStatusProviders().iterator();
        while (it.hasNext()) {
            ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
            IObservableList targets = validationStatusProvider.getTargets();
            targets.addListChangeListener(this.validationStatusProviderTargetsListener);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ((IObservable)iter.next()).addChangeListener(this.uiChangeListener);
            }
        }
    }

    protected void handleUIChanged() {
        this.uiChanged = true;
        if (this.currentStatus != null) {
            this.handleStatusChanged();
        }
        this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        Iterator it = this.dbc.getValidationStatusProviders().iterator();
        while (it.hasNext()) {
            ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
            IObservableList targets = validationStatusProvider.getTargets();
            targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ((IObservable)iter.next()).removeChangeListener(this.uiChangeListener);
            }
        }
    }

    protected void handleStatusChanged() {
        if (this.currentStatus != null && this.currentStatus.getSeverity() == 4) {
            this.dialogPage.setMessage(null);
            this.dialogPage.setErrorMessage(this.uiChanged ? this.currentStatus.getMessage() : null);
            if (this.currentStatusHasException()) {
                this.handleStatusException();
            }
        } else if (this.currentStatus != null && this.currentStatus.getSeverity() != 0) {
            int type;
            int severity = this.currentStatus.getSeverity();
            switch (severity) {
                case 0: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 0;
                    break;
                }
                case 1: {
                    type = 1;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 3;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"incomplete switch statement");
                    return;
                }
            }
            this.dialogPage.setErrorMessage(null);
            this.dialogPage.setMessage(this.currentStatus.getMessage(), type);
        } else {
            this.dialogPage.setMessage(null);
            this.dialogPage.setErrorMessage(null);
        }
    }

    private boolean currentStatusHasException() {
        boolean hasException = false;
        if (this.currentStatus.getException() != null) {
            hasException = true;
        }
        if (this.currentStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.currentStatus;
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (status.getException() != null) {
                    hasException = true;
                    break;
                }
                ++i;
            }
        }
        return hasException;
    }

    protected void handleStatusException() {
        if (this.currentStatus.getException() != null) {
            this.logThrowable(this.currentStatus.getException());
        } else if (this.currentStatus instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.currentStatus;
            int i = 0;
            while (i < multiStatus.getChildren().length) {
                IStatus status = multiStatus.getChildren()[i];
                if (status.getException() != null) {
                    this.logThrowable(status.getException());
                }
                ++i;
            }
        }
    }

    private void logThrowable(Throwable throwable) {
        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 0, "Unhandled exception: " + throwable.getMessage(), throwable));
    }

    public void dispose() {
        this.aggregateStatus.dispose();
        if (!this.uiChanged) {
            Iterator it = this.dbc.getValidationStatusProviders().iterator();
            while (it.hasNext()) {
                ValidationStatusProvider validationStatusProvider = (ValidationStatusProvider)it.next();
                IObservableList targets = validationStatusProvider.getTargets();
                targets.removeListChangeListener(this.validationStatusProviderTargetsListener);
                Iterator iter = targets.iterator();
                while (iter.hasNext()) {
                    ((IObservable)iter.next()).removeChangeListener(this.uiChangeListener);
                }
            }
            this.dbc.getValidationStatusProviders().removeListChangeListener(this.validationStatusProvidersListener);
        }
        this.aggregateStatus = null;
        this.dbc = null;
        this.uiChangeListener = null;
        this.validationStatusProvidersListener = null;
        this.validationStatusProviderTargetsListener = null;
        this.dialogPage = null;
    }
}

