/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui.console;

import java.util.Set;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jetty.osgi.pde.launch.ui.JettyEquinoxLaunchConfiguration;
import org.eclipse.jetty.osgi.pde.launch.ui.console.ReloadDeployedWebappsAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class JettyConsolePageParticipant
implements IConsolePageParticipant {
    private ReloadDeployedWebappsAction _reloadWebapps;

    public void init(IPageBookViewPage page, IConsole console) {
        if (!(console instanceof IOConsole)) {
            return;
        }
        Object o = ((IOConsole)console).getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
        if (o == null || !(o instanceof RuntimeProcess)) {
            return;
        }
        RuntimeProcess runProc = (RuntimeProcess)o;
        ILaunchConfiguration launchConfig = runProc.getLaunch().getLaunchConfiguration();
        if (launchConfig == null) {
            return;
        }
        try {
            ILaunchConfigurationType launchConfigType = launchConfig.getType();
            if (launchConfigType == null) {
                return;
            }
            boolean foundJetty = false;
            for (Object modes : launchConfigType.getSupportedModeCombinations()) {
                ILaunchDelegate[] iLaunchDelegateArray = launchConfigType.getDelegates((Set)modes);
                int n = iLaunchDelegateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchDelegate del = iLaunchDelegateArray[n2];
                    if (del.getDelegate() instanceof JettyEquinoxLaunchConfiguration) {
                        foundJetty = true;
                        break;
                    }
                    ++n2;
                }
                if (foundJetty) break;
            }
            if (!foundJetty) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        this._reloadWebapps = new ReloadDeployedWebappsAction(console, launchConfig);
        IToolBarManager manager = page.getSite().getActionBars().getToolBarManager();
        manager.appendToGroup("launchGroup", (IAction)this._reloadWebapps);
    }

    public void dispose() {
    }

    public void activated() {
    }

    public void deactivated() {
        if (this._reloadWebapps != null) {
            this._reloadWebapps.setEnabled(false);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

