/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui.tabs;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.WorkingDirectoryBlock;
import org.eclipse.jetty.osgi.pde.launch.JettyLauncherMessages;
import org.eclipse.jetty.osgi.pde.launch.internal.JettyHomeHelper;
import org.eclipse.jetty.osgi.pde.launch.ui.IConfigurationAreaSettingHolder;
import org.eclipse.jetty.osgi.pde.launch.ui.tabs.JettyXmlEditDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class JettyHomeBlock
extends WorkingDirectoryBlock {
    private Button _editJettyXml;
    private String _editedJettyXml;
    private IConfigurationAreaSettingHolder _configAreaHolder;
    private boolean _initializing = true;
    private static Field fFileSystemButton_field;

    public JettyHomeBlock(IConfigurationAreaSettingHolder configAreaHolder) {
        super("org.eclipse.jetty.osgi.pde.launch.jettyhome");
        this._configAreaHolder = configAreaHolder;
        this.setDirty(false);
    }

    protected IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        return null;
    }

    protected void log(CoreException e) {
        e.printStackTrace();
    }

    protected void doCreateControl(Composite parent) {
        super.createControl(parent);
        Group grp = (Group)super.getControl();
        grp.setText(JettyLauncherMessages.JettyHomeBlock_Section_title_Jetty_Home);
        Button fSysButton = this.getfFileSystemButton();
        Composite compButtons = fSysButton.getParent();
        GridLayout gLayout = (GridLayout)compButtons.getLayout();
        ++gLayout.numColumns;
        this._editJettyXml = this.createPushButton(compButtons, JettyLauncherMessages.JettyHomeBlock_Edit_jetty_xml, null);
        this._editJettyXml.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JettyXmlEditDialog diag = new JettyXmlEditDialog(JettyHomeBlock.this._editJettyXml.getShell(), JettyHomeBlock.this.getCurrentJettyXml());
                if (diag.open() == 0) {
                    JettyHomeBlock.this._editedJettyXml = diag.getNewJettyXml();
                    JettyHomeBlock.this.setDirty(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setDefaultWorkingDir() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                JettyHomeBlock.this._initializing = false;
                String value = String.valueOf(JettyHomeBlock.this._configAreaHolder.getConfigurationAreaLocation()) + File.separator + "jettyhome";
                try {
                    JettyHomeBlock.this.setDefaultWorkingDirectoryText(value);
                }
                catch (Throwable t) {
                    System.err.println("Unable to set the defaultWorkingDirectoryText");
                    t.printStackTrace();
                }
            }
        });
    }

    protected String getCurrentJettyXml() {
        return JettyHomeHelper.getCurrentJettyXml(this.getWorkingDirectoryText(), false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String jettyHome = this.getWorkingDirectoryText();
        if (this._initializing || jettyHome == null || jettyHome.length() == 0) {
            this._initializing = false;
            return;
        }
        try {
            JettyHomeHelper.setupJettyHomeAndJettyXML(this._editedJettyXml, this.getWorkingDirectoryText(), false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private Button getfFileSystemButton() {
        try {
            if (fFileSystemButton_field == null) {
                fFileSystemButton_field = WorkingDirectoryBlock.class.getDeclaredField("fFileSystemButton");
                fFileSystemButton_field.setAccessible(true);
            }
            return (Button)fFileSystemButton_field.get((Object)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

