/**
 * Copyright (c) 2004 - 2010 Eike Stepper (Berlin, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.server;

import org.eclipse.emf.cdo.common.id.CDOID;

import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

import java.util.Map;
import java.util.Set;

/**
 * @author Eike Stepper
 */
public interface IStore
{
  /**
   * @since 2.0
   */
  public IRepository getRepository();

  /**
   * @since 2.0
   */
  public String getType();

  /**
   * @since 3.0
   */
  public Set<CDOID.ObjectType> getObjectIDTypes();

  /**
   * @since 2.0
   */
  public Set<ChangeFormat> getSupportedChangeFormats();

  /**
   * @since 2.0
   */
  public Set<RevisionTemporality> getSupportedRevisionTemporalities();

  /**
   * @since 2.0
   */
  public Set<RevisionParallelism> getSupportedRevisionParallelisms();

  /**
   * @since 2.0
   */
  public RevisionTemporality getRevisionTemporality();

  /**
   * @since 2.0
   */
  public RevisionParallelism getRevisionParallelism();

  /**
   * Returns <code>true</code>if this store was activated for the first time, <code>false</code> otherwise.
   * 
   * @since 2.0
   */
  public boolean isFirstTime();

  /**
   * Returns the store creation time.
   * 
   * @since 2.0
   */
  public long getCreationTime();

  /**
   * Returns the time stamp of the last csuccessful commit operation.
   * 
   * @since 3.0
   */
  public long getLastCommitTime();

  /**
   * @since 3.0
   */
  public Map<String, String> getPropertyValues(Set<String> names);

  /**
   * @since 3.0
   */
  public void setPropertyValues(Map<String, String> properties);

  /**
   * @since 3.0
   */
  public void removePropertyValues(Set<String> names);

  /**
   * Returns a reader that can be used to read from this store in the context of the given session.
   * 
   * @param session
   *          The session that should be used as a context for read access or <code>null</code>. The store implementor
   *          is free to interpret and use the session in a manner suitable for him or ignore it at all. It is meant
   *          only as a hint. Implementor can use it as a key into a cache and/or register a
   *          {@link org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter LifecycleEventAdapter} with it to intercept
   *          cleanup on session close. Note however that the session can be <code>null</code>, for example during
   *          startup of the server while the repositories are initialized but before any user session has been opened.
   * @return a reader that can be used to read from this store in the context of the given session, never
   *         <code>null</code>.
   * @since 2.0
   */
  public IStoreAccessor getReader(ISession session);

  /**
   * Returns a writer that can be used to write to this store in the context of the given view. The given view is always
   * marked as a transaction.
   * 
   * @param transaction
   *          The view that must be used as a context for write access. The store implementor is free to interpret and
   *          use the view in a manner suitable for him or ignore it at all. It is meant only as a hint. Implementor can
   *          use it as a key into a cache and/or register a
   *          {@link org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter LifecycleEventAdapter} with it to intercept
   *          cleanup on view close.
   * @return a writer that can be used to write to this store in the context of the given view, never <code>null</code>.
   * @since 2.0
   */
  public IStoreAccessor getWriter(ITransaction transaction);

  /**
   * @since 2.0
   */
  public ProgressDistributor getIndicatingCommitDistributor();

  /**
   * @author Eike Stepper
   * @since 2.0
   */
  public enum ChangeFormat
  {
    REVISION, DELTA
  }

  /**
   * @author Eike Stepper
   * @since 2.0
   */
  public enum RevisionTemporality
  {
    NONE, AUDITING
  }

  /**
   * @author Eike Stepper
   * @since 2.0
   */
  public enum RevisionParallelism
  {
    NONE, BRANCHING
  }
}
