/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFontStruct;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int lineSpacing = 0;
    int ascent = -1;
    int descent = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int defaultAscent;
    int defaultDescent;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);

    public TextLayout(Device device) {
        super(device);
        XFontStruct fontStruct = this.getFontHeigth(this.device.getSystemFont());
        this.defaultAscent = fontStruct.ascent;
        this.defaultDescent = fontStruct.descent;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    int stringWidth(StyleItem run, char[] ch) {
        if (ch.length == 0) {
            return 0;
        }
        Font font = this.getItemFont(run);
        int fontList = font.handle;
        byte[] buffer = Converter.wcsToMbcs(font.codePage, ch, true);
        int xmString = OS.XmStringCreateLocalized(buffer);
        int width = OS.XmStringWidth(fontList, xmString);
        OS.XmStringFree(xmString);
        return width;
    }

    void computeRuns() {
        if (this.runs != null) {
            return;
        }
        StyleItem[] allRuns = this.itemize();
        int i = 0;
        while (i < allRuns.length - 1) {
            StyleItem run = allRuns[i];
            this.place(run);
            ++i;
        }
        int lineWidth = 0;
        int lineStart = 0;
        int lineCount = 1;
        int i2 = 0;
        while (i2 < allRuns.length - 1) {
            StyleItem run = allRuns[i2];
            if (run.length == 1) {
                char ch = this.text.charAt(run.start);
                switch (ch) {
                    case '\t': {
                        int lastTabWidth;
                        run.tab = true;
                        run.baseline = 0;
                        if (this.tabs == null) break;
                        int tabsLength = this.tabs.length;
                        int j = 0;
                        while (j < tabsLength) {
                            if (this.tabs[j] > lineWidth) {
                                run.width = this.tabs[j] - lineWidth;
                                break;
                            }
                            ++j;
                        }
                        if (j != tabsLength) break;
                        int tabX = this.tabs[tabsLength - 1];
                        int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        if (lastTabWidth <= 0) break;
                        while (tabX <= lineWidth) {
                            tabX += lastTabWidth;
                        }
                        run.width = tabX - lineWidth;
                        break;
                    }
                    case '\n': {
                        run.lineBreak = true;
                        run.width = 0;
                        run.baseline = 0;
                        break;
                    }
                    case '\r': {
                        run.lineBreak = true;
                        run.width = 0;
                        run.baseline = 0;
                        StyleItem next = allRuns[i2 + 1];
                        if (next.length == 0 || this.text.charAt(next.start) != '\n') break;
                        ++run.length;
                        ++i2;
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab) {
                int start = 0;
                char[] chars = new char[run.length];
                this.text.getChars(run.start, run.start + run.length, chars, 0);
                if (run.style == null || run.style.metrics == null) {
                    int width = 0;
                    int maxWidth = this.wrapWidth - lineWidth;
                    char[] buffer = new char[]{chars[start]};
                    int charWidth = this.stringWidth(run, buffer);
                    while (width + charWidth < maxWidth) {
                        width += charWidth;
                        buffer[0] = chars[++start];
                        charWidth = this.stringWidth(run, buffer);
                    }
                }
                int firstStart = start;
                int firstIndice = i2;
                while (i2 >= lineStart) {
                    chars = new char[run.length];
                    this.text.getChars(run.start, run.start + run.length, chars, 0);
                    while (start >= 0) {
                        if (Compatibility.isSpaceChar(chars[start]) || Compatibility.isWhitespace(chars[start])) break;
                        --start;
                    }
                    if (start >= 0 || i2 == lineStart) break;
                    run = allRuns[--i2];
                    start = run.length - 1;
                }
                if (start == 0 && i2 != lineStart) {
                    run = allRuns[--i2];
                } else if (start <= 0 && i2 == lineStart) {
                    i2 = firstIndice;
                    run = allRuns[i2];
                    start = Math.max(1, firstStart);
                }
                chars = new char[run.length];
                this.text.getChars(run.start, run.start + run.length, chars, 0);
                while (start < run.length) {
                    if (!Compatibility.isWhitespace(chars[start])) break;
                    ++start;
                }
                if (start > 0 && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    run.length = start;
                    this.place(run);
                    this.place(newRun);
                    StyleItem[] newAllRuns = new StyleItem[allRuns.length + 1];
                    System.arraycopy(allRuns, 0, newAllRuns, 0, i2 + 1);
                    System.arraycopy(allRuns, i2 + 1, newAllRuns, i2 + 2, allRuns.length - i2 - 1);
                    allRuns = newAllRuns;
                    allRuns[i2 + 1] = newRun;
                }
                if (i2 != allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (run.lineBreak) {
                lineStart = i2 + 1;
                lineWidth = 0;
                ++lineCount;
            }
            ++i2;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascent = Math.max(this.defaultAscent, this.ascent);
        int descent = Math.max(this.defaultDescent, this.descent);
        StyleItem[] lineRuns = new StyleItem[allRuns.length];
        int i3 = 0;
        while (i3 < allRuns.length) {
            StyleItem run = allRuns[i3];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            if (run.style != null) {
                int runAscent = this.defaultAscent;
                int runDescent = this.defaultDescent;
                if (run.style.metrics != null) {
                    GlyphMetrics metrics = run.style.metrics;
                    runAscent = metrics.ascent;
                    runDescent = metrics.descent;
                } else if (run.style.font != null) {
                    XFontStruct fontStruct = this.getFontHeigth(run.style.font);
                    runAscent = fontStruct.ascent;
                    runDescent = fontStruct.descent;
                }
                ascent = Math.max(ascent, runAscent + run.style.rise);
                descent = Math.max(descent, runDescent - run.style.rise);
                if (run.style.rise != 0) {
                    run.baseline += run.style.rise;
                }
            }
            if (run.lineBreak || i3 == allRuns.length - 1) {
                this.runs[line] = new StyleItem[lineRunCount];
                System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
                StyleItem lastRun = this.runs[line][lineRunCount - 1];
                this.lineWidth[line] = lineWidth;
                this.lineY[++line] = this.lineY[line - 1] + ascent + descent + this.lineSpacing;
                this.lineOffset[line] = lastRun.start + lastRun.length;
                lineWidth = 0;
                lineRunCount = 0;
                ascent = Math.max(this.defaultAscent, this.ascent);
                descent = Math.max(this.defaultDescent, this.descent);
            }
            ++i3;
        }
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.tabs = null;
        this.styles = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        boolean hasSelection;
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        gc.checkGC(1);
        int length = this.text.length();
        if (length == 0 && flags == 0) {
            return;
        }
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (hasSelection || (flags & 0x100000) != 0) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
        }
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        Font gcFont = gc.getFont();
        Resource linkColor = null;
        Rectangle clip = gc.getClipping();
        int line = 0;
        while (line < this.runs.length) {
            int drawX = x + this.getLineIndent(line);
            int drawY = y + this.lineY[line];
            StyleItem[] lineRuns = this.runs[line];
            int lineHeight = this.lineY[line + 1] - this.lineY[line];
            if (flags != 0 && (hasSelection || (flags & 0x100000) != 0)) {
                boolean extent = false;
                if (line == this.runs.length - 1 && (flags & 0x100000) != 0) {
                    extent = true;
                } else {
                    StyleItem run = lineRuns[lineRuns.length - 1];
                    if (run.lineBreak && !run.softBreak) {
                        if (selectionStart <= run.start && run.start <= selectionEnd) {
                            extent = true;
                        }
                    } else {
                        int endOffset = run.start + run.length - 1;
                        if (selectionStart <= endOffset && endOffset < selectionEnd && (flags & 0x10000) != 0) {
                            extent = true;
                        }
                    }
                }
                if (extent) {
                    gc.setBackground(selectionBackground);
                    int width = (flags & 0x10000) != 0 ? Integer.MAX_VALUE : lineHeight / 3;
                    gc.fillRectangle(drawX + this.lineWidth[line], drawY, width, lineHeight);
                }
            }
            if (drawX <= clip.x + clip.width && drawX + this.lineWidth[line] >= clip.x) {
                int baseline = Math.max(0, this.ascent);
                int i = 0;
                while (i < lineRuns.length) {
                    baseline = Math.max(baseline, lineRuns[i].baseline);
                    ++i;
                }
                i = 0;
                while (i < lineRuns.length) {
                    StyleItem run = lineRuns[i];
                    if (run.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                            String string = this.text.substring(run.start, run.start + run.length);
                            int drawRunY = drawY + (baseline - run.baseline);
                            int end = run.start + run.length - 1;
                            gc.setFont(this.getItemFont(run));
                            boolean fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                            TextStyle style = run.style;
                            if (fullSelection) {
                                gc.setBackground(selectionBackground);
                                gc.fillRectangle(drawX, drawY, run.width, lineHeight);
                                if (!(run.tab || style != null && style.metrics != null)) {
                                    gc.setForeground(selectionForeground);
                                    gc.drawString(string, drawX, drawRunY, true);
                                    this.drawLines(gc, run, drawX, drawRunY, run.width);
                                }
                            } else {
                                if (style != null && style.background != null) {
                                    Color bg = style.background;
                                    gc.setBackground(bg);
                                    gc.fillRectangle(drawX, drawRunY, run.width, run.height);
                                }
                                if (!run.tab) {
                                    boolean partialSelection;
                                    Resource fg = foreground;
                                    if (style != null) {
                                        if (style.foreground != null) {
                                            fg = style.foreground;
                                        } else if (style.underline && style.underlineStyle == 4) {
                                            if (linkColor == null) {
                                                linkColor = new Color(this.device, LINK_FOREGROUND);
                                            }
                                            fg = linkColor;
                                        }
                                    }
                                    if (style == null || style.metrics == null) {
                                        gc.setForeground((Color)fg);
                                        gc.drawString(string, drawX, drawRunY, true);
                                        this.drawLines(gc, run, drawX, drawRunY, run.width);
                                    }
                                    boolean bl2 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                                    if (partialSelection) {
                                        int selStart = Math.max(selectionStart, run.start);
                                        int selEnd = Math.min(selectionEnd, end);
                                        string = this.text.substring(run.start, selStart);
                                        int selX = drawX + gc.stringExtent((String)string).x;
                                        string = this.text.substring(selStart, selEnd + 1);
                                        int selWidth = gc.stringExtent((String)string).x;
                                        gc.setBackground(selectionBackground);
                                        gc.fillRectangle(selX, drawY, selWidth, lineHeight);
                                        if (fg != selectionForeground && (style == null || style.metrics == null)) {
                                            gc.setForeground(selectionForeground);
                                            gc.drawString(string, selX, drawRunY, true);
                                            this.drawLines(gc, run, selX, drawRunY, selWidth);
                                        }
                                    }
                                }
                            }
                            this.drawBorder(gc, lineRuns, i, drawX, drawY, lineHeight, foreground);
                        }
                        drawX += run.width;
                    }
                    ++i;
                }
            }
            ++line;
        }
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.setFont(gcFont);
        if (linkColor != null) {
            linkColor.dispose();
        }
    }

    void drawBorder(GC gc, StyleItem[] line, int index, int x, int y, int lineHeight, Color color) {
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return;
        }
        if (!(style.borderStyle == 0 || index + 1 < line.length && style.isAdherentBorder(line[index + 1].style))) {
            int width = run.width;
            int i = index;
            while (i > 0 && style.isAdherentBorder(line[i - 1].style)) {
                x -= line[i - 1].width;
                width += line[i - 1].width;
                --i;
            }
            if (style.borderColor != null) {
                color = style.borderColor;
            } else if (style.foreground != null) {
                color = style.foreground;
            }
            gc.setForeground(color);
            int lineStyle = gc.getLineStyle();
            int[] dashes = null;
            if (lineStyle == 6) {
                dashes = gc.getLineDash();
            }
            switch (style.borderStyle) {
                case 1: {
                    gc.setLineStyle(1);
                    break;
                }
                case 2: {
                    gc.setLineStyle(2);
                    break;
                }
                case 4: {
                    gc.setLineStyle(3);
                }
            }
            gc.drawRectangle(x, y, width - 1, lineHeight - 1);
            gc.setLineStyle(lineStyle);
            if (dashes != null) {
                gc.setLineDash(dashes);
            }
        }
    }

    void drawLines(GC gc, StyleItem run, int x, int y, int width) {
        TextStyle style = run.style;
        if (style == null) {
            return;
        }
        if (style.underline) {
            int underlineY = y + run.baseline + 1 - style.rise;
            if (style.underlineColor != null) {
                gc.setForeground(style.underlineColor);
            }
            switch (style.underlineStyle) {
                case 2: 
                case 3: {
                    int squigglyThickness = 1;
                    int squigglyHeight = 2 * squigglyThickness;
                    int squigglyY = Math.min(underlineY, y + run.height - squigglyHeight - 1);
                    int[] points = this.computePolyline(x, squigglyY, x + width, squigglyY + squigglyHeight);
                    gc.drawPolyline(points);
                    break;
                }
                case 1: {
                    gc.drawLine(x, underlineY + 2, x + width, underlineY + 2);
                }
                case 0: 
                case 4: {
                    gc.drawLine(x, underlineY, x + width, underlineY);
                }
            }
        }
        if (style.strikeout) {
            int strikeoutY = y + run.height - run.height / 2 - 1;
            if (style.strikeoutColor != null) {
                gc.setForeground(style.strikeoutColor);
            }
            gc.drawLine(x, strikeoutY, x + width, strikeoutY);
        }
    }

    int[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = (right - left) / width;
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int i = 0;
        while (i < peaks) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + width / 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = Math.min(Math.max(0, right - 1), left + width * peaks);
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    void freeRuns() {
        this.runs = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            int line = 0;
            while (line < this.runs.length) {
                width = Math.max(width, this.lineWidth[line] + this.getLineIndent(line));
                ++line;
            }
        }
        return new Rectangle(0, 0, width, this.lineY[this.lineY.length - 1]);
    }

    /*
     * Unable to fully structure code
     */
    public Rectangle getBounds(int start, int end) {
        block3: {
            this.checkLayout();
            this.computeRuns();
            length = this.text.length();
            if (length == 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            if (start > end) {
                return new Rectangle(0, 0, 0, 0);
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            startLine = this.getLineIndex(start);
            endLine = this.getLineIndex(end);
            rect = new Rectangle(0, 0, 0, 0);
            rect.y = this.lineY[startLine];
            rect.height = this.lineY[endLine + 1] - rect.y - this.lineSpacing;
            if (startLine != endLine) ** GOTO lbl20
            rect.x = this.getLocation((int)start, (boolean)false).x;
            rect.width = this.getLocation((int)end, (boolean)true).x - rect.x;
            break block3;
lbl-1000:
            // 1 sources

            {
                rect.width = Math.max(rect.width, this.lineWidth[startLine++]);
lbl20:
                // 2 sources

                ** while (startLine <= endLine)
            }
        }
        return rect;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    XFontStruct getFontHeigth(Font font) {
        int fontListEntry;
        int[] buffer = new int[1];
        int fontList = font.handle;
        if (!OS.XmFontListInitFontContext(buffer, fontList)) {
            SWT.error(2);
        }
        int context = buffer[0];
        int ascent = 0;
        int descent = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                ascent = Math.max(ascent, fontStruct.ascent);
                descent = Math.max(descent, fontStruct.descent);
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        fontStruct.ascent = ascent;
        fontStruct.descent = descent;
        return fontStruct;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        return 0;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] offsets = new int[this.lineOffset.length];
        System.arraycopy(this.lineOffset, 0, offsets, 0, offsets.length);
        return offsets;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x = this.getLineIndent(lineIndex);
        int y = this.lineY[lineIndex];
        int width = this.lineWidth[lineIndex];
        int height = this.lineY[lineIndex + 1] - y - this.lineSpacing;
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.runs.length;
    }

    int getLineIndent(int lineIndex) {
        boolean partialLine;
        int lineIndent = 0;
        if (lineIndex == 0) {
            lineIndent = this.indent;
        } else {
            StyleItem[] previousLine = this.runs[lineIndex - 1];
            StyleItem previousRun = previousLine[previousLine.length - 1];
            if (previousRun.lineBreak && !previousRun.softBreak) {
                lineIndent = this.indent;
            }
        }
        if (this.wrapWidth != -1 && (partialLine = true)) {
            int lineWidth = this.lineWidth[lineIndex] + lineIndent;
            switch (this.alignment) {
                case 0x1000000: {
                    lineIndent += (this.wrapWidth - lineWidth) / 2;
                    break;
                }
                case 131072: {
                    lineIndent += this.wrapWidth - lineWidth;
                }
            }
        }
        return lineIndent;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        int line = 0;
        while (line < this.runs.length) {
            if (this.lineOffset[line + 1] > offset) {
                return line;
            }
            ++line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int ascent = Math.max(this.defaultAscent, this.ascent);
        int descent = Math.max(this.defaultDescent, this.descent);
        if (this.text.length() != 0) {
            GC gc = new GC((Drawable)this.device);
            StyleItem[] lineRuns = this.runs[lineIndex];
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                if (run.style != null) {
                    int runAscent = 0;
                    int runDescent = 0;
                    if (run.style.metrics != null) {
                        GlyphMetrics glyphMetrics = run.style.metrics;
                        runAscent = glyphMetrics.ascent;
                        runDescent = glyphMetrics.descent;
                    } else if (run.style.font != null) {
                        gc.setFont(run.style.font);
                        FontMetrics metrics = gc.getFontMetrics();
                        runAscent = metrics.getAscent();
                        runDescent = metrics.getDescent();
                    }
                    ascent = Math.max(ascent, runAscent + run.style.rise);
                    descent = Math.max(descent, runDescent - run.style.rise);
                }
                ++i;
            }
            gc.dispose();
        }
        return FontMetrics.motif_new(ascent, descent, 0, 0, ascent + descent);
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        int line = 0;
        while (line < this.runs.length) {
            if (this.lineOffset[line + 1] > offset) break;
            ++line;
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        Point result = null;
        if (offset == length) {
            result = new Point(this.lineWidth[line], this.lineY[line]);
        } else {
            int width = 0;
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                int end = run.start + run.length;
                if (run.start <= offset && offset < end) {
                    if (run.tab) {
                        if (trailing || offset == length) {
                            width += run.width;
                        }
                    } else {
                        if (trailing) {
                            ++offset;
                        }
                        if (run.style != null && run.style.metrics != null) {
                            GlyphMetrics metrics = run.style.metrics;
                            width += metrics.width * (offset - run.start);
                        } else {
                            char[] chars = new char[offset - run.start];
                            this.text.getChars(run.start, offset, chars, 0);
                            width += this.stringWidth(run, chars);
                        }
                    }
                    result = new Point(width, this.lineY[line]);
                    break;
                }
                width += run.width;
                ++i;
            }
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        result.x += this.getLineIndent(line);
        return result;
    }

    Font getItemFont(StyleItem item) {
        if (item.style != null && item.style.font != null) {
            return item.style.font;
        }
        if (this.font != null) {
            return this.font;
        }
        return this.device.systemFont;
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (offset == length) {
            return length;
        }
        if ((movement & 3) != 0) {
            return offset + 1;
        }
        int lineEnd = 0;
        int i = 1;
        while (i < this.lineOffset.length) {
            if (this.lineOffset[i] > offset) {
                lineEnd = Math.max(this.lineOffset[i - 1], this.lineOffset[i] - 1);
                if (i != this.runs.length) break;
                ++lineEnd;
                break;
            }
            ++i;
        }
        boolean previousSpaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(offset));
        ++offset;
        while (offset < lineEnd) {
            boolean spaceChar;
            boolean bl = spaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(offset));
            if ((movement == 4 || movement == 8) && spaceChar && !previousSpaceChar || movement == 16 && !spaceChar && previousSpaceChar) break;
            previousSpaceChar = spaceChar;
            ++offset;
        }
        return offset;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        int line = 0;
        while (line < lineCount) {
            if (this.lineY[line + 1] > y) break;
            ++line;
        }
        line = Math.min(line, this.runs.length - 1);
        if ((x -= this.getLineIndent(line)) >= this.lineWidth[line]) {
            x = this.lineWidth[line] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        StyleItem[] lineRuns = this.runs[line];
        int width = 0;
        int i = 0;
        while (i < lineRuns.length) {
            StyleItem run = lineRuns[i];
            if (run.lineBreak && !run.softBreak) {
                return run.start;
            }
            if (width + run.width > x) {
                if (run.style != null && run.style.metrics != null) {
                    int xRun = x - width;
                    GlyphMetrics metrics = run.style.metrics;
                    if (metrics.width > 0) {
                        if (trailing != null) {
                            trailing[0] = xRun % metrics.width < metrics.width / 2 ? 0 : 1;
                        }
                        return run.start + xRun / metrics.width;
                    }
                }
                if (run.tab) {
                    if (trailing != null) {
                        trailing[0] = x < width + run.width / 2 ? 0 : 1;
                    }
                    return run.start;
                }
                int offset = 0;
                char[] buffer = new char[1];
                char[] chars = new char[run.length];
                this.text.getChars(run.start, run.start + run.length, chars, 0);
                offset = 0;
                while (offset < chars.length) {
                    buffer[0] = chars[offset];
                    int charWidth = this.stringWidth(run, buffer);
                    if (width + charWidth > x) {
                        if (trailing == null) break;
                        trailing[0] = x < width + charWidth / 2 ? 0 : 1;
                        break;
                    }
                    width += charWidth;
                    ++offset;
                }
                return run.start + offset;
            }
            width += run.width;
            ++i;
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        return this.lineOffset[line + 1];
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (offset == 0) {
            return 0;
        }
        if ((movement & 3) != 0) {
            return offset - 1;
        }
        int lineStart = 0;
        int i = 0;
        while (i < this.lineOffset.length - 1) {
            int lineEnd = this.lineOffset[i + 1];
            if (i == this.runs.length - 1) {
                ++lineEnd;
            }
            if (lineEnd > offset) {
                lineStart = this.lineOffset[i];
                break;
            }
            ++i;
        }
        boolean previousSpaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(--offset));
        while (lineStart < offset) {
            boolean spaceChar;
            boolean bl = spaceChar = !Compatibility.isLetterOrDigit(this.text.charAt(offset - 1));
            if (movement == 8 && !spaceChar && previousSpaceChar || (movement == 4 || movement == 16) && spaceChar && !previousSpaceChar) break;
            --offset;
            previousSpaceChar = spaceChar;
        }
        return offset;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int length = this.text.length();
        if (length == 0) {
            return new StyleItem[]{new StyleItem(), new StyleItem()};
        }
        int runCount = 0;
        int start = 0;
        StyleItem[] runs = new StyleItem[length];
        char[] chars = this.text.toCharArray();
        int i = 0;
        while (i < length) {
            char ch = chars[i];
            if (ch == '\t' || ch == '\r' || ch == '\n') {
                StyleItem item;
                if (i != start) {
                    item = new StyleItem();
                    item.start = start;
                    runs[runCount++] = item;
                }
                item = new StyleItem();
                item.start = i;
                runs[runCount++] = item;
                start = i + 1;
            }
            ++i;
        }
        char lastChar = chars[length - 1];
        if (lastChar != '\t' && lastChar != '\r' && lastChar != '\n') {
            StyleItem item = new StyleItem();
            item.start = start;
            runs[runCount++] = item;
        }
        if (runCount != length) {
            StyleItem[] newRuns = new StyleItem[runCount];
            System.arraycopy(runs, 0, newRuns, 0, runCount);
            runs = newRuns;
        }
        runs = this.merge(runs, runCount);
        return runs;
    }

    StyleItem[] merge(StyleItem[] items, int itemCount) {
        StyleItem item;
        int length = this.text.length();
        int count = 0;
        int start = 0;
        int end = length;
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.styles.length];
        while (start < end) {
            int styleLimit;
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            int itemLimit = itemIndex + 1 < items.length ? items[itemIndex + 1].start : length;
            int n = styleLimit = styleIndex + 1 < this.styles.length ? this.styles[styleIndex + 1].start : length;
            if (styleLimit <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
            }
            if (itemLimit <= styleLimit) {
                ++itemIndex;
                start = itemLimit;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    void place(StyleItem run) {
        if (run.length == 0) {
            return;
        }
        if (run.style != null && run.style.metrics != null) {
            GlyphMetrics glyphMetrics = run.style.metrics;
            run.width = glyphMetrics.width * run.length;
            run.baseline = glyphMetrics.ascent;
            run.height = glyphMetrics.ascent + glyphMetrics.descent;
        } else {
            char[] chars = new char[run.length];
            this.text.getChars(run.start, run.start + run.length, chars, 0);
            Font font = this.getItemFont(run);
            int fontList = font.handle;
            byte[] buffer = Converter.wcsToMbcs(font.codePage, chars, true);
            short[] width = new short[1];
            short[] height = new short[1];
            int xmString = OS.XmStringCreateLocalized(buffer);
            OS.XmStringExtent(fontList, xmString, width, height);
            run.width = width[0] & 0xFFFF;
            run.height = height[0] & 0xFFFF;
            run.baseline = OS.XmStringBaseline(fontList, xmString);
            OS.XmStringFree(xmString);
        }
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.freeRuns();
        XFontStruct fontStruct = this.getFontHeigth(font != null ? font : this.device.systemFont);
        this.defaultAscent = fontStruct.ascent;
        this.defaultDescent = fontStruct.descent;
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        this.orientation = orientation;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.styles.length) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int length;
        int width;
        int height;
        int baseline;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

