/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.buildpath.JUnitContainerInitializer;
import org.eclipse.jdt.internal.junit.buildpath.P2Utils;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class BuildPathSupport {
    public static final JUnitPluginDescription JUNIT3_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[3.8.2,3.9)"), "junit.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit3.javadoclocation");
    private static final JUnitPluginDescription JUNIT4_PLUGIN = new JUnitPluginDescription("org.junit4", new VersionRange("[4.5.0,5.0.0)"), "junit.jar", "org.junit4.source", "junitsrc.zip", "org.eclipse.jdt.junit.junit4.javadoclocation");
    private static final JUnitPluginDescription HAMCREST_CORE_PLUGIN = new JUnitPluginDescription("org.hamcrest.core", new VersionRange("[1.1.0,2.0.0)"), null, "org.hamcrest.core.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation");

    public static IClasspathEntry getJUnit3ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitContainerInitializer.JUNIT3_PATH);
    }

    public static IClasspathEntry getJUnit4ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitContainerInitializer.JUNIT4_PATH);
    }

    public static IClasspathEntry getJUnit3LibraryEntry() {
        return JUNIT3_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit4LibraryEntry() {
        return JUNIT4_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getHamcrestCoreLibraryEntry() {
        return HAMCREST_CORE_PLUGIN.getLibraryEntry();
    }

    public static class JUnitPluginDescription {
        private final String bundleId;
        private final VersionRange versionRange;
        private final String sourceBundleId;
        private final String bundleRoot;
        private final String repositorySource;
        private final String javadocPreferenceKey;

        public JUnitPluginDescription(String bundleId, VersionRange versionRange, String bundleRoot, String sourceBundleId, String repositorySource, String javadocPreferenceKey) {
            this.bundleId = bundleId;
            this.versionRange = versionRange;
            this.sourceBundleId = sourceBundleId;
            this.bundleRoot = bundleRoot;
            this.repositorySource = repositorySource;
            this.javadocPreferenceKey = javadocPreferenceKey;
        }

        public IPath getBundleLocation() {
            return P2Utils.getBundleLocationPath(P2Utils.findBundle(this.bundleId, this.versionRange, false));
        }

        public IPath getSourceBundleLocation() {
            return this.getSourceLocation(P2Utils.findBundle(this.bundleId, this.versionRange, false));
        }

        public IClasspathEntry getLibraryEntry() {
            BundleInfo bundleInfo = P2Utils.findBundle(this.bundleId, this.versionRange, false);
            IPath bundleLocation = P2Utils.getBundleLocationPath(bundleInfo);
            if (bundleLocation != null) {
                IPath bundleRootLocation = bundleLocation;
                if (this.bundleRoot != null) {
                    bundleRootLocation = bundleLocation.append(this.bundleRoot);
                }
                IPath srcLocation = this.getSourceLocation(bundleInfo);
                IAccessRule[] accessRules = new IAccessRule[]{};
                String javadocLocation = JUnitPlugin.getDefault().getPreferenceStore().getString(this.javadocPreferenceKey);
                IClasspathAttribute[] attributes = javadocLocation.length() == 0 ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation)};
                return JavaCore.newLibraryEntry((IPath)bundleRootLocation, (IPath)srcLocation, null, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)false);
            }
            return null;
        }

        private IPath getSourceLocation(BundleInfo bundleInfo) {
            if (bundleInfo == null) {
                return null;
            }
            IPath srcLocation = null;
            if (this.repositorySource != null) {
                try {
                    File srcFile;
                    URL bundleUrl = FileLocator.toFileURL((URL)URIUtil.toURL((URI)bundleInfo.getLocation()));
                    File bundleFile = new File(bundleUrl.getFile());
                    if (bundleFile.isDirectory() && (srcFile = new File(bundleFile, this.repositorySource)).exists()) {
                        srcLocation = new Path(srcFile.getPath());
                        if (srcFile.isDirectory()) {
                            srcLocation = srcLocation.addTrailingSeparator();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
            if (srcLocation == null) {
                BundleInfo sourceBundleInfo = P2Utils.findBundle(this.sourceBundleId, new Version(bundleInfo.getVersion()), true);
                if (sourceBundleInfo == null) {
                    sourceBundleInfo = P2Utils.findBundle(this.sourceBundleId, this.versionRange, true);
                }
                srcLocation = P2Utils.getBundleLocationPath(sourceBundleInfo);
            }
            return srcLocation;
        }
    }
}

