/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.launcher.JUnitRuntimeClasspathEntry;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class JUnitLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private boolean fKeepAlive = false;
    private int fPort;
    private IMember[] fTestElements;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 5);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            if (mode.equals("runQuietly")) {
                launch.setAttribute("org.eclipse.jdt.junit.NO_DISPLAY", "true");
                mode = "run";
            }
            monitor.subTask(JUnitMessages.JUnitLaunchConfigurationDelegate_verifying_attriburtes_description);
            try {
                this.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() != 8) throw e;
                monitor.setCanceled(true);
                this.fTestElements = null;
                monitor.done();
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            this.fKeepAlive = mode.equals("debug") && configuration.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            this.fPort = this.evaluatePort();
            launch.setAttribute("org.eclipse.jdt.junit.PORT", String.valueOf(this.fPort));
            this.fTestElements = this.evaluateTests(configuration, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            String mainTypeName = this.verifyMainTypeName(configuration);
            IVMRunner runner = this.getVMRunner(configuration, mode);
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            String[] envp = this.getEnvironment(configuration);
            ArrayList vmArguments = new ArrayList();
            ArrayList programArguments = new ArrayList();
            this.collectExecutionArguments(configuration, vmArguments, programArguments);
            Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
            String[] classpath = this.getClasspath(configuration);
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
            runConfig.setVMArguments(vmArguments.toArray(new String[vmArguments.size()]));
            runConfig.setProgramArguments(programArguments.toArray(new String[programArguments.size()]));
            runConfig.setEnvironment(envp);
            runConfig.setWorkingDirectory(workingDirName);
            runConfig.setVMSpecificAttributesMap(vmAttributesMap);
            runConfig.setBootClassPath(this.getBootpath(configuration));
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.subTask(JUnitMessages.JUnitLaunchConfigurationDelegate_create_source_locator_description);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
            if (!monitor.isCanceled()) return;
            return;
        }
        finally {
            this.fTestElements = null;
            monitor.done();
        }
    }

    private int evaluatePort() throws CoreException {
        int port = SocketUtil.findFreePort();
        if (port == -1) {
            this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_no_socket, null, 118);
        }
        return port;
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            ITestKind testKind;
            boolean isJUnit4Configuration;
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (javaProject == null || !javaProject.exists()) {
                this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_invalidproject, null, 107);
            }
            if (!TestSearchEngine.hasTestCaseType(javaProject)) {
                this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junitnotonpath, null, 10004);
            }
            if ((isJUnit4Configuration = "org.eclipse.jdt.junit.loader.junit4".equals((testKind = this.getTestRunnerKind(configuration)).getId())) && !TestSearchEngine.hasTestAnnotation(javaProject)) {
                this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_junit4notonpath, null, 10004);
            }
        }
        finally {
            monitor.done();
        }
    }

    private ITestKind getTestRunnerKind(ILaunchConfiguration configuration) {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind(configuration);
        if (testKind.isNull()) {
            testKind = TestKindRegistry.getDefault().getKind("org.eclipse.jdt.junit.loader.junit3");
        }
        return testKind;
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "org.eclipse.jdt.internal.junit.runner.RemoteTestRunner";
    }

    protected IMember[] evaluateTests(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IJavaElement testTarget = this.getTestTarget(configuration, javaProject);
        String testMethodName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        if (testMethodName.length() > 0 && testTarget instanceof IType) {
            return new IMember[]{((IType)testTarget).getMethod(testMethodName, new String[0])};
        }
        HashSet result = new HashSet();
        ITestKind testKind = this.getTestRunnerKind(configuration);
        testKind.getFinder().findTestsInContainer(testTarget, result, monitor);
        if (result.isEmpty()) {
            String msg = Messages.format(JUnitMessages.JUnitLaunchConfigurationDelegate_error_notests_kind, testKind.getDisplayName());
            this.informAndAbort(msg, null, 101);
        }
        return result.toArray(new IMember[result.size()]);
    }

    private void informAndAbort(String message, Throwable exception, int code) throws CoreException {
        Status status = new Status(1, "org.eclipse.jdt.junit", code, message, exception);
        if (this.showStatusMessage((IStatus)status)) {
            throw new CoreException((IStatus)status);
        }
        this.abort(message, exception, code);
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArguments) throws CoreException {
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        vmArguments.addAll(Arrays.asList(execArgs.getVMArgumentsArray()));
        programArguments.addAll(Arrays.asList(execArgs.getProgramArgumentsArray()));
        String testFailureNames = configuration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
        programArguments.add("-version");
        programArguments.add("3");
        programArguments.add("-port");
        programArguments.add(String.valueOf(this.fPort));
        if (this.fKeepAlive) {
            programArguments.add(0, "-keepalive");
        }
        ITestKind testRunnerKind = this.getTestRunnerKind(configuration);
        programArguments.add("-testLoaderClass");
        programArguments.add(testRunnerKind.getLoaderClassName());
        programArguments.add("-loaderpluginname");
        programArguments.add(testRunnerKind.getLoaderPluginId());
        IMember[] testElements = this.fTestElements;
        if (testElements.length == 1) {
            if (testElements[0] instanceof IMethod) {
                IMethod method = (IMethod)testElements[0];
                programArguments.add("-test");
                programArguments.add(String.valueOf(method.getDeclaringType().getFullyQualifiedName()) + ':' + method.getElementName());
            } else if (testElements[0] instanceof IType) {
                IType type = (IType)testElements[0];
                programArguments.add("-classNames");
                programArguments.add(type.getFullyQualifiedName());
            } else {
                this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_wrong_input, null, 101);
            }
        } else if (testElements.length > 1) {
            String fileName = this.createTestNamesFile(testElements);
            programArguments.add("-testNameFile");
            programArguments.add(fileName);
        }
        if (testFailureNames.length() > 0) {
            programArguments.add("-testfailures");
            programArguments.add(testFailureNames);
        }
    }

    private String createTestNamesFile(IMember[] testElements) throws CoreException {
        try {
            File file = File.createTempFile("testNames", ".txt");
            file.deleteOnExit();
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                int i = 0;
                while (i < testElements.length) {
                    if (testElements[i] instanceof IType) {
                        IType type = (IType)testElements[i];
                        String testName = type.getFullyQualifiedName();
                        bw.write(testName);
                        bw.newLine();
                    } else {
                        this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_wrong_input, null, 101);
                    }
                    ++i;
                }
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", 4, "", (Throwable)e));
        }
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] cp = super.getClasspath(configuration);
        ITestKind kind = this.getTestRunnerKind(configuration);
        List junitEntries = new ClasspathLocalizer(Platform.inDevelopmentMode()).localizeClasspath(kind);
        String[] classPath = new String[cp.length + junitEntries.size()];
        Object[] jea = junitEntries.toArray();
        System.arraycopy(cp, 0, classPath, 0, cp.length);
        System.arraycopy(jea, 0, classPath, cp.length, jea.length);
        return classPath;
    }

    private final IJavaElement getTestTarget(ILaunchConfiguration configuration, IJavaProject javaProject) throws CoreException {
        IType type;
        String containerHandle = configuration.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        if (containerHandle.length() != 0) {
            IJavaElement element = JavaCore.create((String)containerHandle);
            if (element == null || !element.exists()) {
                this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_error_input_element_deosn_not_exist, null, 101);
            }
            return element;
        }
        String testTypeName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        if (testTypeName.length() != 0 && (type = javaProject.findType(testTypeName = this.performStringSubstitution(testTypeName))) != null && type.exists()) {
            return type;
        }
        this.informAndAbort(JUnitMessages.JUnitLaunchConfigurationDelegate_input_type_does_not_exist, null, 101);
        return null;
    }

    private final String performStringSubstitution(String testTypeName) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(testTypeName);
    }

    private boolean showStatusMessage(final IStatus status) {
        final boolean[] success = new boolean[1];
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = JUnitPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    shell = JUnitLaunchConfigurationDelegate.this.getDisplay().getActiveShell();
                }
                if (shell != null) {
                    MessageDialog.openInformation((Shell)shell, (String)JUnitMessages.JUnitLaunchConfigurationDelegate_dialog_title, (String)status.getMessage());
                    success[0] = true;
                }
            }
        });
        return success[0];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", code, message, exception));
    }

    private static class ClasspathLocalizer {
        private boolean fInDevelopmentMode;

        public ClasspathLocalizer(boolean inDevelopmentMode) {
            this.fInDevelopmentMode = inDevelopmentMode;
        }

        public List localizeClasspath(ITestKind kind) {
            JUnitRuntimeClasspathEntry[] entries = kind.getClasspathEntries();
            ArrayList junitEntries = new ArrayList();
            int i = 0;
            while (i < entries.length) {
                try {
                    this.addEntry(junitEntries, entries[i]);
                }
                catch (IOException iOException) {
                    Assert.isTrue((boolean)false, (String)(String.valueOf(entries[i].getPluginId()) + " is available (required JAR)"));
                }
                ++i;
            }
            return junitEntries;
        }

        private void addEntry(List junitEntries, JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException {
            String entryString = this.entryString(entry);
            if (entryString != null) {
                junitEntries.add(entryString);
            }
        }

        private String entryString(JUnitRuntimeClasspathEntry entry) throws IOException, MalformedURLException {
            if (this.inDevelopmentMode()) {
                try {
                    return this.localURL(entry.developmentModeEntry());
                }
                catch (IOException iOException) {}
            }
            return this.localURL(entry);
        }

        private boolean inDevelopmentMode() {
            return this.fInDevelopmentMode;
        }

        private String localURL(JUnitRuntimeClasspathEntry jar) throws IOException, MalformedURLException {
            Bundle bundle = JUnitPlugin.getDefault().getBundle(jar.getPluginId());
            URL url = jar.getPluginRelativePath() == null ? bundle.getEntry("/") : bundle.getEntry(jar.getPluginRelativePath());
            if (url == null) {
                throw new IOException();
            }
            return FileLocator.toFileURL((URL)url).getFile();
        }
    }
}

