/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.builders;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.tools.internal.JNIGeneratorApp;
import org.eclipse.swt.tools.internal.MetaData;

public class JNIBuilder
extends IncrementalProjectBuilder {
    MetaData metaData = new MetaData("org.eclipse.swt.internal");
    MainClass[] classes;

    public JNIBuilder() {
        String mainClasses = this.metaData.getMetaData("swt_main_classes", null);
        if (mainClasses != null) {
            String[] list = mainClasses.split(",");
            this.classes = new MainClass[list.length / 2];
            int i = 0;
            while (i < list.length) {
                MainClass mainClass = new MainClass();
                this.classes[i / 2] = mainClass;
                MainClass clazz = mainClass;
                clazz.mainClassName = list[i];
                clazz.outputDir = list[i + 1].substring(2, list[i + 1].length());
                clazz.sourceDir = clazz.outputDir.substring(0, clazz.outputDir.length() - "library/".length());
                i += 2;
            }
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta == null) {
            return null;
        }
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IPath ipath = delta.getFullPath();
                if (!"java".equals(ipath.getFileExtension())) {
                    return true;
                }
                String path = ipath.toPortableString();
                int i = 0;
                while (i < JNIBuilder.this.classes.length) {
                    if (!JNIBuilder.this.classes[i].build && path.startsWith(JNIBuilder.this.classes[i].sourceDir)) {
                        JNIBuilder.this.classes[i].build = true;
                    }
                    ++i;
                }
                return true;
            }
        });
        IWorkspaceRoot root = this.getProject().getWorkspace().getRoot();
        int i = 0;
        while (i < this.classes.length) {
            MainClass mainClass = this.classes[i];
            if (mainClass.build) {
                mainClass.build = false;
                IResource library = root.findMember(mainClass.outputDir);
                JNIGeneratorApp gen = new JNIGeneratorApp();
                gen.setMainClassName(mainClass.mainClassName, library.getLocation().toPortableString());
                gen.generate();
                library.refreshLocal(2, null);
            }
            ++i;
        }
        return null;
    }

    static class MainClass {
        public String mainClassName;
        public String outputDir;
        public String sourceDir;
        public boolean build;

        MainClass() {
        }

        public String toString() {
            return String.valueOf(this.mainClassName) + "->" + this.outputDir;
        }
    }
}

