/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.swt.tools.internal.ASTClass;
import org.eclipse.swt.tools.internal.ASTItem;
import org.eclipse.swt.tools.internal.ASTType;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIType;

public class ASTField
extends ASTItem
implements JNIField {
    ASTClass declaringClass;
    String name;
    int modifiers;
    ASTType type;
    ASTType type64;
    String data;
    int start;

    public ASTField(ASTClass declaringClass, String source, FieldDeclaration field, VariableDeclarationFragment fragment) {
        this.declaringClass = declaringClass;
        this.name = fragment.getName().getIdentifier();
        this.modifiers = field.getModifiers();
        this.start = field.getStartPosition();
        Javadoc doc = field.getJavadoc();
        List tags = null;
        if (doc != null) {
            tags = doc.tags();
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                TagElement tag = (TagElement)iterator.next();
                if (!"@field".equals(tag.getTagName())) continue;
                String data = tag.fragments().get(0).toString();
                this.setMetaData(data);
                break;
            }
        }
        this.type64 = this.type = new ASTType(declaringClass.resolver, field.getType(), fragment.getExtraDimensions());
        String s = source.substring(field.getStartPosition(), field.getStartPosition() + field.getLength());
        if (this.type.isType("int") && s.indexOf("int /*long*/") != -1) {
            this.type64 = new ASTType("J");
        } else if (this.type.isType("float") && s.indexOf("float /*double*/") != -1) {
            this.type64 = new ASTType("D");
        } else if (this.type.isType("[I") && (s.indexOf("int /*long*/") != -1 || s.indexOf("int[] /*long[]*/") != -1)) {
            this.type64 = new ASTType("[J");
        } else if (this.type.isType("[F") && (s.indexOf("float /*double*/") != -1 || s.indexOf("float[] /*double[]*/") != -1)) {
            this.type64 = new ASTType("[D");
        } else if (this.type.isType("long") && s.indexOf("long /*int*/") != -1) {
            this.type = new ASTType("I");
        } else if (this.type.isType("double") && s.indexOf("double /*float*/") != -1) {
            this.type = new ASTType("F");
        } else if (this.type.isType("[J") && (s.indexOf("long /*int*/") != -1 || s.indexOf("long[] /*int[]*/") != -1)) {
            this.type = new ASTType("[I");
        } else if (this.type.isType("[D") && (s.indexOf("double /*float*/") != -1 || s.indexOf("double[] /*float[]*/") != -1)) {
            this.type = new ASTType("[F");
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ASTField)) {
            return false;
        }
        return ((ASTField)obj).getName().equals(this.getName());
    }

    public JNIClass getDeclaringClass() {
        return this.declaringClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public JNIType getType() {
        return this.type;
    }

    public JNIType getType64() {
        return this.type64;
    }

    public String getAccessor() {
        return (String)this.getParam("accessor");
    }

    public String getCast() {
        String cast = ((String)this.getParam("cast")).trim();
        if (cast.length() > 0) {
            if (!cast.startsWith("(")) {
                cast = "(" + cast;
            }
            if (!cast.endsWith(")")) {
                cast = String.valueOf(cast) + ")";
            }
        }
        return cast;
    }

    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    public String getMetaData() {
        if (this.data != null) {
            return this.data;
        }
        String className = this.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + this.getName();
        return this.declaringClass.metaData.getMetaData(key, "");
    }

    public void setAccessor(String str) {
        this.setParam("accessor", str);
    }

    public void setCast(String str) {
        this.setParam("cast", str);
    }

    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    public void setMetaData(String value) {
        this.data = value;
    }

    public String toString() {
        return this.getName();
    }
}

