/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIItem;

public abstract class AbstractItem
implements JNIItem {
    HashMap params;

    static String[] split(String str, String separator) {
        return JNIGenerator.split(str, separator);
    }

    void checkParams() {
        if (this.params != null) {
            return;
        }
        this.parse(this.getMetaData());
    }

    public abstract String flatten();

    public String[] getFlags() {
        Object flags = this.getParam("flags");
        if (flags == null) {
            return new String[0];
        }
        if (flags instanceof String[]) {
            return (String[])flags;
        }
        String[] result = AbstractItem.split((String)flags, " ");
        this.setParam("flags", result);
        return result;
    }

    public boolean getFlag(String flag) {
        String[] flags = this.getFlags();
        int i = 0;
        while (i < flags.length) {
            if (flags[i].equals(flag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract String getMetaData();

    public Object getParam(String key) {
        this.checkParams();
        Object value = this.params.get(key);
        return value == null ? "" : value;
    }

    public boolean getGenerate() {
        return !this.getFlag("no_gen");
    }

    public void setFlags(String[] flags) {
        this.setParam("flags", flags);
    }

    public abstract void parse(String var1);

    public void setFlag(String flag, boolean value) {
        String[] flags = this.getFlags();
        HashSet<String> set = new HashSet<String>(Arrays.asList(flags));
        if (value) {
            set.add(flag);
        } else {
            set.remove(flag);
        }
        this.setFlags(set.toArray(new String[set.size()]));
    }

    public void setGenerate(boolean value) {
        this.setFlag("no_gen", !value);
    }

    public abstract void setMetaData(String var1);

    public void setParam(String key, Object value) {
        this.checkParams();
        this.params.put(key, value);
        this.setMetaData(this.flatten());
    }
}

