/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.ReflectClass;

public class ConstantsGenerator
extends JNIGenerator {
    public void generate(JNIClass clazz) {
        JNIField[] fields = clazz.getDeclaredFields();
        this.generate(fields);
    }

    public void generate(JNIField[] fields) {
        ConstantsGenerator.sort(fields);
        this.outputln("int main() {");
        int i = 0;
        while (i < fields.length) {
            JNIField field = fields[i];
            if ((field.getModifiers() & 0x10) != 0) {
                this.generate(field);
            }
            ++i;
        }
        this.outputln("}");
    }

    public void generate(JNIField field) {
        JNIType type = field.getType();
        this.output("\tprintf(\"public static final ");
        this.output(field.getType().getTypeSignature3(false));
        this.output(" ");
        this.output(field.getName());
        this.output(" = ");
        if (type.isType("java.lang.String") || type.isType("[B")) {
            this.output("\"%s\"");
        } else {
            this.output("0x%x");
        }
        this.output(";\\n\", ");
        this.output(field.getName());
        this.outputln(");");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java ConstantsGenerator <className1> <className2>");
            return;
        }
        try {
            ConstantsGenerator gen = new ConstantsGenerator();
            int i = 0;
            while (i < args.length) {
                String clazzName = args[i];
                Class<?> clazz = Class.forName(clazzName);
                gen.generate(new ReflectClass(clazz));
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

