/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    static String ENCONDING = "UTF8";
    PrintStream out;
    String[] attributeFilter;
    String nodeFilter;

    public DOMWriter(PrintStream out) {
        this.out = new PrintStream(out);
    }

    String nodeName(Node node) {
        return node.getNodeName();
    }

    boolean filter(Attr attr) {
        if (this.attributeFilter == null) {
            return false;
        }
        String name = attr.getNodeName();
        int i = 0;
        while (i < this.attributeFilter.length) {
            if (name.matches(this.attributeFilter[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void print(String str) {
        this.out.print(str);
    }

    void println() {
        this.out.println();
    }

    public void print(Node node) {
        this.print(node, 0);
    }

    public void print(Node node, int level) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.print("<?xml version=\"1.0\" encoding=\"");
                this.print(ENCONDING);
                this.print("\"?>");
                this.println();
                this.print(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                Attr attr;
                Attr[] attrs = this.sort(node.getAttributes());
                String name = this.nodeName(node);
                boolean gen = name.equals("arg") || name.equals("retval");
                int i = 0;
                while (i < attrs.length && !gen) {
                    attr = attrs[i];
                    if (this.nodeName(attr).startsWith(this.nodeFilter)) {
                        gen = true;
                    }
                    ++i;
                }
                if (!gen) break;
                i = 0;
                while (i < level) {
                    this.print("\t");
                    ++i;
                }
                this.print("<");
                this.print(name);
                i = 0;
                while (i < attrs.length) {
                    attr = attrs[i];
                    if (!this.filter(attr)) {
                        this.print(" ");
                        this.print(this.nodeName(attr));
                        this.print("=\"");
                        this.print(this.normalize(attr.getNodeValue()));
                        this.print("\"");
                    }
                    ++i;
                }
                this.print(">");
                NodeList children = node.getChildNodes();
                int count = 0;
                if (children != null) {
                    int len = children.getLength();
                    int i2 = 0;
                    while (i2 < len) {
                        if (children.item(i2).getNodeType() == 1) {
                            ++count;
                        }
                        ++i2;
                    }
                    if (count > 0) {
                        this.println();
                    }
                    i2 = 0;
                    while (i2 < len) {
                        this.print(children.item(i2), level + 1);
                        ++i2;
                    }
                    if (count > 0) {
                        i2 = 0;
                        while (i2 < level) {
                            this.print("\t");
                            ++i2;
                        }
                    }
                }
                this.print("</");
                this.print(this.nodeName(node));
                this.print(">");
                this.println();
            }
        }
        this.out.flush();
    }

    Attr[] sort(NamedNodeMap attrs) {
        if (attrs == null) {
            return new Attr[0];
        }
        Attr[] result = new Attr[attrs.getLength()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Attr)attrs.item(i);
            ++i;
        }
        Arrays.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return DOMWriter.this.nodeName((Node)arg0).compareTo(DOMWriter.this.nodeName((Node)arg1));
            }
        });
        return result;
    }

    String normalize(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        int length = s.length();
        while (i < length) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    str.append("\"");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public void setNodeFilter(String filter) {
        this.nodeFilter = filter;
    }

    public void setAttributeFilter(String[] filter) {
        this.attributeFilter = filter;
    }
}

