/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.tools.internal.ASTClass;
import org.eclipse.swt.tools.internal.ASTField;
import org.eclipse.swt.tools.internal.ASTMethod;
import org.eclipse.swt.tools.internal.ASTParameter;
import org.eclipse.swt.tools.internal.AbstractItem;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;

public class EmbedMetaData
extends JNIGenerator {
    TreeMap inserts;

    public void generate(JNIClass clazz) {
        this.inserts = new TreeMap();
        String data = ((AbstractItem)((Object)clazz)).flatten();
        if (data != null && data.length() != 0) {
            String doc = "/** @jniclass " + data + " */" + this.delimiter;
            this.inserts.put(new Integer(((ASTClass)clazz).start), doc);
        }
        JNIField[] fields = clazz.getDeclaredFields();
        this.generate(fields);
        JNIMethod[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        if (this.inserts.size() == 0) {
            return;
        }
        String sourcePath = ((ASTClass)clazz).sourcePath;
        String source = JNIGenerator.loadFile(sourcePath);
        Set set = this.inserts.keySet();
        ArrayList keys = new ArrayList();
        keys.addAll(set);
        Collections.reverse(keys);
        StringBuffer buffer = new StringBuffer(source);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Integer index = (Integer)iterator.next();
            String doc = (String)this.inserts.get(index);
            buffer.insert((int)index, doc);
        }
        try {
            EmbedMetaData.output(buffer.toString().getBytes(), sourcePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.inserts = null;
    }

    public void generate(JNIField[] fields) {
        int i = 0;
        while (i < fields.length) {
            JNIField field = fields[i];
            int mods = field.getModifiers();
            if ((mods & 1) != 0 && (mods & 0x10) == 0 && (mods & 8) == 0) {
                this.generate(field);
            }
            ++i;
        }
    }

    public void generate(JNIField field) {
        field.setCast(field.getCast());
        String data = ((AbstractItem)((Object)field)).flatten();
        if (data != null && data.length() != 0) {
            String doc = "/** @field " + data + " */" + this.delimiter + "\t";
            this.inserts.put(new Integer(((ASTField)field).start), doc);
        }
    }

    public void generate(JNIMethod[] methods) {
        int i = 0;
        while (i < methods.length) {
            JNIMethod method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++i;
        }
    }

    public void generate(JNIMethod method) {
        ArrayList<String> tags = new ArrayList<String>();
        String data = ((AbstractItem)((Object)method)).flatten();
        if (data != null && data.length() != 0) {
            tags.add("@method " + data);
        }
        JNIParameter[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            ASTParameter param = (ASTParameter)params[i];
            param.setCast(param.getCast());
            data = ((AbstractItem)param).flatten();
            if (data != null && data.length() != 0) {
                tags.add("@param " + param.getName() + " " + data);
            }
            ++i;
        }
        if (tags.size() == 0) {
            return;
        }
        if (tags.size() == 1) {
            String doc = "/** " + (String)tags.get(0) + " */" + this.delimiter;
            this.inserts.put(new Integer(((ASTMethod)method).start), doc);
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("/**");
            buffer.append(this.delimiter);
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                String tag = (String)iterator.next();
                buffer.append(" * ");
                buffer.append(tag);
                buffer.append(this.delimiter);
            }
            buffer.append(" */");
            buffer.append(this.delimiter);
            this.inserts.put(new Integer(((ASTMethod)method).start), buffer.toString());
        }
    }
}

