/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.swt.tools.internal.Flags;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIItem;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ProgressMonitor;

public abstract class JNIGenerator
implements Flags {
    JNIClass mainClass;
    JNIClass[] classes;
    MetaData metaData;
    boolean isCPP;
    String delimiter = System.getProperty("line.separator");
    PrintStream output = System.out;
    ProgressMonitor progress;
    static final String JNI64 = "JNI64";

    public JNIGenerator() {
        this.metaData = new MetaData(new Properties());
    }

    public static String skipCopyrights(InputStream is) throws IOException {
        int state = 0;
        StringBuffer copyrights = new StringBuffer();
        while (state != 5) {
            int c = is.read();
            if (c == -1) {
                return null;
            }
            switch (state) {
                case 0: {
                    if (!Character.isWhitespace((char)c)) {
                        state = 1;
                    }
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (c == 42) {
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (c != 42) break;
                    state = 4;
                    break;
                }
                case 4: {
                    state = c == 47 ? 5 : 3;
                }
            }
            if (state <= 0) continue;
            copyrights.append((char)c);
        }
        return copyrights.toString();
    }

    public static boolean compare(InputStream is1, InputStream is2) throws IOException {
        int c1;
        JNIGenerator.skipCopyrights(is1);
        JNIGenerator.skipCopyrights(is2);
        do {
            int c2;
            if ((c1 = is1.read()) == (c2 = is2.read())) continue;
            return false;
        } while (c1 != -1);
        return true;
    }

    /*
     * Loose catch block
     */
    public static void output(byte[] bytes, String fileName) throws IOException {
        block17: {
            FileInputStream is;
            block16: {
                is = null;
                is = new FileInputStream(fileName);
                if (!JNIGenerator.compare(new ByteArrayInputStream(bytes), new BufferedInputStream(is))) break block16;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                return;
                catch (FileNotFoundException fileNotFoundException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(bytes);
        out.close();
    }

    String fixDelimiter(String str) {
        if (this.delimiter.equals("\n")) {
            return str;
        }
        int index = 0;
        int length = str.length();
        StringBuffer buffer = new StringBuffer();
        while (index != -1) {
            int start = index;
            if ((index = str.indexOf(10, start)) == -1) {
                buffer.append(str.substring(start, length));
                continue;
            }
            buffer.append(str.substring(start, index));
            buffer.append(this.delimiter);
            ++index;
        }
        return buffer.toString();
    }

    static String getFunctionName(JNIMethod method) {
        return JNIGenerator.getFunctionName(method, method.getParameterTypes());
    }

    static String getFunctionName(JNIMethod method, JNIType[] paramTypes) {
        if ((method.getModifiers() & 0x100) == 0) {
            return method.getName();
        }
        String function = JNIGenerator.toC(method.getName());
        if (!method.isNativeUnique()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(function);
            buffer.append("__");
            int i = 0;
            while (i < paramTypes.length) {
                JNIType paramType = paramTypes[i];
                buffer.append(JNIGenerator.toC(paramType.getTypeSignature(false)));
                ++i;
            }
            return buffer.toString();
        }
        return function;
    }

    static String loadFile(String file) {
        try {
            int read;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            StringBuffer str = new StringBuffer();
            char[] buffer = new char[1024];
            while ((read = br.read(buffer)) != -1) {
                str.append(buffer, 0, read);
            }
            fr.close();
            return str.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("File not found:" + file, e);
        }
    }

    static void sort(JNIMethod[] methods) {
        Arrays.sort(methods, new Comparator(){

            public int compare(Object a, Object b) {
                JNIMethod mth1 = (JNIMethod)a;
                JNIMethod mth2 = (JNIMethod)b;
                int result = mth1.getName().compareTo(mth2.getName());
                return result != 0 ? result : JNIGenerator.getFunctionName(mth1).compareTo(JNIGenerator.getFunctionName(mth2));
            }
        });
    }

    static void sort(JNIField[] fields) {
        Arrays.sort(fields, new Comparator(){

            public int compare(Object a, Object b) {
                return ((JNIField)a).getName().compareTo(((JNIField)b).getName());
            }
        });
    }

    static void sort(JNIClass[] classes) {
        Arrays.sort(classes, new Comparator(){

            public int compare(Object a, Object b) {
                return ((JNIClass)a).getName().compareTo(((JNIClass)b).getName());
            }
        });
    }

    static String[] split(String str, String separator) {
        StringTokenizer tk = new StringTokenizer(str, separator);
        ArrayList<Object> result = new ArrayList<Object>();
        while (tk.hasMoreElements()) {
            result.add(tk.nextElement());
        }
        return result.toArray(new String[result.size()]);
    }

    static String toC(String str) {
        int length = str.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            switch (c) {
                case '_': {
                    buffer.append("_1");
                    break;
                }
                case ';': {
                    buffer.append("_2");
                    break;
                }
                case '[': {
                    buffer.append("_3");
                    break;
                }
                case '.': {
                    buffer.append("_");
                    break;
                }
                case '/': {
                    buffer.append("_");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public abstract void generate(JNIClass var1);

    public void generateCopyright() {
    }

    public void generateIncludes() {
    }

    public void generate() {
        JNIClass clazz;
        if (this.classes == null) {
            return;
        }
        this.generateCopyright();
        this.generateIncludes();
        JNIGenerator.sort(this.classes);
        int i = 0;
        while (i < this.classes.length) {
            clazz = this.classes[i];
            if (clazz.getFlag("cpp")) {
                this.isCPP = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.classes.length) {
            clazz = this.classes[i];
            if (this.getGenerate(clazz)) {
                this.generate(clazz);
            }
            if (this.progress != null) {
                this.progress.step();
            }
            ++i;
        }
        this.output.flush();
    }

    public void generateMetaData(String key) {
        MetaData mt = this.getMetaData();
        String data = mt.getMetaData(key, null);
        if (data == null) {
            return;
        }
        if (data.length() == 0) {
            return;
        }
        this.outputln(this.fixDelimiter(data));
    }

    public JNIClass[] getClasses() {
        return this.classes;
    }

    public boolean getCPP() {
        return this.isCPP;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getExtension() {
        return this.getCPP() ? ".cpp" : ".c";
    }

    public String getFileName() {
        return String.valueOf(this.getOutputName()) + this.getSuffix() + this.getExtension();
    }

    protected boolean getGenerate(JNIItem item) {
        return item.getGenerate();
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public String getOutputName() {
        return this.getMainClass().getSimpleName().toLowerCase();
    }

    public JNIClass getMainClass() {
        return this.mainClass;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progress;
    }

    public String getSuffix() {
        return "";
    }

    public void output(String str) {
        this.output.print(str);
    }

    public void outputln() {
        this.output(this.getDelimiter());
    }

    public void outputln(String str) {
        this.output(str);
        this.output(this.getDelimiter());
    }

    public void setClasses(JNIClass[] classes) {
        this.classes = classes;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setMainClass(JNIClass mainClass) {
        this.mainClass = mainClass;
    }

    public void setMetaData(MetaData data) {
        this.metaData = data;
    }

    public void setOutput(PrintStream output) {
        this.output = output;
    }

    public void setProgressMonitor(ProgressMonitor progress) {
        this.progress = progress;
    }
}

