/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.internal.ConstantsGenerator;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIGeneratorApp;
import org.eclipse.swt.tools.internal.JNIGeneratorAppUI;
import org.eclipse.swt.tools.internal.JNIItem;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaDataGenerator;
import org.eclipse.swt.tools.internal.NativesGenerator;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.eclipse.swt.tools.internal.SizeofGenerator;
import org.eclipse.swt.tools.internal.StructsGenerator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class JNIGeneratorAppUI {
    Display display;
    Shell shell;
    Composite actionsPanel;
    Combo mainClassCb;
    Combo outputDirCb;
    Table classesLt;
    Table membersLt;
    Table paramsLt;
    ProgressBar progressBar;
    Label progressLabel;
    FileDialog fileDialog;
    TableEditor paramTextEditor;
    TableEditor memberTextEditor;
    TableEditor classTextEditor;
    FlagsEditor paramListEditor;
    FlagsEditor memberListEditor;
    FlagsEditor classListEditor;
    Text paramEditorTx;
    Text memberEditorTx;
    Text classEditorTx;
    List paramEditorLt;
    List memberEditorLt;
    List classEditorLt;
    JNIGeneratorApp app;
    static final int CLASS_NAME_COLUMN = 0;
    static final int CLASS_FLAGS_COLUMN = 1;
    static final int CLASS_EXCLUDE_COLUMN = 2;
    static final int FIELD_NAME_COLUMN = 0;
    static final int FIELD_FLAGS_COLUMN = 1;
    static final int FIELD_CAST_COLUMN = 2;
    static final int FIELD_ACCESSOR_COLUMN = 3;
    static final int FIELD_EXCLUDE_COLUMN = 4;
    static final int METHOD_NAME_COLUMN = 0;
    static final int METHOD_FLAGS_COLUMN = 1;
    static final int METHOD_ACCESSOR_COLUMN = 2;
    static final int METHOD_EXCLUDE_COLUMN = 3;
    static final int PARAM_INDEX_COLUMN = 0;
    static final int PARAM_TYPE_COLUMN = 1;
    static final int PARAM_FLAGS_COLUMN = 2;
    static final int PARAM_CAST_COLUMN = 3;

    public JNIGeneratorAppUI() {
        this(new JNIGeneratorApp());
    }

    public JNIGeneratorAppUI(JNIGeneratorApp app) {
        this.app = app;
    }

    void cleanup() {
        this.display.dispose();
    }

    void generateStructsHeader() {
        StructsGenerator gen = new StructsGenerator(true);
        gen.setMainClass(this.app.getMainClass());
        gen.setMetaData(this.app.getMetaData());
        gen.setClasses(this.getSelectedClasses());
        gen.generate();
    }

    void generateStructs() {
        StructsGenerator gen = new StructsGenerator(false);
        gen.setMainClass(this.app.getMainClass());
        gen.setMetaData(this.app.getMetaData());
        gen.setClasses(this.getSelectedClasses());
        gen.generate();
    }

    void generateSizeof() {
        SizeofGenerator gen = new SizeofGenerator();
        gen.setMainClass(this.app.getMainClass());
        gen.setMetaData(this.app.getMetaData());
        gen.setClasses(this.getSelectedClasses());
        gen.generate();
    }

    void generateMetaData() {
        MetaDataGenerator gen = new MetaDataGenerator();
        gen.setMainClass(this.app.getMainClass());
        gen.setMetaData(this.app.getMetaData());
        JNIMethod[] methods = this.getSelectedMethods();
        if (methods.length != 0) {
            gen.generate(methods);
        } else {
            gen.setClasses(this.getSelectedClasses());
            gen.generate();
        }
    }

    void generateNatives() {
        NativesGenerator gen = new NativesGenerator();
        gen.setMainClass(this.app.getMainClass());
        gen.setMetaData(this.app.getMetaData());
        JNIMethod[] methods = this.getSelectedMethods();
        if (methods.length != 0) {
            gen.generate(methods);
        } else {
            gen.setClasses(this.getSelectedClasses());
            gen.generate();
        }
    }

    void generateAll() {
        boolean showProgress;
        if (!this.updateOutputDir()) {
            return;
        }
        Cursor cursor = this.display.getSystemCursor(1);
        this.shell.setCursor(cursor);
        this.shell.setEnabled(false);
        Control[] children = this.actionsPanel.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child instanceof Button) {
                child.setEnabled(false);
            }
            ++i;
        }
        final boolean finalShowProgress = showProgress = true;
        if (showProgress) {
            this.progressLabel.setText("");
            this.progressBar.setSelection(0);
            this.progressLabel.setVisible(true);
            this.progressBar.setVisible(true);
        }
        final boolean[] done = new boolean[1];
        new Thread(){

            public void run() {
                try {
                    JNIGeneratorAppUI.this.app.generate(!finalShowProgress ? null : new ProgressMonitor(this){
                        int total;
                        int step;
                        int maximum;
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.maximum = 100;
                        }

                        public void setTotal(int total) {
                            this.total = total;
                            1.access$0(this.this$1).display.syncExec(new Runnable(this){
                                final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    1.access$0(2.access$0(this.this$2)).progressBar.setMaximum(this.this$2.maximum);
                                }
                            });
                        }

                        public void step() {
                            int oldValue = this.step * this.maximum / this.total;
                            ++this.step;
                            int newValue = this.step * this.maximum / this.total;
                            if (oldValue == newValue) {
                                return;
                            }
                            1.access$0(this.this$1).display.syncExec(new Runnable(this, newValue){
                                final /* synthetic */ 2 this$2;
                                private final /* synthetic */ int val$newValue;
                                {
                                    this.this$2 = var1_1;
                                    this.val$newValue = n;
                                }

                                public void run() {
                                    1.access$0(2.access$0(this.this$2)).progressBar.setSelection(this.val$newValue);
                                }
                            });
                        }

                        public void setMessage(String message) {
                            1.access$0(this.this$1).display.syncExec(new Runnable(this, message){
                                final /* synthetic */ 2 this$2;
                                private final /* synthetic */ String val$message;
                                {
                                    this.this$2 = var1_1;
                                    this.val$message = string;
                                }

                                public void run() {
                                    1.access$0(2.access$0(this.this$2)).progressLabel.setText(this.val$message);
                                    1.access$0(2.access$0(this.this$2)).progressLabel.update();
                                }
                            });
                        }

                        static /* synthetic */ 1 access$0(2 var0) {
                            return var0.this$1;
                        }
                    });
                }
                finally {
                    done[0] = true;
                    JNIGeneratorAppUI.this.display.wake();
                }
            }

            static /* synthetic */ JNIGeneratorAppUI access$0(1 var0) {
                return var0.JNIGeneratorAppUI.this;
            }
        }.start();
        while (!done[0]) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        int i2 = 0;
        while (i2 < children.length) {
            Control child = children[i2];
            if (child instanceof Button) {
                child.setEnabled(true);
            }
            ++i2;
        }
        if (showProgress) {
            this.progressBar.setVisible(false);
            this.progressLabel.setVisible(false);
        }
        this.shell.setEnabled(true);
        this.shell.setCursor(null);
    }

    void generateConstants() {
        ConstantsGenerator gen = new ConstantsGenerator();
        gen.setMainClass(this.app.getMainClass());
        gen.setMetaData(this.app.getMetaData());
        JNIField[] fields = this.getSelectedFields();
        if (fields.length != 0) {
            gen.generate(fields);
        } else {
            gen.setClasses(this.getSelectedClasses());
            gen.generate();
        }
    }

    JNIClass[] getSelectedClasses() {
        TableItem[] items = this.classesLt.getSelection();
        JNIClass[] classes = new JNIClass[items.length];
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            classes[i] = (JNIClass)item.getData();
            ++i;
        }
        return classes;
    }

    JNIMethod[] getSelectedMethods() {
        TableItem[] selection = this.membersLt.getSelection();
        JNIMethod[] methods = new JNIMethod[selection.length];
        int count = 0;
        int i = 0;
        while (i < selection.length) {
            TableItem item = selection[i];
            Object data = item.getData();
            if (data instanceof JNIMethod) {
                methods[count++] = (JNIMethod)data;
            }
            ++i;
        }
        if (count != methods.length) {
            JNIMethod[] result = new JNIMethod[count];
            System.arraycopy(methods, 0, result, 0, count);
            methods = result;
        }
        return methods;
    }

    JNIField[] getSelectedFields() {
        TableItem[] selection = this.membersLt.getSelection();
        JNIField[] fields = new JNIField[selection.length];
        int count = 0;
        int i = 0;
        while (i < selection.length) {
            TableItem item = selection[i];
            Object data = item.getData();
            if (data instanceof JNIField) {
                fields[count++] = (JNIField)data;
            }
            ++i;
        }
        if (count != fields.length) {
            JNIField[] result = new JNIField[count];
            System.arraycopy(fields, 0, result, 0, count);
            fields = result;
        }
        return fields;
    }

    public void open() {
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setText("JNI Generator");
        GridLayout shellLayout = new GridLayout();
        shellLayout.numColumns = 2;
        this.shell.setLayout((Layout)shellLayout);
        Composite panel = new Composite((Composite)this.shell, 0);
        GridData data = new GridData(1808);
        panel.setLayoutData((Object)data);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 1;
        panel.setLayout((Layout)panelLayout);
        Listener updateMainClassListener = new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.updateMainClass();
                if (!JNIGeneratorAppUI.this.updateOutputDir()) {
                    return;
                }
                JNIGeneratorAppUI.this.updateClasses();
                JNIGeneratorAppUI.this.updateMembers();
                JNIGeneratorAppUI.this.updateParameters();
            }
        };
        this.createMainClassPanel(panel, updateMainClassListener);
        this.createClassesPanel(panel);
        this.createMembersPanel(panel);
        this.createParametersPanel(panel);
        this.createActionButtons((Composite)this.shell);
        Point preferredSize = this.shell.computeSize(-1, -1);
        this.shell.setSize(this.shell.getSize().x, preferredSize.y);
        this.updateMainClass();
        this.updateClasses();
        this.updateMembers();
        this.updateParameters();
    }

    void createMainClassPanel(Composite panel, Listener updateListener) {
        Label mainClassLb = new Label(panel, 0);
        mainClassLb.setText("&Main Class:");
        this.mainClassCb = new Combo(panel, 4);
        String mainClass = this.app.getMainClassName();
        this.mainClassCb.setText(mainClass == null ? "" : mainClass);
        GridData data = new GridData(768);
        this.mainClassCb.setLayoutData((Object)data);
        this.mainClassCb.addListener(13, updateListener);
        this.mainClassCb.addListener(14, updateListener);
        Label outputDirLb = new Label(panel, 0);
        outputDirLb.setText("&Output Dir:");
        this.outputDirCb = new Combo(panel, 4);
        String outputDir = this.app.getOutputDir();
        this.outputDirCb.setText(outputDir == null ? "" : outputDir);
        data = new GridData(768);
        this.outputDirCb.setLayoutData((Object)data);
        this.outputDirCb.addListener(13, updateListener);
        this.outputDirCb.addListener(14, updateListener);
        String mainClasses = this.app.getMetaData().getMetaData("swt_main_classes", null);
        if (mainClasses != null) {
            String[] list = JNIGenerator.split(mainClasses, ",");
            int i = 0;
            while (i < list.length) {
                String className = list[i].trim();
                try {
                    Class.forName(className, false, this.getClass().getClassLoader());
                    this.mainClassCb.add(className);
                    this.outputDirCb.add(list[i + 1].trim());
                }
                catch (Exception exception) {}
                i += 2;
            }
        }
    }

    void createClassesPanel(Composite panel) {
        Label classesLb = new Label(panel, 0);
        classesLb.setText("&Classes:");
        this.classesLt = new Table(panel, 68386);
        GridData data = new GridData(1808);
        data.heightHint = this.classesLt.getItemHeight() * 6;
        this.classesLt.setLayoutData((Object)data);
        this.classesLt.setHeaderVisible(true);
        this.classesLt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 32) {
                    JNIGeneratorAppUI.this.updateGenerate((TableItem)e.item);
                } else {
                    JNIGeneratorAppUI.this.updateMembers();
                    JNIGeneratorAppUI.this.updateParameters();
                }
            }
        });
        TableColumn column = new TableColumn(this.classesLt, 0, 0);
        column.setText("Class");
        column = new TableColumn(this.classesLt, 0, 1);
        column.setText("Flags");
        this.classTextEditor = new TableEditor(this.classesLt);
        this.classTextEditor.grabHorizontal = true;
        this.classEditorTx = new Text((Composite)this.classesLt, 4);
        this.classTextEditor.setEditor((Control)this.classEditorTx);
        Listener classTextListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    switch (e.detail) {
                        case 2: {
                            JNIGeneratorAppUI.this.classTextEditor.setItem(null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                JNIGeneratorAppUI.this.classEditorTx.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.classTextEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.classTextEditor.getColumn();
                JNIClass clazz = (JNIClass)item.getData();
                if (column == 2) {
                    String text = JNIGeneratorAppUI.this.classEditorTx.getText();
                    clazz.setExclude(text);
                    item.setText(column, clazz.getExclude());
                    JNIGeneratorAppUI.this.classesLt.getColumn(column).pack();
                }
            }
        };
        this.classEditorTx.addListener(14, classTextListener);
        this.classEditorTx.addListener(16, classTextListener);
        this.classEditorTx.addListener(31, classTextListener);
        final Shell floater = new Shell(this.shell, 8);
        floater.setLayout((Layout)new FillLayout());
        this.classListEditor = new FlagsEditor(this.classesLt);
        this.classEditorLt = new List((Composite)floater, 2050);
        this.classEditorLt.setItems(JNIClass.FLAGS);
        floater.pack();
        floater.addListener(21, new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.classListEditor.setItem(null);
                e.doit = false;
                floater.setVisible(false);
            }
        });
        Listener classesListListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    switch (e.detail) {
                        case 4: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                floater.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.classListEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.classListEditor.getColumn();
                JNIClass clazz = (JNIClass)item.getData();
                if (column == 1) {
                    String[] flags = JNIGeneratorAppUI.this.classEditorLt.getSelection();
                    clazz.setFlags(flags);
                    item.setText(column, JNIGeneratorAppUI.this.getFlagsString(clazz.getFlags()));
                    item.setChecked(clazz.getGenerate());
                    JNIGeneratorAppUI.this.classesLt.getColumn(column).pack();
                }
            }
        };
        this.classEditorLt.addListener(14, classesListListener);
        this.classEditorLt.addListener(16, classesListListener);
        this.classEditorLt.addListener(31, classesListListener);
        this.classesLt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                e.display.asyncExec(new Runnable(this, e, floater){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ Event val$e;
                    private final /* synthetic */ Shell val$floater;
                    {
                        this.this$1 = var1_1;
                        this.val$e = event;
                        this.val$floater = shell;
                    }

                    public void run() {
                        if (11.access$0(this.this$1).classesLt.isDisposed()) {
                            return;
                        }
                        if (this.val$e.button != 1) {
                            return;
                        }
                        Point pt = new Point(this.val$e.x, this.val$e.y);
                        TableItem item = 11.access$0(this.this$1).classesLt.getItem(pt);
                        if (item == null) {
                            return;
                        }
                        int column = -1;
                        int i = 0;
                        while (i < 11.access$0(this.this$1).classesLt.getColumnCount()) {
                            if (item.getBounds(i).contains(pt)) {
                                column = i;
                                break;
                            }
                            ++i;
                        }
                        if (column == -1) {
                            return;
                        }
                        JNIClass data = (JNIClass)item.getData();
                        if (column == 2) {
                            11.access$0(this.this$1).classTextEditor.setColumn(column);
                            11.access$0(this.this$1).classTextEditor.setItem(item);
                            11.access$0(this.this$1).classEditorTx.setText(data.getExclude());
                            11.access$0(this.this$1).classEditorTx.selectAll();
                            11.access$0(this.this$1).classEditorTx.setVisible(true);
                            11.access$0(this.this$1).classEditorTx.setFocus();
                        } else if (column == 1) {
                            11.access$0(this.this$1).classListEditor.setColumn(column);
                            11.access$0(this.this$1).classListEditor.setItem(item);
                            11.access$0(this.this$1).classEditorLt.setSelection(data.getFlags());
                            this.val$floater.setLocation(11.access$0(this.this$1).classesLt.toDisplay(this.val$e.x, this.val$e.y));
                            this.val$floater.setVisible(true);
                            11.access$0(this.this$1).classEditorLt.setFocus();
                        }
                    }
                });
            }

            static /* synthetic */ JNIGeneratorAppUI access$0(11 var0) {
                return var0.JNIGeneratorAppUI.this;
            }
        });
    }

    void createMembersPanel(Composite panel) {
        Composite comp = new Composite(panel, 0);
        GridData data = new GridData(768);
        comp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Label membersLb = new Label(comp, 0);
        membersLb.setText("Mem&bers [regex]:");
        final Text searchText = new Text(comp, 132);
        searchText.setText(".*");
        data = new GridData(768);
        searchText.setLayoutData((Object)data);
        searchText.addListener(14, new Listener(){

            boolean match(int index, String pattern) {
                TableItem item = JNIGeneratorAppUI.this.membersLt.getItem(index);
                String text = item.getText();
                try {
                    if (text.matches(pattern)) {
                        JNIGeneratorAppUI.this.membersLt.setSelection(index);
                        return true;
                    }
                }
                catch (Exception exception) {}
                return false;
            }

            public void handleEvent(Event e) {
                String pattern = searchText.getText();
                int selection = JNIGeneratorAppUI.this.membersLt.getSelectionIndex();
                int count = JNIGeneratorAppUI.this.membersLt.getItemCount();
                int i = ++selection;
                while (i < count) {
                    if (this.match(i, pattern)) {
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < selection) {
                    if (this.match(i, pattern)) {
                        return;
                    }
                    ++i;
                }
            }
        });
        this.membersLt = new Table(panel, 68386);
        data = new GridData(1808);
        data.heightHint = this.membersLt.getItemHeight() * 6;
        this.membersLt.setLayoutData((Object)data);
        this.membersLt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 32) {
                    JNIGeneratorAppUI.this.updateGenerate((TableItem)e.item);
                } else {
                    JNIGeneratorAppUI.this.updateParameters();
                }
            }
        });
        this.memberTextEditor = new TableEditor(this.membersLt);
        this.memberTextEditor.grabHorizontal = true;
        this.memberEditorTx = new Text((Composite)this.membersLt, 4);
        this.memberTextEditor.setEditor((Control)this.memberEditorTx);
        Listener memberTextListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    switch (e.detail) {
                        case 2: {
                            JNIGeneratorAppUI.this.memberTextEditor.setItem(null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                JNIGeneratorAppUI.this.memberEditorTx.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.memberTextEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.memberTextEditor.getColumn();
                JNIItem memberData = (JNIItem)item.getData();
                String text = JNIGeneratorAppUI.this.memberEditorTx.getText();
                if (memberData instanceof JNIField) {
                    JNIField field = (JNIField)memberData;
                    switch (column) {
                        case 2: {
                            field.setCast(text);
                            item.setText(column, field.getCast());
                            break;
                        }
                        case 3: {
                            field.setAccessor(text.equals(field.getName()) ? "" : text);
                            item.setText(column, field.getAccessor());
                            break;
                        }
                        case 4: {
                            field.setExclude(text);
                            item.setText(column, field.getExclude());
                        }
                    }
                    JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
                } else if (memberData instanceof JNIMethod) {
                    JNIMethod method = (JNIMethod)memberData;
                    switch (column) {
                        case 2: {
                            method.setAccessor(text.equals(method.getName()) ? "" : text);
                            item.setText(column, method.getAccessor());
                            break;
                        }
                        case 3: {
                            method.setExclude(text);
                            item.setText(column, method.getExclude());
                        }
                    }
                    JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
                }
            }
        };
        this.memberEditorTx.addListener(14, memberTextListener);
        this.memberEditorTx.addListener(16, memberTextListener);
        this.memberEditorTx.addListener(31, memberTextListener);
        final Shell floater = new Shell(this.shell, 8);
        floater.setLayout((Layout)new FillLayout());
        this.memberListEditor = new FlagsEditor(this.membersLt);
        this.memberEditorLt = new List((Composite)floater, 2050);
        floater.addListener(21, new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.memberListEditor.setItem(null);
                e.doit = false;
                floater.setVisible(false);
            }
        });
        Listener memberListListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    switch (e.detail) {
                        case 4: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                floater.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.memberListEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.memberListEditor.getColumn();
                JNIItem data = (JNIItem)item.getData();
                String[] flags = JNIGeneratorAppUI.this.memberEditorLt.getSelection();
                data.setFlags(flags);
                item.setText(column, JNIGeneratorAppUI.this.getFlagsString(data.getFlags()));
                item.setChecked(data.getGenerate());
                JNIGeneratorAppUI.this.membersLt.getColumn(column).pack();
            }
        };
        this.memberEditorLt.addListener(14, memberListListener);
        this.memberEditorLt.addListener(16, memberListListener);
        this.memberEditorLt.addListener(31, memberListListener);
        this.membersLt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                e.display.asyncExec(new Runnable(this, e, floater){
                    final /* synthetic */ 18 this$1;
                    private final /* synthetic */ Event val$e;
                    private final /* synthetic */ Shell val$floater;
                    {
                        this.this$1 = var1_1;
                        this.val$e = event;
                        this.val$floater = shell;
                    }

                    public void run() {
                        if (18.access$0(this.this$1).membersLt.isDisposed()) {
                            return;
                        }
                        if (this.val$e.button != 1) {
                            return;
                        }
                        Point pt = new Point(this.val$e.x, this.val$e.y);
                        TableItem item = 18.access$0(this.this$1).membersLt.getItem(pt);
                        if (item == null) {
                            return;
                        }
                        int column = -1;
                        int i = 0;
                        while (i < 18.access$0(this.this$1).membersLt.getColumnCount()) {
                            if (item.getBounds(i).contains(pt)) {
                                column = i;
                                break;
                            }
                            ++i;
                        }
                        if (column == -1) {
                            return;
                        }
                        Object itemData = item.getData();
                        if (itemData instanceof JNIField) {
                            JNIField field = (JNIField)itemData;
                            if (column == 2 || column == 3 || column == 4) {
                                18.access$0(this.this$1).memberTextEditor.setColumn(column);
                                18.access$0(this.this$1).memberTextEditor.setItem(item);
                                String text = "";
                                switch (column) {
                                    case 2: {
                                        text = field.getCast();
                                        break;
                                    }
                                    case 3: {
                                        int index;
                                        text = field.getAccessor();
                                        if (text.length() != 0 || (index = (text = field.getName()).lastIndexOf(95)) == -1) break;
                                        char[] chars = text.toCharArray();
                                        chars[index] = 46;
                                        text = new String(chars);
                                        break;
                                    }
                                    case 4: {
                                        text = field.getExclude();
                                    }
                                }
                                18.access$0(this.this$1).memberEditorTx.setText(text);
                                18.access$0(this.this$1).memberEditorTx.selectAll();
                                18.access$0(this.this$1).memberEditorTx.setVisible(true);
                                18.access$0(this.this$1).memberEditorTx.setFocus();
                            } else if (column == 1) {
                                18.access$0(this.this$1).memberListEditor.setColumn(column);
                                18.access$0(this.this$1).memberListEditor.setItem(item);
                                18.access$0(this.this$1).memberEditorLt.setItems(JNIField.FLAGS);
                                18.access$0(this.this$1).memberEditorLt.setSelection(field.getFlags());
                                this.val$floater.setLocation(18.access$0(this.this$1).membersLt.toDisplay(this.val$e.x, this.val$e.y));
                                this.val$floater.pack();
                                this.val$floater.setVisible(true);
                                18.access$0(this.this$1).memberEditorLt.setFocus();
                            }
                        } else if (itemData instanceof JNIMethod) {
                            JNIMethod method = (JNIMethod)itemData;
                            if (column == 3 || column == 2) {
                                18.access$0(this.this$1).memberTextEditor.setColumn(column);
                                18.access$0(this.this$1).memberTextEditor.setItem(item);
                                String text = "";
                                switch (column) {
                                    case 2: {
                                        text = method.getAccessor();
                                        if (text.length() != 0) break;
                                        text = method.getName();
                                        break;
                                    }
                                    case 3: {
                                        text = method.getExclude();
                                    }
                                }
                                18.access$0(this.this$1).memberEditorTx.setText(text);
                                18.access$0(this.this$1).memberEditorTx.selectAll();
                                18.access$0(this.this$1).memberEditorTx.setVisible(true);
                                18.access$0(this.this$1).memberEditorTx.setFocus();
                            } else if (column == 1) {
                                18.access$0(this.this$1).memberListEditor.setColumn(column);
                                18.access$0(this.this$1).memberListEditor.setItem(item);
                                18.access$0(this.this$1).memberEditorLt.setItems(JNIMethod.FLAGS);
                                18.access$0(this.this$1).memberEditorLt.setSelection(method.getFlags());
                                this.val$floater.setLocation(18.access$0(this.this$1).membersLt.toDisplay(this.val$e.x, this.val$e.y));
                                this.val$floater.pack();
                                this.val$floater.setVisible(true);
                                18.access$0(this.this$1).memberEditorLt.setFocus();
                            }
                        }
                    }
                });
            }

            static /* synthetic */ JNIGeneratorAppUI access$0(18 var0) {
                return var0.JNIGeneratorAppUI.this;
            }
        });
    }

    void createParametersPanel(Composite panel) {
        Label paramsLb = new Label(panel, 0);
        paramsLb.setText("&Parameters:");
        this.paramsLt = new Table(panel, 68354);
        GridData data = new GridData(1808);
        int itemHeight = this.paramsLt.getItemHeight();
        data.heightHint = itemHeight * 6;
        this.paramsLt.setLayoutData((Object)data);
        this.paramsLt.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 32) {
                    JNIGeneratorAppUI.this.updateGenerate((TableItem)e.item);
                }
            }
        });
        TableColumn column = new TableColumn(this.paramsLt, 0, 0);
        column = new TableColumn(this.paramsLt, 0, 1);
        column.setText("Type");
        column = new TableColumn(this.paramsLt, 0, 2);
        column.setText("Flags");
        column = new TableColumn(this.paramsLt, 0, 3);
        column.setText("Cast");
        this.paramTextEditor = new TableEditor(this.paramsLt);
        this.paramTextEditor.grabHorizontal = true;
        this.paramEditorTx = new Text((Composite)this.paramsLt, 4);
        this.paramTextEditor.setEditor((Control)this.paramEditorTx);
        Listener paramTextListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    switch (e.detail) {
                        case 2: {
                            JNIGeneratorAppUI.this.paramTextEditor.setItem(null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                JNIGeneratorAppUI.this.paramEditorTx.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.paramTextEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.paramTextEditor.getColumn();
                JNIParameter param = (JNIParameter)item.getData();
                if (column == 3) {
                    String text = JNIGeneratorAppUI.this.paramEditorTx.getText();
                    param.setCast(text);
                    item.setText(column, param.getCast());
                    JNIGeneratorAppUI.this.paramsLt.getColumn(column).pack();
                }
            }
        };
        this.paramEditorTx.addListener(14, paramTextListener);
        this.paramEditorTx.addListener(16, paramTextListener);
        this.paramEditorTx.addListener(31, paramTextListener);
        final Shell floater = new Shell(this.shell, 8);
        floater.setLayout((Layout)new FillLayout());
        this.paramListEditor = new FlagsEditor(this.paramsLt);
        this.paramEditorLt = new List((Composite)floater, 2050);
        this.paramEditorLt.setItems(JNIParameter.FLAGS);
        floater.pack();
        floater.addListener(21, new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.paramListEditor.setItem(null);
                e.doit = false;
                floater.setVisible(false);
            }
        });
        Listener paramListListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    switch (e.detail) {
                        case 4: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                floater.setVisible(false);
                TableItem item = JNIGeneratorAppUI.this.paramListEditor.getItem();
                if (item == null) {
                    return;
                }
                int column = JNIGeneratorAppUI.this.paramListEditor.getColumn();
                JNIParameter param = (JNIParameter)item.getData();
                if (column == 2) {
                    String[] flags = JNIGeneratorAppUI.this.paramEditorLt.getSelection();
                    param.setFlags(flags);
                    item.setText(column, JNIGeneratorAppUI.this.getFlagsString(param.getFlags()));
                    JNIGeneratorAppUI.this.paramsLt.getColumn(column).pack();
                }
            }
        };
        this.paramEditorLt.addListener(14, paramListListener);
        this.paramEditorLt.addListener(16, paramListListener);
        this.paramEditorLt.addListener(31, paramListListener);
        this.paramsLt.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                e.display.asyncExec(new Runnable(this, e, floater){
                    final /* synthetic */ 24 this$1;
                    private final /* synthetic */ Event val$e;
                    private final /* synthetic */ Shell val$floater;
                    {
                        this.this$1 = var1_1;
                        this.val$e = event;
                        this.val$floater = shell;
                    }

                    public void run() {
                        if (24.access$0(this.this$1).paramsLt.isDisposed()) {
                            return;
                        }
                        if (this.val$e.button != 1) {
                            return;
                        }
                        Point pt = new Point(this.val$e.x, this.val$e.y);
                        TableItem item = 24.access$0(this.this$1).paramsLt.getItem(pt);
                        if (item == null) {
                            return;
                        }
                        int column = -1;
                        int i = 0;
                        while (i < 24.access$0(this.this$1).paramsLt.getColumnCount()) {
                            if (item.getBounds(i).contains(pt)) {
                                column = i;
                                break;
                            }
                            ++i;
                        }
                        if (column == -1) {
                            return;
                        }
                        JNIParameter param = (JNIParameter)item.getData();
                        if (column == 3) {
                            24.access$0(this.this$1).paramTextEditor.setColumn(column);
                            24.access$0(this.this$1).paramTextEditor.setItem(item);
                            24.access$0(this.this$1).paramEditorTx.setText(param.getCast());
                            24.access$0(this.this$1).paramEditorTx.selectAll();
                            24.access$0(this.this$1).paramEditorTx.setVisible(true);
                            24.access$0(this.this$1).paramEditorTx.setFocus();
                        } else if (column == 2) {
                            24.access$0(this.this$1).paramListEditor.setColumn(column);
                            24.access$0(this.this$1).paramListEditor.setItem(item);
                            24.access$0(this.this$1).paramEditorLt.setSelection(param.getFlags());
                            this.val$floater.setLocation(24.access$0(this.this$1).paramsLt.toDisplay(this.val$e.x, this.val$e.y));
                            this.val$floater.setVisible(true);
                            24.access$0(this.this$1).paramEditorLt.setFocus();
                        }
                    }
                });
            }

            static /* synthetic */ JNIGeneratorAppUI access$0(24 var0) {
                return var0.JNIGeneratorAppUI.this;
            }
        });
    }

    Button createActionButton(Composite parent, String text, Listener listener) {
        Button action = new Button(parent, 8);
        action.setText(text);
        GridData data = new GridData(768);
        action.setLayoutData((Object)data);
        action.addListener(13, listener);
        return action;
    }

    void createActionButtons(Composite parent) {
        this.actionsPanel = new Composite(parent, 0);
        GridData data = new GridData(1040);
        this.actionsPanel.setLayoutData((Object)data);
        GridLayout actionsLayout = new GridLayout();
        actionsLayout.numColumns = 1;
        this.actionsPanel.setLayout((Layout)actionsLayout);
        this.createActionButton(this.actionsPanel, "Generate &All", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateAll();
            }
        });
        Label separator = new Label(this.actionsPanel, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        separator = new Label(this.actionsPanel, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        this.createActionButton(this.actionsPanel, "Generate Structs &Header", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateStructsHeader();
            }
        });
        this.createActionButton(this.actionsPanel, "Generate &Structs", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateStructs();
            }
        });
        this.createActionButton(this.actionsPanel, "Generate &Natives", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateNatives();
            }
        });
        this.createActionButton(this.actionsPanel, "Generate Meta &Data", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateMetaData();
            }
        });
        this.createActionButton(this.actionsPanel, "Generate Cons&tants", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateConstants();
            }
        });
        this.createActionButton(this.actionsPanel, "Generate Si&zeof", new Listener(){

            public void handleEvent(Event e) {
                JNIGeneratorAppUI.this.generateSizeof();
            }
        });
        Composite filler = new Composite(this.actionsPanel, 0);
        filler.setLayoutData((Object)new GridData(1808));
        this.progressLabel = new Label(this.actionsPanel, 0);
        data = new GridData(768);
        this.progressLabel.setLayoutData((Object)data);
        this.progressLabel.setVisible(false);
        this.progressBar = new ProgressBar(this.actionsPanel, 0);
        data = new GridData(768);
        this.progressBar.setLayoutData((Object)data);
        this.progressBar.setVisible(false);
    }

    public void run() {
        this.shell.open();
        MessageBox box = new MessageBox(this.shell, 192);
        box.setText("Warning");
        box.setMessage("This tool is obsolete as of Eclipse 3.5 M2.\nThe meta data has been embedded in java source files.\nThere is a new plugin tool that replaces this tool.\nSee http://www.eclipse.org/swt/jnigen.php.\n\n Continue?");
        int result = box.open();
        if (result == 128) {
            this.shell.dispose();
        }
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.cleanup();
    }

    String getPackageString(String className) {
        int dot = this.app.getMainClassName().lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.app.getMainClassName().substring(0, dot);
    }

    String getClassString(JNIType type) {
        String name = type.getTypeSignature3(false);
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1, name.length());
    }

    String getFlagsString(String[] flags) {
        if (flags.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        while (j < flags.length) {
            String flag = flags[j];
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append(flag);
            ++j;
        }
        return buffer.toString();
    }

    String getMethodString(JNIMethod method) {
        String pkgName = this.getPackageString(method.getDeclaringClass().getName());
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getName());
        buffer.append("(");
        JNIParameter[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            String string;
            JNIParameter param = params[i];
            if (i != 0) {
                buffer.append(",");
            }
            if ((string = param.getType().getTypeSignature3(false)).startsWith(pkgName)) {
                string = string.substring(pkgName.length() + 1);
            }
            buffer.append(string);
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    String getFieldString(JNIField field) {
        return field.getName();
    }

    void updateClasses() {
        this.classesLt.removeAll();
        JNIClass[] classes = this.app.getClasses();
        int mainIndex = 0;
        int i = 0;
        while (i < classes.length) {
            JNIClass clazz = classes[i];
            if (clazz.equals(this.app.getMainClass())) {
                mainIndex = i;
            }
            TableItem item = new TableItem(this.classesLt, 0);
            item.setData((Object)clazz);
            item.setText(0, clazz.getSimpleName());
            item.setText(1, this.getFlagsString(clazz.getFlags()));
            item.setChecked(clazz.getGenerate());
            ++i;
        }
        TableColumn[] columns = this.classesLt.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            TableColumn column = columns[i2];
            column.pack();
            ++i2;
        }
        this.classesLt.setSelection(mainIndex);
    }

    void updateMembers() {
        TableColumn column;
        this.membersLt.removeAll();
        this.membersLt.setHeaderVisible(false);
        TableColumn[] columns = this.membersLt.getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn column2 = columns[i];
            column2.dispose();
            ++i;
        }
        int[] indices = this.classesLt.getSelectionIndices();
        if (indices.length != 1) {
            return;
        }
        TableItem classItem = this.classesLt.getItem(indices[0]);
        JNIClass clazz = (JNIClass)classItem.getData();
        boolean hasNatives = false;
        JNIMethod[] methods = clazz.getDeclaredMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            JNIMethod method = methods[i2];
            int mods = method.getModifiers();
            hasNatives = (mods & 0x100) != 0;
            if (hasNatives) break;
            ++i2;
        }
        this.membersLt.setRedraw(false);
        if (hasNatives) {
            column = new TableColumn(this.membersLt, 0, 0);
            column.setText("Method");
            column = new TableColumn(this.membersLt, 0, 1);
            column.setText("Flags");
            column = new TableColumn(this.membersLt, 0, 2);
            column.setText("Accessor");
            JNIGenerator.sort(methods);
            int i3 = 0;
            while (i3 < methods.length) {
                JNIMethod method = methods[i3];
                if ((method.getModifiers() & 0x100) != 0) {
                    TableItem item = new TableItem(this.membersLt, 0);
                    item.setData((Object)method);
                    item.setText(0, this.getMethodString(method));
                    item.setChecked(method.getGenerate());
                    item.setText(1, this.getFlagsString(method.getFlags()));
                    item.setText(2, method.getAccessor());
                }
                ++i3;
            }
        } else {
            column = new TableColumn(this.membersLt, 0, 0);
            column.setText("Field");
            column = new TableColumn(this.membersLt, 0, 1);
            column.setText("Flags");
            column = new TableColumn(this.membersLt, 0, 2);
            column.setText("Cast");
            column = new TableColumn(this.membersLt, 0, 3);
            column.setText("Accessor");
            JNIField[] fields = clazz.getDeclaredFields();
            int i4 = 0;
            while (i4 < fields.length) {
                JNIField field = fields[i4];
                int mods = field.getModifiers();
                if ((mods & 1) != 0 && (mods & 0x10) == 0 && (mods & 8) == 0) {
                    TableItem item = new TableItem(this.membersLt, 0);
                    item.setData((Object)field);
                    item.setText(0, this.getFieldString(field));
                    item.setChecked(field.getGenerate());
                    item.setText(2, field.getCast());
                    item.setText(1, this.getFlagsString(field.getFlags()));
                    item.setText(3, field.getAccessor());
                }
                ++i4;
            }
        }
        columns = this.membersLt.getColumns();
        i = 0;
        while (i < columns.length) {
            TableColumn column3 = columns[i];
            column3.pack();
            ++i;
        }
        this.membersLt.setHeaderVisible(true);
        this.membersLt.setRedraw(true);
    }

    void updateParameters() {
        this.paramsLt.removeAll();
        int[] indices = this.membersLt.getSelectionIndices();
        if (indices.length != 1) {
            this.paramsLt.setHeaderVisible(false);
            return;
        }
        TableItem memberItem = this.membersLt.getItem(indices[0]);
        Object data = memberItem.getData();
        if (!(data instanceof JNIMethod)) {
            return;
        }
        this.paramsLt.setRedraw(false);
        JNIMethod method = (JNIMethod)data;
        JNIParameter[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            JNIParameter param = params[i];
            TableItem item = new TableItem(this.paramsLt, 0);
            item.setData((Object)param);
            item.setText(0, String.valueOf(i));
            item.setText(1, this.getClassString(param.getType()));
            item.setText(3, param.getCast());
            item.setText(2, this.getFlagsString(param.getFlags()));
            ++i;
        }
        TableColumn[] columns = this.paramsLt.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            TableColumn column = columns[i2];
            column.pack();
            ++i2;
        }
        this.paramsLt.setRedraw(true);
        this.paramsLt.setHeaderVisible(true);
    }

    void updateGenerate(TableItem item) {
        JNIItem itemData = (JNIItem)item.getData();
        itemData.setGenerate(item.getChecked());
    }

    boolean updateOutputDir() {
        String outputDirStr = this.outputDirCb.getText();
        File file = new File(outputDirStr);
        if (!file.exists()) {
            MessageBox dialog = new MessageBox(this.shell, 33);
            dialog.setMessage("Output directory does not exist.");
            dialog.open();
            return false;
        }
        if (!file.isDirectory()) {
            MessageBox dialog = new MessageBox(this.shell, 33);
            dialog.setMessage("Output directory is not a directory.");
            dialog.open();
            return false;
        }
        if (outputDirStr.length() > 0) {
            if (!outputDirStr.equals(this.app.getOutputDir())) {
                this.app.setOutputDir(outputDirStr);
            }
            if (this.outputDirCb.indexOf(outputDirStr) == -1) {
                this.outputDirCb.add(outputDirStr);
            }
        }
        return true;
    }

    void updateMainClass() {
        String mainClassStr = this.mainClassCb.getText();
        if (mainClassStr.length() > 0) {
            int index;
            if (!mainClassStr.equals(this.app.getMainClassName())) {
                this.app.setMainClassName(mainClassStr);
            }
            if (this.mainClassCb.indexOf(mainClassStr) == -1) {
                this.mainClassCb.add(mainClassStr);
            }
            if (this.app.getOutputDir() != null && (index = this.outputDirCb.indexOf(this.app.getOutputDir())) != -1) {
                this.outputDirCb.select(index);
            }
        }
    }

    public static void main(String[] args) {
        JNIGeneratorApp gen = new JNIGeneratorApp();
        if (args.length > 0) {
            gen.setMainClassName(args[0]);
            if (args.length > 1) {
                gen.setOutputDir(args[1]);
            }
        } else {
            gen.setMainClassName(JNIGeneratorApp.getDefaultMainClass());
        }
        JNIGeneratorAppUI ui = new JNIGeneratorAppUI(gen);
        ui.open();
        ui.run();
    }

    static class FlagsEditor {
        Table parent;
        int column = -1;
        TableItem item;

        public FlagsEditor(Table parent) {
            this.parent = parent;
        }

        public int getColumn() {
            return this.column;
        }

        public TableItem getItem() {
            return this.item;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public void setItem(TableItem item) {
            this.item = item;
        }
    }
}

