/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.internal.MacGenerator;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MacGeneratorUI {
    MacGenerator gen;
    boolean actions = true;
    Tree nodesTree;
    Table attribTable;
    TreeItem lastParent;
    ArrayList flatNodes;

    public MacGeneratorUI(MacGenerator gen) {
        this.gen = gen;
    }

    TreeItem addChild(Node node, TreeItem superItem) {
        if (node.getNodeType() == 3) {
            return null;
        }
        String name = node.getNodeName();
        TreeItem parentItem = null;
        if (this.lastParent != null && !this.lastParent.isDisposed() && this.lastParent.getParentItem() == superItem && name.equals(this.lastParent.getData())) {
            parentItem = this.lastParent;
        } else {
            TreeItem[] items = superItem.getItems();
            int i = 0;
            while (i < items.length) {
                if (name.equals(items[i].getData())) {
                    parentItem = items[i];
                    break;
                }
                ++i;
            }
            if (parentItem == null) {
                parentItem = new TreeItem(superItem, 0);
                parentItem.setData((Object)name);
                parentItem.setText(this.getPrettyText(name));
            }
            this.lastParent = parentItem;
        }
        TreeItem item = new TreeItem(parentItem, 0);
        Node idAttrib = this.gen.getIDAttribute(node);
        item.setText(idAttrib != null ? idAttrib.getNodeValue() : name);
        item.setData((Object)node);
        this.checkItem(node, item);
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            new TreeItem(item, 0);
        }
        return item;
    }

    void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        this.updateGenAttribute(item);
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    void checkItem(Node node, TreeItem item) {
        NamedNodeMap attributes = node.getAttributes();
        Node gen = attributes.getNamedItem("swt_gen");
        if (gen != null) {
            String value = gen.getNodeValue();
            boolean grayed = value.equals("mixed");
            boolean checked = grayed || value.equals("true");
            item.setChecked(checked);
            item.setGrayed(grayed);
        }
    }

    boolean getEditable(TableItem item, int column) {
        if (!(item.getData() instanceof Node)) {
            return false;
        }
        String attribName = item.getText();
        return attribName.startsWith("swt_");
    }

    String getPrettyText(String text) {
        if (text.equals("class")) {
            return "Classes";
        }
        if (text.equals("depends_on")) {
            return "Depends_on";
        }
        return String.valueOf(text.substring(0, 1).toUpperCase()) + text.substring(1) + "s";
    }

    void checkChildren(TreeItem item) {
        TreeItem dummy;
        if (item.getItemCount() == 1 && (dummy = item.getItem(0)).getData() == null) {
            dummy.dispose();
            Node node = (Node)item.getData();
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            int length = childNodes.getLength();
            while (i < length) {
                this.addChild(childNodes.item(i), item);
                ++i;
            }
            TreeItem[] items = item.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                TreeItem[] children = items[i2].getItems();
                int checkedCount = 0;
                int j = 0;
                while (j < children.length) {
                    if (children[j].getChecked()) {
                        ++checkedCount;
                    }
                    if (children[j].getGrayed()) break;
                    ++j;
                }
                items[i2].setChecked(checkedCount != 0);
                items[i2].setGrayed(checkedCount != children.length);
                ++i2;
            }
        }
    }

    void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        this.updateGenAttribute(item);
        TreeItem[] items = item.getItems();
        if (items.length == 1 && items[0].getData() == null) {
            Node node = (Node)item.getData();
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            int length = childNodes.getLength();
            while (i < length) {
                this.checkNodes(childNodes.item(i), checked);
                ++i;
            }
        } else {
            int i = 0;
            while (i < items.length) {
                this.checkItems(items[i], checked);
                ++i;
            }
        }
    }

    void checkNodes(Node node, boolean checked) {
        if (node instanceof Element) {
            if (checked) {
                ((Element)node).setAttribute("swt_gen", "true");
            } else {
                ((Element)node).removeAttribute("swt_gen");
            }
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        int length = childNodes.getLength();
        while (i < length) {
            this.checkNodes(childNodes.item(i), checked);
            ++i;
        }
    }

    void cleanup() {
    }

    Composite createSignaturesPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Signatures:");
        final Text search = new Text(comp, 2180);
        GridData data = new GridData(768);
        search.setLayoutData((Object)data);
        search.setText(".*");
        search.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                MacGeneratorUI.this.searchFor(search.getText());
            }
        });
        search.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x100000F) {
                    MacGeneratorUI.this.searchFor(search.getText());
                }
            }
        });
        this.nodesTree = new Tree(comp, 67620);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.nodesTree.setLayoutData((Object)data);
        this.nodesTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    return;
                }
                if (event.detail != 32) {
                    MacGeneratorUI.this.selectChild(item);
                    return;
                }
                boolean checked = item.getChecked();
                item.getParent().setRedraw(false);
                MacGeneratorUI.this.checkItems(item, checked);
                MacGeneratorUI.this.checkPath(item.getParentItem(), checked, false);
                item.getParent().setRedraw(true);
            }
        });
        this.nodesTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                MacGeneratorUI.this.checkChildren((TreeItem)event.item);
            }
        });
        return comp;
    }

    Composite createPropertiesPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        if (!this.actions) {
            layout.marginRight = 5;
        }
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Properties:");
        this.attribTable = new Table(comp, 67584);
        GridData data = new GridData(1808);
        this.attribTable.setLayoutData((Object)data);
        this.attribTable.setLinesVisible(true);
        this.attribTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.attribTable, 0);
        nameColumn.setText("Name");
        nameColumn.pack();
        TableColumn valueColumn = new TableColumn(this.attribTable, 0);
        valueColumn.setText("Value");
        valueColumn.pack();
        final Text editorTx = new Text((Composite)this.attribTable, 4);
        final TableEditor editor = new TableEditor(this.attribTable);
        editor.grabHorizontal = true;
        editor.setEditor((Control)editorTx);
        Listener textListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 1 && e.keyCode != 0x100000F) {
                    return;
                }
                if (e.type == 31) {
                    switch (e.detail) {
                        case 2: {
                            editor.setItem(null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                editorTx.setVisible(false);
                TableItem item = editor.getItem();
                if (item == null) {
                    return;
                }
                int column = editor.getColumn();
                String value = editorTx.getText();
                item.setText(column, value);
                Element node = (Element)item.getData();
                String name = item.getText();
                if (value.length() != 0) {
                    node.setAttribute(name, value);
                } else {
                    node.removeAttribute(name);
                }
            }
        };
        editorTx.addListener(14, textListener);
        editorTx.addListener(1, textListener);
        editorTx.addListener(31, textListener);
        this.attribTable.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                e.display.asyncExec(new Runnable(this, e, editor, editorTx){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Event val$e;
                    private final /* synthetic */ TableEditor val$editor;
                    private final /* synthetic */ Text val$editorTx;
                    {
                        this.this$1 = var1_1;
                        this.val$e = event;
                        this.val$editor = tableEditor;
                        this.val$editorTx = text;
                    }

                    public void run() {
                        if (6.access$0(this.this$1).attribTable.isDisposed()) {
                            return;
                        }
                        if (this.val$e.button != 1) {
                            return;
                        }
                        Point pt = new Point(this.val$e.x, this.val$e.y);
                        TableItem item = 6.access$0(this.this$1).attribTable.getItem(pt);
                        if (item == null) {
                            return;
                        }
                        int column = -1;
                        int i = 0;
                        while (i < 6.access$0(this.this$1).attribTable.getColumnCount()) {
                            if (item.getBounds(i).contains(pt)) {
                                column = i;
                                break;
                            }
                            ++i;
                        }
                        if (column == -1) {
                            return;
                        }
                        if (!6.access$0(this.this$1).getEditable(item, column)) {
                            return;
                        }
                        this.val$editor.setColumn(column);
                        this.val$editor.setItem(item);
                        this.val$editorTx.setText(item.getText(column));
                        this.val$editorTx.selectAll();
                        this.val$editorTx.setVisible(true);
                        this.val$editorTx.setFocus();
                    }
                });
            }

            static /* synthetic */ MacGeneratorUI access$0(6 var0) {
                return var0.MacGeneratorUI.this;
            }
        });
        return comp;
    }

    Composite createActionsPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        panel.setLayout((Layout)layout);
        Button generate = new Button(panel, 8);
        generate.setText("Generate");
        generate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MacGeneratorUI.this.generate(null);
            }
        });
        return panel;
    }

    public void generate(ProgressMonitor progress) {
        this.gen.generate(progress);
    }

    public boolean getActionsVisible() {
        return this.actions;
    }

    public void open(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        Composite signaturePanel = this.createSignaturesPanel(parent);
        final Sash sash = new Sash(parent, 66048);
        Composite propertiesPanel = this.createPropertiesPanel(parent);
        Composite actionsPanel = null;
        if (this.actions) {
            actionsPanel = this.createActionsPanel(parent);
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        signaturePanel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(null, Math.max(200, parent.getSize().x / 2));
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        sash.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)sash, sash.computeSize((int)-1, (int)-1).x);
        data.top = new FormAttachment(0, 0);
        data.right = actionsPanel != null ? new FormAttachment((Control)actionsPanel, 0) : new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        propertiesPanel.setLayoutData((Object)data);
        if (actionsPanel != null) {
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            actionsPanel.setLayoutData((Object)data);
        }
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Composite parent = sash.getParent();
                Rectangle rect = parent.getClientArea();
                event.x = Math.min(Math.max(event.x, 60), rect.width - 60);
                if (event.detail != 1) {
                    FormData data = (FormData)sash.getLayoutData();
                    data.left.offset = event.x;
                    parent.layout(true);
                }
            }
        });
        this.updateNodes();
    }

    public void dispose() {
        this.cleanup();
    }

    void searchFor(String name) {
        Node attribName;
        Node child;
        TreeItem[] selection = this.nodesTree.getSelection();
        Node node = null;
        if (selection.length != 0) {
            if (selection[0].getData() instanceof Node) {
                node = (Node)selection[0].getData();
            } else if (selection[0].getItemCount() > 0 && selection[0].getItem(0).getData() instanceof Node) {
                node = (Node)selection[0].getItem(0).getData();
            }
        }
        Document[] documents = this.gen.getDocuments();
        if (node == null && documents.length > 0) {
            node = this.gen.getDocuments()[0];
        }
        if (this.flatNodes == null) {
            this.flatNodes = new ArrayList();
            int i = 0;
            while (i < documents.length) {
                this.addNodes(documents[i], this.flatNodes);
                ++i;
            }
        }
        int index = 0;
        while (this.flatNodes.get(index++) != node) {
        }
        int start = index;
        while (index < this.flatNodes.size()) {
            child = (Node)this.flatNodes.get(index);
            attribName = this.gen.getIDAttribute(child);
            if (attribName != null && attribName.getNodeValue().matches(name)) {
                this.selectNode(child);
                return;
            }
            ++index;
        }
        index = 0;
        while (index < start) {
            child = (Node)this.flatNodes.get(index);
            attribName = this.gen.getIDAttribute(child);
            if (attribName != null && attribName.getNodeValue().matches(name)) {
                this.selectNode(child);
                return;
            }
            ++index;
        }
        this.nodesTree.getDisplay().beep();
    }

    void selectNode(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        do {
            path.add(node);
        } while ((node = node.getParentNode()) != null);
        TreeItem[] items = this.nodesTree.getItems();
        Collections.reverse(path);
        path.remove(0);
        TreeItem item;
        while ((item = this.findItem(items, (Node)path.remove(0))) != null) {
            if (path.isEmpty()) {
                this.nodesTree.setSelection(item);
                this.selectChild(item);
                return;
            }
            items = item.getItems();
        }
        return;
    }

    TreeItem findItem(TreeItem[] items, Node node) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            this.checkChildren(item);
            if (item.getData() == node) {
                return item;
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            TreeItem child = this.findItem(items[i].getItems(), node);
            if (child != null) {
                return child;
            }
            ++i;
        }
        return null;
    }

    void addNodes(Node node, ArrayList list) {
        if (node.getNodeType() == 3) {
            return;
        }
        list.add(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        int length = children.getLength();
        while (i < length) {
            Node child = children.item(i);
            this.addNodes(child, list);
            ++i;
        }
    }

    void selectChild(TreeItem item) {
        Node attrib;
        this.attribTable.removeAll();
        if (!(item.getData() instanceof Node)) {
            return;
        }
        Node node = (Node)item.getData();
        NamedNodeMap attributes = node.getAttributes();
        String[] extraAttribs = this.gen.getExtraAttributeNames(node);
        int i = 0;
        while (i < extraAttribs.length) {
            TableItem attribItem = new TableItem(this.attribTable, 0);
            attribItem.setText(extraAttribs[i]);
            attribItem.setData((Object)node);
            attribItem.setForeground(item.getDisplay().getSystemColor(9));
            attrib = attributes.getNamedItem(extraAttribs[i]);
            if (attrib != null) {
                attribItem.setText(1, attrib.getNodeValue());
            }
            ++i;
        }
        this.checkItem(node, item);
        i = 0;
        int length = attributes.getLength();
        while (i < length) {
            attrib = attributes.item(i);
            String attribName = attrib.getNodeName();
            if (!attribName.startsWith("swt_")) {
                TableItem attribItem = new TableItem(this.attribTable, 0);
                attribItem.setText(attribName);
                attribItem.setText(1, attrib.getNodeValue());
            }
            ++i;
        }
        this.attribTable.getColumn(0).pack();
        this.attribTable.getColumn(1).setWidth(500);
    }

    void updateGenAttribute(TreeItem item) {
        if (item.getData() instanceof Element) {
            Element node = (Element)item.getData();
            if (item.getChecked()) {
                if (item.getGrayed()) {
                    node.setAttribute("swt_gen", "mixed");
                } else {
                    node.setAttribute("swt_gen", "true");
                }
            } else {
                node.removeAttribute("swt_gen");
            }
        }
    }

    void updateNodes() {
        String[] xmls = this.gen.getXmls();
        if (xmls == null) {
            return;
        }
        Document[] documents = this.gen.getDocuments();
        int x = 0;
        while (x < xmls.length) {
            String xmlPath = xmls[x];
            Document document = documents[x];
            if (document == null) {
                System.out.println("Could not find: " + xmlPath);
            } else {
                TreeItem item = new TreeItem(this.nodesTree, 0);
                String fileName = this.gen.getFileName(xmlPath);
                if (fileName.endsWith("Full.bridgesupport")) {
                    fileName = fileName.substring(0, fileName.length() - "Full.bridgesupport".length());
                }
                item.setText(fileName);
                Element node = document.getDocumentElement();
                item.setData((Object)node);
                this.checkItem(node, item);
                new TreeItem(item, 0);
            }
            ++x;
        }
        TreeColumn[] columns = this.nodesTree.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
    }

    public void refresh() {
        if (this.nodesTree == null) {
            return;
        }
        this.gen.setXmls(null);
        this.flatNodes = null;
        this.nodesTree.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (MacGeneratorUI.this.nodesTree == null || MacGeneratorUI.this.nodesTree.isDisposed()) {
                    return;
                }
                MacGeneratorUI.this.nodesTree.removeAll();
                MacGeneratorUI.this.attribTable.removeAll();
                MacGeneratorUI.this.updateNodes();
            }
        });
    }

    public void setActionsVisible(boolean visible) {
        this.actions = visible;
    }

    public void setFocus() {
        this.nodesTree.setFocus();
    }

    public static void main(String[] args) {
        try {
            Display display = new Display();
            Shell shell = new Shell(display);
            MacGenerator gen = new MacGenerator();
            gen.setXmls(args);
            gen.setOutputDir("../org.eclipse.swt/Eclipse SWT PI/cocoa/");
            gen.setMainClass("org.eclipse.swt.internal.cocoa.OS");
            MacGeneratorUI ui = new MacGeneratorUI(gen);
            ui.open((Composite)shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            ui.dispose();
            display.dispose();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

