/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class NativeStats {
    Hashtable snapshot = this.snapshot();
    static final String[] classes = new String[]{"OS", "ATK", "CDE", "GNOME", "GTK", "XPCOM", "COM", "AGL", "Gdip", "GLX", "Cairo", "WGL"};

    public Hashtable diff() {
        Hashtable newSnapshot = this.snapshot();
        Enumeration keys = newSnapshot.keys();
        while (keys.hasMoreElements()) {
            String className = (String)keys.nextElement();
            NativeFunction[] newFuncs = (NativeFunction[])newSnapshot.get(className);
            NativeFunction[] funcs = (NativeFunction[])this.snapshot.get(className);
            if (funcs == null) continue;
            int i = 0;
            while (i < newFuncs.length) {
                newFuncs[i].subtract(funcs[i]);
                ++i;
            }
        }
        return newSnapshot;
    }

    public void dumpDiff(PrintStream ps) {
        this.dump(this.diff(), ps);
    }

    public void dumpSnapshot(PrintStream ps) {
        this.dump(this.snapshot(), ps);
    }

    public void dumpSnapshot(String className, PrintStream ps) {
        Hashtable snapshot = new Hashtable();
        this.snapshot(className, snapshot);
        this.dump(className, (NativeFunction[])snapshot.get(className), ps);
    }

    public void dump(Hashtable snapshot, PrintStream ps) {
        Enumeration keys = snapshot.keys();
        while (keys.hasMoreElements()) {
            String className = (String)keys.nextElement();
            this.dump(className, (NativeFunction[])snapshot.get(className), ps);
        }
    }

    void dump(String className, NativeFunction[] funcs, PrintStream ps) {
        NativeFunction func;
        if (funcs == null) {
            return;
        }
        Arrays.sort(funcs);
        int total = 0;
        int i = 0;
        while (i < funcs.length) {
            func = funcs[i];
            total += func.getCallCount();
            ++i;
        }
        ps.print(className);
        ps.print("=");
        ps.print(total);
        ps.println();
        i = 0;
        while (i < funcs.length) {
            func = funcs[i];
            if (func.getCallCount() > 0) {
                ps.print("\t");
                ps.print(func.getName());
                ps.print("=");
                ps.print(func.getCallCount());
                ps.println();
            }
            ++i;
        }
    }

    public void reset() {
        this.snapshot = this.snapshot();
    }

    public Hashtable snapshot() {
        Hashtable snapshot = new Hashtable();
        int i = 0;
        while (i < classes.length) {
            String className = classes[i];
            this.snapshot(className, snapshot);
            ++i;
        }
        return snapshot;
    }

    public Hashtable snapshot(String className, Hashtable snapshot) {
        try {
            Class<?> clazz = this.getClass();
            Method functionCount = clazz.getMethod(String.valueOf(className) + "_GetFunctionCount", new Class[0]);
            Method functionCallCount = clazz.getMethod(String.valueOf(className) + "_GetFunctionCallCount", Integer.TYPE);
            Method functionName = clazz.getMethod(String.valueOf(className) + "_GetFunctionName", Integer.TYPE);
            int count = (Integer)functionCount.invoke(clazz, new Object[0]);
            NativeFunction[] funcs = new NativeFunction[count];
            Object[] index = new Object[1];
            int i = 0;
            while (i < count) {
                index[0] = new Integer(i);
                int callCount = (Integer)functionCallCount.invoke(clazz, index);
                String name = (String)functionName.invoke(clazz, index);
                funcs[i] = new NativeFunction(name, callCount);
                ++i;
            }
            snapshot.put(className, funcs);
        }
        catch (Throwable throwable) {}
        return snapshot;
    }

    public static final native int OS_GetFunctionCount();

    public static final native String OS_GetFunctionName(int var0);

    public static final native int OS_GetFunctionCallCount(int var0);

    public static final native int ATK_GetFunctionCount();

    public static final native String ATK_GetFunctionName(int var0);

    public static final native int ATK_GetFunctionCallCount(int var0);

    public static final native int AGL_GetFunctionCount();

    public static final native String AGL_GetFunctionName(int var0);

    public static final native int AGL_GetFunctionCallCount(int var0);

    public static final native int CDE_GetFunctionCount();

    public static final native String CDE_GetFunctionName(int var0);

    public static final native int CDE_GetFunctionCallCount(int var0);

    public static final native int Gdip_GetFunctionCount();

    public static final native String Gdip_GetFunctionName(int var0);

    public static final native int Gdip_GetFunctionCallCount(int var0);

    public static final native int GLX_GetFunctionCount();

    public static final native String GLX_GetFunctionName(int var0);

    public static final native int GLX_GetFunctionCallCount(int var0);

    public static final native int GNOME_GetFunctionCount();

    public static final native String GNOME_GetFunctionName(int var0);

    public static final native int GNOME_GetFunctionCallCount(int var0);

    public static final native int GTK_GetFunctionCount();

    public static final native String GTK_GetFunctionName(int var0);

    public static final native int GTK_GetFunctionCallCount(int var0);

    public static final native int XPCOM_GetFunctionCount();

    public static final native String XPCOM_GetFunctionName(int var0);

    public static final native int XPCOM_GetFunctionCallCount(int var0);

    public static final native int COM_GetFunctionCount();

    public static final native String COM_GetFunctionName(int var0);

    public static final native int COM_GetFunctionCallCount(int var0);

    public static final native int WGL_GetFunctionCount();

    public static final native String WGL_GetFunctionName(int var0);

    public static final native int WGL_GetFunctionCallCount(int var0);

    public static final native int Cairo_GetFunctionCount();

    public static final native String Cairo_GetFunctionName(int var0);

    public static final native int Cairo_GetFunctionCallCount(int var0);

    public static class NativeFunction
    implements Comparable {
        String name;
        int callCount;

        public NativeFunction(String name, int callCount) {
            this.name = name;
            this.callCount = callCount;
        }

        void subtract(NativeFunction func) {
            this.callCount -= func.callCount;
        }

        public int getCallCount() {
            return this.callCount;
        }

        public String getName() {
            return this.name;
        }

        public int compareTo(Object func) {
            return ((NativeFunction)func).callCount - this.callCount;
        }
    }
}

