/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.tools.internal.AbstractItem;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.ReflectType;

public abstract class ReflectItem
extends AbstractItem {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static boolean convertTo32Bit(JNIType[] paramTypes, boolean floatingPointTypes) {
        boolean changed = false;
        int i = 0;
        while (i < paramTypes.length) {
            JNIType paramType = paramTypes[i];
            if (paramType.isType("long")) {
                paramTypes[i] = new ReflectType(Integer.TYPE);
                changed = true;
            }
            if (paramType.isType("[J")) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[I");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                paramTypes[i] = new ReflectType(clazz);
                changed = true;
            }
            if (floatingPointTypes) {
                if (paramType.isType("double")) {
                    paramTypes[i] = new ReflectType(Float.TYPE);
                    changed = true;
                }
                if (paramType.isType("[D")) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[F");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    paramTypes[i] = new ReflectType(clazz);
                    changed = true;
                }
            }
            ++i;
        }
        return changed;
    }

    boolean canChange64(Class clazz) {
        if (clazz != Integer.TYPE && clazz != Long.TYPE && clazz != Float.TYPE && clazz != Double.TYPE) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[I");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("[J");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz3) {
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("[F");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz != clazz4) {
                        Class<?> clazz5 = class$3;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$3 = Class.forName("[D");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz != clazz5) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public String flatten() {
        this.checkParams();
        StringBuffer buffer = new StringBuffer();
        Set set = this.params.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        int j = 0;
        while (j < keys.length) {
            Object key = keys[j];
            Object value = this.params.get(key);
            String valueStr = "";
            if (value instanceof String) {
                valueStr = (String)value;
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuffer valueBuffer = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    if (i != 0) {
                        valueBuffer.append(" ");
                    }
                    valueBuffer.append(values[i]);
                    ++i;
                }
                valueStr = valueBuffer.toString();
            } else {
                valueStr = value.toString();
            }
            if (valueStr.length() > 0) {
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append((String)key);
                buffer.append("=");
                buffer.append(valueStr);
            }
            ++j;
        }
        return buffer.toString();
    }

    public void parse(String str) {
        this.params = new HashMap();
        if (str.length() == 0) {
            return;
        }
        String[] params = ReflectItem.split(str, ",");
        int i = 0;
        while (i < params.length) {
            String param = params[i];
            int equals = param.indexOf(61);
            if (equals == -1) {
                System.out.println("Error: " + str + " param " + param);
            }
            String key = param.substring(0, equals).trim();
            String value = param.substring(equals + 1).trim();
            this.setParam(key, value);
            ++i;
        }
    }
}

