/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectMethod;
import org.eclipse.swt.tools.internal.ReflectType;

public class ReflectParameter
extends ReflectItem
implements JNIParameter {
    ReflectMethod method;
    int parameter;

    public ReflectParameter(ReflectMethod method, int parameter) {
        this.method = method;
        this.parameter = parameter;
    }

    public String getCast() {
        String cast = ((String)this.getParam("cast")).trim();
        if (cast.length() > 0) {
            if (!cast.startsWith("(")) {
                cast = "(" + cast;
            }
            if (!cast.endsWith(")")) {
                cast = String.valueOf(cast) + ")";
            }
        }
        return cast;
    }

    public String getMetaData() {
        MetaData metaData = this.method.declaringClass.metaData;
        String className = this.method.getDeclaringClass().getSimpleName();
        String key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method) + "_" + this.parameter;
        String value = metaData.getMetaData(key, null);
        if (value == null) {
            key = String.valueOf(className) + "_" + this.method.getName() + "_" + this.parameter;
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            JNIType[] paramTypes = this.method.getParameterTypes();
            if (ReflectItem.convertTo32Bit(paramTypes, true)) {
                key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method, paramTypes) + "_" + this.parameter;
                value = metaData.getMetaData(key, null);
            }
            if (value == null && ReflectItem.convertTo32Bit(paramTypes = this.method.getParameterTypes(), false)) {
                key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method, paramTypes) + "_" + this.parameter;
                value = metaData.getMetaData(key, null);
            }
        }
        if (value == null && this.method.getName().startsWith("_") && (value = metaData.getMetaData(key = String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method).substring(2) + "_" + this.parameter, null)) == null) {
            key = String.valueOf(className) + "_" + this.method.getName().substring(1) + "_" + this.parameter;
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public JNIMethod getMethod() {
        return this.method;
    }

    public JNIClass getTypeClass() {
        ReflectType type = (ReflectType)this.getType();
        ReflectClass declaringClass = this.method.declaringClass;
        String sourcePath = declaringClass.sourcePath;
        sourcePath = String.valueOf(new File(sourcePath).getParent()) + "/" + type.getSimpleName() + ".java";
        return new ReflectClass(type.clazz, declaringClass.metaData, sourcePath);
    }

    public JNIType getType() {
        return this.method.getParameterTypes()[this.parameter];
    }

    public JNIType getType64() {
        return this.method.getParameterTypes64()[this.parameter];
    }

    public int getParameter() {
        return this.parameter;
    }

    public void setCast(String str) {
        this.setParam("cast", str);
    }

    public void setMetaData(String value) {
        String className = this.method.getDeclaringClass().getSimpleName();
        String key = this.method.isNativeUnique() ? String.valueOf(className) + "_" + this.method.getName() + "_" + this.parameter : String.valueOf(className) + "_" + JNIGenerator.getFunctionName(this.method) + "_" + this.parameter;
        this.method.declaringClass.metaData.setMetaData(key, value);
    }
}

