/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.views;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.tools.Activator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class SpyView
extends ViewPart {
    private StyledText output;
    private Action spyAction;
    private Listener keyFilter;
    private Runnable timer;
    private Control lastControl;
    private Field field;
    static final int TIMEOUT = 100;

    public void createPartControl(Composite parent) {
        this.output = new StyledText(parent, 778);
        this.keyFilter = new Listener(){

            public void handleEvent(Event e) {
                if (e.keyCode == 46 && e.stateMask == 458752) {
                    if (SpyView.this.spyAction.isChecked()) {
                        SpyView.this.spyAction.setChecked(false);
                    } else {
                        SpyView.this.spyAction.setChecked(true);
                        SpyView.this.spyAction.run();
                    }
                    e.type = 0;
                }
            }
        };
        parent.getDisplay().addFilter(1, this.keyFilter);
        this.timer = new Runnable(){

            public void run() {
                if (SpyView.this.output == null || SpyView.this.output.isDisposed() || !SpyView.this.spyAction.isChecked()) {
                    return;
                }
                Display display = SpyView.this.output.getDisplay();
                Control control = display.getCursorControl();
                if (control != SpyView.this.lastControl) {
                    StringBuffer text = new StringBuffer();
                    if (control != null) {
                        Error error;
                        Composite parent;
                        text.append(control + "@" + SpyView.this.getOSHandle(control) + "\n");
                        text.append("\tStyle: " + SpyView.this.getStyle((Widget)control) + "\n");
                        text.append("\tLayout Data: " + control.getLayoutData() + "\n");
                        text.append("\tBounds: " + control.getBounds() + "\n");
                        text.append("\n");
                        if (control instanceof Composite) {
                            text.append("\nChildren:\n");
                            Control[] children = ((Composite)control).getChildren();
                            int i = 0;
                            while (i < children.length) {
                                text.append("\t" + children[i] + "\n");
                                ++i;
                            }
                        }
                        if ((parent = control.getParent()) != null) {
                            text.append("\nPeers:\n");
                            Control[] peers = parent.getChildren();
                            int i = 0;
                            while (i < peers.length) {
                                text.append("\t");
                                if (peers[i] == control) {
                                    text.append("*");
                                }
                                text.append(peers[i] + "@" + SpyView.this.getOSHandle(peers[i]));
                                text.append(" Layout Data: " + peers[i].getLayoutData());
                                text.append(" Bounds: " + peers[i].getBounds());
                                text.append("\n");
                                ++i;
                            }
                            text.append("\nParent Tree:\n");
                            Composite[] parents = new Composite[]{};
                            while (parent != null) {
                                Composite[] newParents = new Composite[parents.length + 1];
                                System.arraycopy(parents, 0, newParents, 0, parents.length);
                                newParents[parents.length] = parent;
                                parents = newParents;
                                parent = parent.getParent();
                            }
                            int i2 = parents.length - 1;
                            while (i2 >= 0) {
                                String prefix = "\t";
                                int j = 0;
                                while (j < parents.length - i2 - 1) {
                                    prefix = String.valueOf(prefix) + "\t";
                                    ++j;
                                }
                                text.append(String.valueOf(prefix) + parents[i2] + "@" + SpyView.this.getOSHandle((Control)parents[i2]) + "\n");
                                text.append(String.valueOf(prefix) + "\t Style: " + SpyView.this.getStyle((Widget)parents[i2]) + "\n");
                                text.append(String.valueOf(prefix) + "\t Bounds: " + parents[i2].getBounds() + "\n");
                                text.append(String.valueOf(prefix) + "\t Layout: " + parents[i2].getLayout() + "\n");
                                text.append(String.valueOf(prefix) + "\t LayoutData: " + parents[i2].getLayoutData() + "\n");
                                --i2;
                            }
                        }
                        if ((error = (Error)control.getData("StackTrace")) != null) {
                            text.append("\nCreation Stack Trace:\n");
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            PrintStream s = new PrintStream(stream);
                            error.printStackTrace(s);
                            text.append(stream.toString());
                        }
                    }
                    SpyView.this.output.setText(text.toString());
                }
                SpyView.this.lastControl = control;
                display.timerExec(100, (Runnable)this);
            }
        };
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        if (this.output != null & !this.output.isDisposed()) {
            this.output.setFocus();
        }
    }

    private String getOSHandle(Control control) {
        if (this.field == null) {
            String[] fieldNames = new String[]{"handle", "view"};
            int i = 0;
            while (i < fieldNames.length) {
                try {
                    this.field = control.getClass().getField(fieldNames[i]);
                    if (this.field != null) {
                        break;
                    }
                }
                catch (Throwable throwable) {}
                ++i;
            }
        }
        try {
            return this.field.get(control).toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void dispose() {
        Display.getCurrent().removeFilter(1, this.keyFilter);
        super.dispose();
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.spyAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.spyAction);
    }

    private void makeActions() {
        this.spyAction = new Action(){

            public void run() {
                Display.getCurrent().timerExec(100, SpyView.this.timer);
            }
        };
        this.spyAction.setText("Spy");
        this.spyAction.setToolTipText("Toggle Spy (CONTROL+ALT+SHIFT+.)");
        this.spyAction.setImageDescriptor(Activator.getImageDescriptor("icons/spy.gif"));
        this.spyAction.setChecked(false);
    }

    private String getStyle(Widget w) {
        int lastOr;
        int style = w.getStyle();
        String result = "";
        if (style == -1) {
            return "DEFAULT - bad!";
        }
        if ((style & 2) != 0) {
            result = w instanceof CTabFolder || w instanceof StyledText || w instanceof List || w instanceof Text || w instanceof Table || w instanceof Tree ? String.valueOf(result) + "MULTI | " : (w instanceof Menu ? String.valueOf(result) + "BAR | " : (w instanceof Label || w instanceof MenuItem || w instanceof ToolItem ? String.valueOf(result) + "SEPARATOR | " : (w instanceof Button ? String.valueOf(result) + "TOGGLE | " : (w instanceof ProgressBar ? String.valueOf(result) + "INDETERMINATE | " : String.valueOf(result) + "BAR or SEPARATOR or TOGGLE or MULTI or INDETERMINATE or DBCS | "))));
        }
        if ((style & 4) != 0) {
            result = w instanceof Menu || w instanceof ToolItem || w instanceof CoolItem || w instanceof Combo ? String.valueOf(result) + "DROP_DOWN | " : (w instanceof Button ? String.valueOf(result) + "ARROW | " : (w instanceof CTabFolder || w instanceof StyledText || w instanceof List || w instanceof Text || w instanceof Table || w instanceof Tree ? String.valueOf(result) + "SINGLE | " : (w instanceof Label || w instanceof Group ? String.valueOf(result) + "SHADOW_IN | " : (w instanceof Decorations ? String.valueOf(result) + "TOOL | " : String.valueOf(result) + "ALPHA or TOOL or SINGLE or ARROW or DROP_DOWN or SHADOW_IN | "))));
        }
        if ((style & 8) != 0) {
            result = w instanceof Menu ? String.valueOf(result) + "POP_UP | " : (w instanceof Button || w instanceof MenuItem || w instanceof ToolItem ? String.valueOf(result) + "PUSH | " : (w instanceof Combo || w instanceof Text || w instanceof StyledText ? String.valueOf(result) + "READ_ONLY | " : (w instanceof Label || w instanceof Group || w instanceof ToolBar ? String.valueOf(result) + "SHADOW_OUT | " : (w instanceof Decorations ? String.valueOf(result) + "NO_TRIM | " : String.valueOf(result) + "POP_UP or PUSH or READ_ONLY or SHADOW_OUT or NO_TRIM or NATIVE | "))));
        }
        if ((style & 0x10) != 0) {
            result = w instanceof Button || w instanceof MenuItem || w instanceof ToolItem ? String.valueOf(result) + "RADIO | " : (w instanceof Group ? String.valueOf(result) + "SHADOW_ETCHED_IN | " : (w instanceof Decorations || w instanceof Tracker ? String.valueOf(result) + "RESIZE | " : String.valueOf(result) + "RESIZE or SHADOW_ETCHED_IN or RADIO or PHONETIC | "));
        }
        if ((style & 0x20) != 0) {
            result = w instanceof Button || w instanceof MenuItem || w instanceof ToolItem || w instanceof Table || w instanceof Tree ? String.valueOf(result) + "CHECK | " : (w instanceof Label || w instanceof Group ? String.valueOf(result) + "SHADOW_NONE | " : (w instanceof Decorations ? String.valueOf(result) + "TITLE | " : (w instanceof DateTime ? String.valueOf(result) + "DATE | " : String.valueOf(result) + "ROMAN or CHECK  or SHADOW_NONE or TITLE | ")));
        }
        if ((style & 0x40) != 0) {
            result = w instanceof MenuItem ? String.valueOf(result) + "CASCADE | " : (w instanceof StyledText || w instanceof Label || w instanceof Text || w instanceof ToolBar ? String.valueOf(result) + "WRAP | " : (w instanceof Combo ? String.valueOf(result) + "SIMPLE | " : (w instanceof Group ? String.valueOf(result) + "SHADOW_ETCHED_OUT | " : (w instanceof Decorations || w instanceof CTabFolder || w instanceof CTabItem ? String.valueOf(result) + "CLOSE | " : String.valueOf(result) + "CLOSE or MENU or CASCADE or WRAP or SIMPLE or SHADOW_ETCHED_OUT | "))));
        }
        if ((style & 0x80) != 0) {
            result = w instanceof Decorations ? String.valueOf(result) + "MIN | " : (w instanceof Button || w instanceof Tracker ? String.valueOf(result) + "UP | " : (w instanceof CTabFolder ? String.valueOf(result) + "TOP | " : (w instanceof DateTime ? String.valueOf(result) + "TIME | " : String.valueOf(result) + "MIN or UP or TOP | ")));
        }
        if ((style & 0x100) != 0) {
            result = String.valueOf(result) + "HORIZONTAL | ";
        }
        if ((style & 0x200) != 0) {
            result = String.valueOf(result) + "VERTICAL | ";
        }
        if ((style & 0x400) != 0) {
            result = w instanceof Decorations ? String.valueOf(result) + "MAX | " : (w instanceof Button || w instanceof Tracker ? String.valueOf(result) + "DOWN | " : (w instanceof CTabFolder ? String.valueOf(result) + "BOTTOM | " : (w instanceof DateTime ? String.valueOf(result) + "CALENDAR | " : String.valueOf(result) + "MAX or DOWN or BOTTOM | ")));
        }
        if ((style & 0x800) != 0) {
            result = String.valueOf(result) + "BORDER | ";
        }
        if ((style & 0x1000) != 0) {
            result = w instanceof ToolTip ? String.valueOf(result) + "BALLOON | " : String.valueOf(result) + "CLIP_CHILDREN | ";
        }
        if ((style & 0x2000) != 0) {
            result = String.valueOf(result) + "CLIP_SIBLINGS | ";
        }
        if ((style & 0x4000) != 0) {
            result = String.valueOf(result) + "ON_TOP or LEAD or LEFT | ";
        }
        if ((style & 0x8000) != 0) {
            result = w instanceof Shell ? String.valueOf(result) + "PRIMARY_MODAL | " : (w instanceof Table || w instanceof Tree ? String.valueOf(result) + "HIDE_SELECTION | " : (w instanceof DateTime ? String.valueOf(result) + "SHORT | " : String.valueOf(result) + "PRIMARY_MODAL or HIDE_SELECTION | "));
        }
        if ((style & 0x10000) != 0) {
            result = w instanceof StyledText || w instanceof Table || w instanceof Tree ? String.valueOf(result) + "FULL_SELECTION | " : (w instanceof Shell ? String.valueOf(result) + "APPLICATION_MODAL | " : (w instanceof ProgressBar ? String.valueOf(result) + "SMOOTH | " : (w instanceof DateTime ? String.valueOf(result) + "MEDIUM | " : String.valueOf(result) + "FULL_SELECTION or SMOOTH or APPLICATION_MODAL | ")));
        }
        if ((style & 0x20000) != 0) {
            result = w instanceof Shell ? String.valueOf(result) + "SYSTEM_MODAL | " : (w instanceof Button || w instanceof Label || w instanceof TableColumn || w instanceof Tracker || w instanceof ToolBar ? String.valueOf(result) + "TRAIL | " : String.valueOf(result) + "SYSTEM_MODAL or TRAIL or RIGHT | ");
        }
        if ((style & 0x40000) != 0) {
            result = String.valueOf(result) + "NO_BACKGROUND | ";
        }
        if ((style & 0x80000) != 0) {
            result = String.valueOf(result) + "NO_FOCUS | ";
        }
        if ((style & 0x100000) != 0) {
            result = String.valueOf(result) + "NO_REDRAW_RESIZE | ";
        }
        if ((style & 0x200000) != 0) {
            result = String.valueOf(result) + "NO_MERGE_PAINTS | ";
        }
        if ((style & 0x400000) != 0) {
            result = w instanceof Text ? String.valueOf(result) + "PASSWORD | " : (w instanceof Composite ? String.valueOf(result) + "NO_RADIO_GROUP | " : String.valueOf(result) + "NO_RADIO_GROUP or PASSWORD | ");
        }
        if ((style & 0x800000) != 0) {
            result = String.valueOf(result) + "FLAT | ";
        }
        if ((style & 0x1000000) != 0) {
            result = w instanceof Button || w instanceof Label || w instanceof TableColumn ? String.valueOf(result) + "CENTER | " : String.valueOf(result) + "EMBEDDED or CENTER | ";
        }
        if ((style & 0x2000000) != 0) {
            result = String.valueOf(result) + "LEFT_TO_RIGHT | ";
        }
        if ((style & 0x4000000) != 0) {
            result = String.valueOf(result) + "RIGHT_TO_LEFT | ";
        }
        if ((style & 0x8000000) != 0) {
            result = String.valueOf(result) + "MIRRORED | ";
        }
        if ((style & 0x10000000) != 0) {
            result = w instanceof DateTime ? String.valueOf(result) + "LONG | " : String.valueOf(result) + "VIRTUAL | ";
        }
        if ((style & 0x20000000) != 0) {
            result = String.valueOf(result) + "DOUBLE_BUFFERED | ";
        }
        if ((lastOr = result.lastIndexOf("|")) == result.length() - 2) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }
}

