/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeButtonDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ExpanderDrawData
extends DrawData {
    public ExpanderDrawData() {
        this.state = new int[1];
    }

    HIThemeButtonDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeButtonDrawInfo info = new HIThemeButtonDrawInfo();
        info.version = 0;
        info.kind = 6;
        info.value = (this.style & 0x400) != 0 ? 1 : 0;
        info.state = (state & 8) != 0 ? 2 : ((state & 0x10) != 0 ? ((state & 0x20) == 0 ? 1 : 7) : ((state & 0x20) == 0 ? 0 : 8));
        return info;
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeButtonDrawInfo info = this.getInfo();
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        CGRect backRect = new CGRect();
        OS.HIThemeGetButtonBackgroundBounds(rect, info, backRect);
        rect.x += rect.x - backRect.x;
        rect.y += rect.y - backRect.y;
        int[] metric = new int[1];
        OS.GetThemeMetric(26, metric);
        rect.width = metric[0];
        OS.GetThemeMetric(25, metric);
        rect.height = metric[0];
        OS.HIThemeDrawButton(rect, info, gc.handle, 0, null);
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        int[] metric = new int[1];
        OS.GetThemeMetric(26, metric);
        int width = metric[0];
        OS.GetThemeMetric(25, metric);
        int height = metric[0];
        if (new Rectangle(bounds.x, bounds.y, width, height).contains(position)) {
            return 0;
        }
        return -1;
    }
}

