/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeContainer;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;

public abstract class AbstractApiComponent
extends AbstractApiTypeContainer
implements IApiComponent {
    private IApiDescription fApiDescription = null;
    private IApiFilterStore fFilterStore = null;

    public AbstractApiComponent(IApiBaseline baseline) {
        super(baseline, 1, null);
    }

    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            super.accept(visitor);
        }
        visitor.end(this);
    }

    public IApiComponent getHost() throws CoreException {
        return null;
    }

    public IApiBaseline getBaseline() {
        return (IApiBaseline)this.getAncestor(4);
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        this.fApiDescription = null;
    }

    public IApiComponent getApiComponent() {
        return this;
    }

    public synchronized IApiDescription getApiDescription() throws CoreException {
        if (this.fApiDescription == null) {
            this.fApiDescription = this.createApiDescription();
        }
        return this.fApiDescription;
    }

    protected synchronized boolean isApiDescriptionInitialized() {
        return this.fApiDescription != null;
    }

    protected synchronized boolean hasApiFilterStore() {
        return this.fFilterStore != null;
    }

    public synchronized IApiTypeContainer[] getApiTypeContainers() throws CoreException {
        return super.getApiTypeContainers();
    }

    public synchronized IApiTypeContainer[] getApiTypeContainers(String id) throws CoreException {
        if (this.hasFragments()) {
            return super.getApiTypeContainers(id);
        }
        return super.getApiTypeContainers();
    }

    protected abstract IApiDescription createApiDescription() throws CoreException;

    public IApiFilterStore getFilterStore() throws CoreException {
        if (this.fFilterStore == null) {
            this.fFilterStore = this.createApiFilterStore();
        }
        return this.fFilterStore;
    }

    public IApiProblemFilter newProblemFilter(IApiProblem problem) throws CoreException {
        return new ApiProblemFilter(this.getId(), problem);
    }

    public IElementDescriptor getHandle() throws CoreException {
        return Factory.componentDescriptor(this.getId());
    }

    protected abstract IApiFilterStore createApiFilterStore() throws CoreException;
}

