/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int MOVED = 128;
    static final int RESIZED = 256;
    static final int ZERO_WIDTH = 512;
    static final int ZERO_HEIGHT = 1024;
    static final int HIDDEN = 2048;
    static final int FOREGROUND = 4096;
    static final int BACKGROUND = 8192;
    static final int FONT = 16384;
    static final int PARENT_BACKGROUND = 32768;
    static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_PRESS_EVENT_INVERSE = 3;
    static final int BUTTON_RELEASE_EVENT = 4;
    static final int BUTTON_RELEASE_EVENT_INVERSE = 5;
    static final int CHANGED = 6;
    static final int CHANGE_VALUE = 7;
    static final int CLICKED = 8;
    static final int COMMIT = 9;
    static final int CONFIGURE_EVENT = 10;
    static final int DELETE_EVENT = 11;
    static final int DELETE_RANGE = 12;
    static final int DELETE_TEXT = 13;
    static final int ENTER_NOTIFY_EVENT = 14;
    static final int EVENT = 15;
    static final int EVENT_AFTER = 16;
    static final int EXPAND_COLLAPSE_CURSOR_ROW = 17;
    static final int EXPOSE_EVENT = 18;
    static final int EXPOSE_EVENT_INVERSE = 19;
    static final int FOCUS = 20;
    static final int FOCUS_IN_EVENT = 21;
    static final int FOCUS_OUT_EVENT = 22;
    static final int GRAB_FOCUS = 23;
    static final int HIDE = 24;
    static final int INPUT = 25;
    static final int INSERT_TEXT = 26;
    static final int KEY_PRESS_EVENT = 27;
    static final int KEY_RELEASE_EVENT = 28;
    static final int LEAVE_NOTIFY_EVENT = 29;
    static final int MAP = 30;
    static final int MAP_EVENT = 31;
    static final int MNEMONIC_ACTIVATE = 32;
    static final int MOTION_NOTIFY_EVENT = 33;
    static final int MOTION_NOTIFY_EVENT_INVERSE = 34;
    static final int MOVE_FOCUS = 35;
    static final int OUTPUT = 36;
    static final int POPULATE_POPUP = 37;
    static final int POPUP_MENU = 38;
    static final int PREEDIT_CHANGED = 39;
    static final int REALIZE = 40;
    static final int ROW_ACTIVATED = 41;
    static final int SCROLL_CHILD = 42;
    static final int SCROLL_EVENT = 43;
    static final int SELECT = 44;
    static final int SHOW = 45;
    static final int SHOW_HELP = 46;
    static final int SIZE_ALLOCATE = 47;
    static final int STYLE_SET = 48;
    static final int SWITCH_PAGE = 49;
    static final int TEST_COLLAPSE_ROW = 50;
    static final int TEST_EXPAND_ROW = 51;
    static final int TEXT_BUFFER_INSERT_TEXT = 52;
    static final int TOGGLED = 53;
    static final int UNMAP = 54;
    static final int UNMAP_EVENT = 55;
    static final int UNREALIZE = 56;
    static final int VALUE_CHANGED = 57;
    static final int VISIBILITY_NOTIFY_EVENT = 58;
    static final int WINDOW_STATE_EVENT = 59;
    static final int ACTIVATE_INVERSE = 60;
    static final int DAY_SELECTED = 61;
    static final int MONTH_CHANGED = 62;
    static final int STATUS_ICON_POPUP_MENU = 63;
    static final int ROW_INSERTED = 64;
    static final int ROW_DELETED = 65;
    static final int DAY_SELECTED_DOUBLE_CLICK = 66;
    static final int LAST_SIGNAL = 67;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    int paintWindow() {
        return 0;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    int cellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        return 0;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            this.style &= 0xFBFFFFFF;
            this.style |= 0x2000000;
        }
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int index) {
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.setOrientation();
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        int topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0 && (this.state & 8) != 0) {
            OS.gtk_widget_destroy(topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int code) {
        SWT.error(code);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.length();
        while (--index > 0 && string.charAt(index) != '.') {
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    int gtk_activate(int widget) {
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        return 0;
    }

    int gtk_button_release_event(int widget, int event) {
        return 0;
    }

    int gtk_changed(int widget) {
        return 0;
    }

    int gtk_change_value(int widget, int scroll, int value1, int value2) {
        return 0;
    }

    int gtk_clicked(int widget) {
        return 0;
    }

    int gtk_commit(int imcontext, int text) {
        return 0;
    }

    int gtk_configure_event(int widget, int event) {
        return 0;
    }

    int gtk_day_selected(int widget) {
        return 0;
    }

    int gtk_day_selected_double_click(int widget) {
        return 0;
    }

    int gtk_delete_event(int widget, int event) {
        return 0;
    }

    int gtk_delete_range(int widget, int iter1, int iter2) {
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        return 0;
    }

    int gtk_enter_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_event(int widget, int event) {
        return 0;
    }

    int gtk_event_after(int widget, int event) {
        return 0;
    }

    int gtk_expand_collapse_cursor_row(int widget, int logical, int expand, int open_all) {
        return 0;
    }

    int gtk_expose_event(int widget, int event) {
        return 0;
    }

    int gtk_focus(int widget, int event) {
        return 0;
    }

    int gtk_focus_in_event(int widget, int event) {
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        return 0;
    }

    int gtk_grab_focus(int widget) {
        return 0;
    }

    int gtk_hide(int widget) {
        return 0;
    }

    int gtk_input(int widget, int arg1) {
        return 0;
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, GdkEventKey.sizeof);
        return this.sendKeyEvent(1, gdkEvent) ? 0 : 1;
    }

    int gtk_key_release_event(int widget, int event) {
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, GdkEventKey.sizeof);
        return this.sendKeyEvent(2, gdkEvent) ? 0 : 1;
    }

    int gtk_leave_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_map(int widget) {
        return 0;
    }

    int gtk_map_event(int widget, int event) {
        return 0;
    }

    int gtk_mnemonic_activate(int widget, int arg1) {
        return 0;
    }

    int gtk_month_changed(int widget) {
        return 0;
    }

    int gtk_motion_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_move_focus(int widget, int event) {
        return 0;
    }

    int gtk_output(int widget) {
        return 0;
    }

    int gtk_populate_popup(int widget, int menu) {
        return 0;
    }

    int gtk_popup_menu(int widget) {
        return 0;
    }

    int gtk_preedit_changed(int imcontext) {
        return 0;
    }

    int gtk_realize(int widget) {
        return 0;
    }

    int gtk_row_activated(int tree, int path, int column) {
        return 0;
    }

    int gtk_row_deleted(int model, int path) {
        return 0;
    }

    int gtk_row_inserted(int model, int path, int iter) {
        return 0;
    }

    int gtk_scroll_child(int widget, int scrollType, int horizontal) {
        return 0;
    }

    int gtk_scroll_event(int widget, int event) {
        return 0;
    }

    int gtk_select(int item) {
        return 0;
    }

    int gtk_show(int widget) {
        return 0;
    }

    int gtk_show_help(int widget, int helpType) {
        return 0;
    }

    int gtk_size_allocate(int widget, int allocation) {
        return 0;
    }

    int gtk_status_icon_popup_menu(int handle, int button, int activate_time) {
        return 0;
    }

    int gtk_style_set(int widget, int previousStyle) {
        return 0;
    }

    int gtk_switch_page(int widget, int page, int page_num) {
        return 0;
    }

    int gtk_test_collapse_row(int tree, int iter, int path) {
        return 0;
    }

    int gtk_test_expand_row(int tree, int iter, int path) {
        return 0;
    }

    int gtk_text_buffer_insert_text(int widget, int iter, int text, int length) {
        return 0;
    }

    int gtk_timer() {
        return 0;
    }

    int gtk_toggled(int renderer, int pathStr) {
        return 0;
    }

    int gtk_unmap(int widget) {
        return 0;
    }

    int gtk_unmap_event(int widget, int event) {
        return 0;
    }

    int gtk_unrealize(int widget) {
        return 0;
    }

    int gtk_value_changed(int adjustment) {
        return 0;
    }

    int gtk_visibility_notify_event(int widget, int event) {
        return 0;
    }

    int gtk_window_state_event(int widget, int event) {
        return 0;
    }

    int fontHeight(int font, int widgetHandle) {
        int context = OS.gtk_widget_get_pango_context(widgetHandle);
        int lang = OS.pango_context_get_language(context);
        int metrics = OS.pango_context_get_metrics(context, font, lang);
        int ascent = OS.pango_font_metrics_get_ascent(metrics);
        int descent = OS.pango_font_metrics_get_descent(metrics);
        OS.pango_font_metrics_unref(metrics);
        return OS.PANGO_PIXELS(ascent + descent);
    }

    int filterProc(int xEvent, int gdkEvent, int data2) {
        return 0;
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    int fixedMapProc(int widget) {
        return 0;
    }

    int fixedSizeAllocateProc(int widget, int allocationPtr) {
        return OS.Call(Display.oldFixedSizeAllocateProc, widget, allocationPtr);
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, true);
    }

    char[] fixMnemonic(String string, boolean replace) {
        int length = string.length();
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        int i = 0;
        int j = 0;
        char[] result = new char[length * 2];
        while (i < length) {
            switch (text[i]) {
                case '&': {
                    if (i + 1 < length && text[i + 1] == '&') {
                        result[j++] = text[i++];
                    } else if (replace) {
                        result[j++] = 95;
                    }
                    ++i;
                    break;
                }
                case '_': {
                    if (replace) {
                        result[j++] = 95;
                    }
                }
                default: {
                    result[j++] = text[i++];
                }
            }
        }
        return result;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    int hoverProc(int widget) {
        return 0;
    }

    int menuPositionProc(int menu, int x, int y, int push_in, int user_data) {
        return 0;
    }

    boolean mnemonicHit(int mnemonicHandle, char key) {
        if (!this.mnemonicMatch(mnemonicHandle, key)) {
            return false;
        }
        OS.g_signal_handlers_block_matched(mnemonicHandle, 16, 0, 0, 0, 0, 32);
        boolean result = OS.gtk_widget_mnemonic_activate(mnemonicHandle, false);
        OS.g_signal_handlers_unblock_matched(mnemonicHandle, 16, 0, 0, 0, 0, 32);
        return result;
    }

    boolean mnemonicMatch(int mnemonicHandle, char key) {
        int keyval2;
        int keyval1 = OS.gdk_keyval_to_lower(OS.gdk_unicode_to_keyval(key));
        return keyval1 == (keyval2 = OS.gdk_keyval_to_lower(OS.gtk_label_get_mnemonic_keyval(mnemonicHandle)));
    }

    void modifyStyle(int handle, int style) {
        OS.gtk_widget_modify_style(handle, style);
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean destroy) {
        if ((this.state & 0x200000) == 0) {
            this.state |= 0x200000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x100000) == 0) {
            this.state |= 0x100000;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    int rendererGetSizeProc(int cell, int handle, int cell_area, int x_offset, int y_offset, int width, int height) {
        return 0;
    }

    int rendererRenderProc(int cell, int window, int handle, int background_area, int cell_area, int expose_area, int flags) {
        return 0;
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int type, GdkEventKey keyEvent) {
        int length = keyEvent.length;
        if (keyEvent.string == 0 || OS.g_utf8_strlen(keyEvent.string, length) <= 1) {
            Event event = new Event();
            event.time = keyEvent.time;
            if (!this.setKeyState(event, keyEvent)) {
                return true;
            }
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
            return event.doit;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, keyEvent.string, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        return this.sendIMKeyEvent(type, keyEvent, chars) != null;
    }

    char[] sendIMKeyEvent(int type, GdkEventKey keyEvent, char[] chars) {
        int index = 0;
        int count = 0;
        int state = 0;
        int ptr = 0;
        if (keyEvent == null && (ptr = OS.gtk_get_current_event()) != 0) {
            keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, ptr, GdkEventKey.sizeof);
            switch (keyEvent.type) {
                case 8: 
                case 9: {
                    state = keyEvent.state;
                    break;
                }
                default: {
                    keyEvent = null;
                }
            }
        }
        if (keyEvent == null) {
            int[] buffer = new int[1];
            OS.gtk_get_current_event_state(buffer);
            state = buffer[0];
        }
        while (index < chars.length) {
            Event event = new Event();
            if (keyEvent != null && chars.length <= 1) {
                this.setKeyState(event, keyEvent);
            } else {
                this.setInputState(event, state);
            }
            event.character = chars[index];
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                if (ptr != 0) {
                    OS.gdk_event_free(ptr);
                }
                return null;
            }
            if (event.doit) {
                chars[count++] = chars[index];
            }
            ++index;
        }
        if (ptr != 0) {
            OS.gdk_event_free(ptr);
        }
        if (count == 0) {
            return null;
        }
        if (index != count) {
            char[] result = new char[count];
            System.arraycopy(chars, 0, result, 0, count);
            return result;
        }
        return chars;
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }

    void setForegroundColor(int handle, GdkColor color) {
        int style = OS.gtk_widget_get_modifier_style(handle);
        OS.gtk_rc_style_set_fg(style, 0, color);
        OS.gtk_rc_style_set_fg(style, 1, color);
        OS.gtk_rc_style_set_fg(style, 2, color);
        int flags = OS.gtk_rc_style_get_color_flags(style, 0);
        flags = color == null ? flags & 0xFFFFFFFE : flags | 1;
        OS.gtk_rc_style_set_color_flags(style, 0, flags);
        flags = OS.gtk_rc_style_get_color_flags(style, 1);
        flags = color == null ? flags & 0xFFFFFFFE : flags | 1;
        OS.gtk_rc_style_set_color_flags(style, 1, flags);
        flags = OS.gtk_rc_style_get_color_flags(style, 2);
        flags = color == null ? flags & 0xFFFFFFFE : flags | 1;
        OS.gtk_rc_style_set_color_flags(style, 2, flags);
        OS.gtk_rc_style_set_text(style, 0, color);
        OS.gtk_rc_style_set_text(style, 1, color);
        OS.gtk_rc_style_set_text(style, 2, color);
        flags = OS.gtk_rc_style_get_color_flags(style, 0);
        flags = color == null ? flags & 0xFFFFFFFB : flags | 4;
        OS.gtk_rc_style_set_color_flags(style, 0, flags);
        flags = OS.gtk_rc_style_get_color_flags(style, 2);
        flags = color == null ? flags & 0xFFFFFFFB : flags | 4;
        OS.gtk_rc_style_set_color_flags(style, 2, flags);
        flags = OS.gtk_rc_style_get_color_flags(style, 1);
        flags = color == null ? flags & 0xFFFFFFFB : flags | 4;
        OS.gtk_rc_style_set_color_flags(style, 1, flags);
        this.modifyStyle(handle, style);
    }

    boolean setInputState(Event event, int state) {
        if ((state & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((state & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((state & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, GdkEventKey keyEvent) {
        if (keyEvent.string != 0 && OS.g_utf8_strlen(keyEvent.string, keyEvent.length) > 1) {
            return false;
        }
        boolean isNull = false;
        event.keyCode = Display.translateKey(keyEvent.keyval);
        switch (keyEvent.keyval) {
            case 65288: {
                event.character = (char)8;
                break;
            }
            case 65290: {
                event.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                event.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                event.character = (char)127;
                break;
            }
            case 65307: {
                event.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                event.character = (char)9;
                break;
            }
            default: {
                if (event.keyCode == 0) {
                    int[] keyval = new int[1];
                    int[] effective_group = new int[1];
                    int[] level = new int[1];
                    int[] consumed_modifiers = new int[1];
                    if (OS.gdk_keymap_translate_keyboard_state(OS.gdk_keymap_get_default(), keyEvent.hardware_keycode, 0, keyEvent.group, keyval, effective_group, level, consumed_modifiers)) {
                        event.keyCode = OS.gdk_keyval_to_unicode(keyval[0]);
                    }
                }
                int key = keyEvent.keyval;
                if ((keyEvent.state & 4) != 0 && key >= 0 && key <= 127) {
                    if (97 <= key && key <= 122) {
                        key -= 32;
                    }
                    if (64 <= key && key <= 95) {
                        key -= 64;
                    }
                    event.character = (char)key;
                    isNull = keyEvent.keyval == 64 && key == 0;
                    break;
                }
                event.character = (char)OS.gdk_keyval_to_unicode(key);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        return this.setInputState(event, keyEvent.state);
    }

    void setOrientation() {
    }

    boolean setTabGroupFocus(boolean next) {
        return this.setTabItemFocus(next);
    }

    boolean setTabItemFocus(boolean next) {
        return false;
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        return 0;
    }

    int sizeAllocateProc(int handle, int arg0, int user_data) {
        return 0;
    }

    int sizeRequestProc(int handle, int arg0, int user_data) {
        return 0;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int topHandle() {
        return this.handle;
    }

    int timerProc(int widget) {
        return 0;
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        return 0;
    }

    boolean translateTraversal(int event) {
        return false;
    }

    int windowProc(int handle, int user_data) {
        switch (user_data) {
            case 1: {
                return this.gtk_activate(handle);
            }
            case 6: {
                return this.gtk_changed(handle);
            }
            case 8: {
                return this.gtk_clicked(handle);
            }
            case 61: {
                return this.gtk_day_selected(handle);
            }
            case 66: {
                return this.gtk_day_selected_double_click(handle);
            }
            case 24: {
                return this.gtk_hide(handle);
            }
            case 23: {
                return this.gtk_grab_focus(handle);
            }
            case 30: {
                return this.gtk_map(handle);
            }
            case 62: {
                return this.gtk_month_changed(handle);
            }
            case 36: {
                return this.gtk_output(handle);
            }
            case 38: {
                return this.gtk_popup_menu(handle);
            }
            case 39: {
                return this.gtk_preedit_changed(handle);
            }
            case 40: {
                return this.gtk_realize(handle);
            }
            case 44: {
                return this.gtk_select(handle);
            }
            case 45: {
                return this.gtk_show(handle);
            }
            case 57: {
                return this.gtk_value_changed(handle);
            }
            case 54: {
                return this.gtk_unmap(handle);
            }
            case 56: {
                return this.gtk_unrealize(handle);
            }
        }
        return 0;
    }

    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 19: {
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, GdkEventExpose.sizeof);
                int paintWindow = this.paintWindow();
                int window = gdkEvent.window;
                if (window != paintWindow) {
                    return 0;
                }
                return (this.state & 0x40) != 0 ? 1 : 0;
            }
            case 3: 
            case 5: 
            case 34: {
                return 1;
            }
            case 2: {
                return this.gtk_button_press_event(handle, arg0);
            }
            case 4: {
                return this.gtk_button_release_event(handle, arg0);
            }
            case 9: {
                return this.gtk_commit(handle, arg0);
            }
            case 10: {
                return this.gtk_configure_event(handle, arg0);
            }
            case 11: {
                return this.gtk_delete_event(handle, arg0);
            }
            case 14: {
                return this.gtk_enter_notify_event(handle, arg0);
            }
            case 15: {
                return this.gtk_event(handle, arg0);
            }
            case 16: {
                return this.gtk_event_after(handle, arg0);
            }
            case 18: {
                return this.gtk_expose_event(handle, arg0);
            }
            case 20: {
                return this.gtk_focus(handle, arg0);
            }
            case 21: {
                return this.gtk_focus_in_event(handle, arg0);
            }
            case 22: {
                return this.gtk_focus_out_event(handle, arg0);
            }
            case 27: {
                return this.gtk_key_press_event(handle, arg0);
            }
            case 28: {
                return this.gtk_key_release_event(handle, arg0);
            }
            case 25: {
                return this.gtk_input(handle, arg0);
            }
            case 29: {
                return this.gtk_leave_notify_event(handle, arg0);
            }
            case 31: {
                return this.gtk_map_event(handle, arg0);
            }
            case 32: {
                return this.gtk_mnemonic_activate(handle, arg0);
            }
            case 33: {
                return this.gtk_motion_notify_event(handle, arg0);
            }
            case 35: {
                return this.gtk_move_focus(handle, arg0);
            }
            case 37: {
                return this.gtk_populate_popup(handle, arg0);
            }
            case 43: {
                return this.gtk_scroll_event(handle, arg0);
            }
            case 46: {
                return this.gtk_show_help(handle, arg0);
            }
            case 47: {
                return this.gtk_size_allocate(handle, arg0);
            }
            case 48: {
                return this.gtk_style_set(handle, arg0);
            }
            case 53: {
                return this.gtk_toggled(handle, arg0);
            }
            case 55: {
                return this.gtk_unmap_event(handle, arg0);
            }
            case 58: {
                return this.gtk_visibility_notify_event(handle, arg0);
            }
            case 59: {
                return this.gtk_window_state_event(handle, arg0);
            }
            case 65: {
                return this.gtk_row_deleted(handle, arg0);
            }
        }
        return 0;
    }

    int windowProc(int handle, int arg0, int arg1, int user_data) {
        switch (user_data) {
            case 12: {
                return this.gtk_delete_range(handle, arg0, arg1);
            }
            case 13: {
                return this.gtk_delete_text(handle, arg0, arg1);
            }
            case 41: {
                return this.gtk_row_activated(handle, arg0, arg1);
            }
            case 42: {
                return this.gtk_scroll_child(handle, arg0, arg1);
            }
            case 63: {
                return this.gtk_status_icon_popup_menu(handle, arg0, arg1);
            }
            case 49: {
                return this.gtk_switch_page(handle, arg0, arg1);
            }
            case 50: {
                return this.gtk_test_collapse_row(handle, arg0, arg1);
            }
            case 51: {
                return this.gtk_test_expand_row(handle, arg0, arg1);
            }
            case 64: {
                return this.gtk_row_inserted(handle, arg0, arg1);
            }
        }
        return 0;
    }

    int windowProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        switch (user_data) {
            case 7: {
                return this.gtk_change_value(handle, arg0, arg1, arg2);
            }
            case 17: {
                return this.gtk_expand_collapse_cursor_row(handle, arg0, arg1, arg2);
            }
            case 26: {
                return this.gtk_insert_text(handle, arg0, arg1, arg2);
            }
            case 52: {
                return this.gtk_text_buffer_insert_text(handle, arg0, arg1, arg2);
            }
        }
        return 0;
    }
}

