/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tools;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class MetadataCompareApplication
implements IApplication {
    private MetadataRepositoryManager repoManager = new MetadataRepositoryManager();
    private IMetadataRepository sourceRepo = null;
    private IMetadataRepository targetRepo = null;
    private static Comparator iuIdComparator = new Comparator(){

        public int compare(Object source, Object target) {
            IInstallableUnit sourceIU = (IInstallableUnit)source;
            IInstallableUnit targetIU = (IInstallableUnit)target;
            int id = sourceIU.getId().compareTo(targetIU.getId());
            if (id != 0) {
                return id;
            }
            return sourceIU.getVersion().compareTo((Object)targetIU.getVersion());
        }
    };
    private URI sourceLocation;
    private URI targetLocation;
    private boolean compare = false;
    private boolean list = false;
    static /* synthetic */ Class class$0;

    public Object start(IApplicationContext context) throws Exception {
        this.initializeFromArguments((String[])context.getArguments().get("application.args"));
        this.initRepositories();
        if (this.compare) {
            this.compareMetadataRepositories();
        } else if (this.list) {
            this.list(this.sourceLocation);
            this.list(this.targetLocation);
        }
        return IApplication.EXIT_OK;
    }

    private void list(URI location) throws ProvisionException {
        if (location == null) {
            return;
        }
        IMetadataRepository locationRepo = this.repoManager.getRepository(location);
        if (locationRepo == null) {
            return;
        }
        Collector sourceRoots = locationRepo.query((Query)InstallableUnitQuery.ANY, new Collector(), (IProgressMonitor)new NullProgressMonitor());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit[] sourceIUs = (IInstallableUnit[])sourceRoots.toArray((Class)clazz);
        sourceIUs = this.sort(sourceIUs, true);
        int i = 0;
        while (i < sourceIUs.length) {
            System.out.print(sourceIUs[i]);
            System.out.println(sourceIUs[i].isFragment() ? " (fragment)" : "");
            ++i;
        }
        System.out.println("Total: " + sourceIUs.length);
    }

    private void compareMetadataRepositories() throws ProvisionException {
        System.out.println("\n" + this.sourceLocation + " -> " + this.targetLocation);
        this.compare(this.sourceRepo, this.targetRepo);
    }

    private void initRepositories() throws ProvisionException {
        if (this.targetLocation == null || this.sourceLocation == null) {
            throw new IllegalStateException("Must specify a source and target");
        }
        this.sourceRepo = this.repoManager.loadRepository(this.sourceLocation, null);
        this.targetRepo = this.initializeTarget();
    }

    private IMetadataRepository initializeTarget() throws ProvisionException {
        try {
            IMetadataRepository repository = this.repoManager.loadRepository(this.targetLocation, null);
            if (!repository.isModifiable()) {
                throw new IllegalArgumentException("Metadata repository not modifiable: " + this.targetLocation);
            }
            return repository;
        }
        catch (ProvisionException provisionException) {
            String repositoryName = this.targetLocation + " - metadata";
            return this.repoManager.createRepository(this.targetLocation, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
    }

    private void compare(IMetadataRepository sourceRepo, IMetadataRepository targetRepo) {
        Collector sourceRoots = sourceRepo.query((Query)InstallableUnitQuery.ANY, new Collector(), (IProgressMonitor)new NullProgressMonitor());
        Collector targetRoots = targetRepo.query((Query)InstallableUnitQuery.ANY, new Collector(), (IProgressMonitor)new NullProgressMonitor());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit[] sourceIUs = (IInstallableUnit[])sourceRoots.toArray((Class)clazz);
        sourceIUs = this.sort(sourceIUs, true);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit[] targetIUs = (IInstallableUnit[])targetRoots.toArray((Class)clazz2);
        targetIUs = this.sort(targetIUs, true);
        int targetIndex = 0;
        int i = 0;
        while (i < sourceIUs.length) {
            targetIndex = this.compareUsingTargets(sourceIUs[i], targetIUs, targetIndex);
            ++i;
        }
    }

    private int compareUsingTargets(IInstallableUnit sourceIU, IInstallableUnit[] targetIUs, int targetIndex) {
        while (targetIndex < targetIUs.length) {
            int difference = iuIdComparator.compare(sourceIU, targetIUs[targetIndex]);
            if (difference < 0) {
                System.out.println(sourceIU + " is not found in target repository");
                return targetIndex;
            }
            if (difference == 0) {
                String comparison = this.compare(sourceIU, targetIUs[targetIndex]);
                if (comparison.length() > 0) {
                    System.out.println(sourceIU + comparison);
                }
                return targetIndex + 1;
            }
            System.out.println(targetIUs[targetIndex++] + " is not found in source repository");
        }
        System.out.println(sourceIU + " is not found in target repository");
        return targetIndex;
    }

    private boolean compare(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private boolean compare(Object[] a, Object[] b) {
        if (a == null) {
            return b == null;
        }
        return Arrays.equals(a, b);
    }

    private String compare(IInstallableUnit iu, IInstallableUnit next) {
        if (next == null) {
            return " iu artifactLocators providedCapabilities requiredCapabilities touchpointType";
        }
        String result = "";
        if (!iu.equals((Object)next)) {
            result = String.valueOf(result) + " iu";
        }
        if (!this.compare(iu.getArtifacts(), next.getArtifacts())) {
            result = String.valueOf(result) + " artifactLocators";
        }
        if (!this.compare(iu.getProvidedCapabilities(), next.getProvidedCapabilities())) {
            result = String.valueOf(result) + " providedCapabilities";
        }
        if (!this.compareRequires(iu.getRequiredCapabilities(), next.getRequiredCapabilities())) {
            result = String.valueOf(result) + " requiredCapabilities";
        }
        if (!this.compare(iu.getTouchpointType(), next.getTouchpointType())) {
            result = String.valueOf(result) + " touchpointType";
        }
        iu.isFragment();
        return result;
    }

    private boolean compareRequires(IRequiredCapability[] a, IRequiredCapability[] b) {
        if (a == null) {
            return b == null;
        }
        if (a.length != b.length) {
            return false;
        }
        if (a == b) {
            return true;
        }
        int i = 0;
        while (i < a.length) {
            if (this.findCapability(a[i], b) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IRequiredCapability findCapability(IRequiredCapability target, IRequiredCapability[] b) {
        int i = 0;
        while (i < b.length) {
            IRequiredCapability capability = b[i];
            if (target.equals((Object)capability)) {
                return capability;
            }
            ++i;
        }
        return null;
    }

    private IInstallableUnit[] sort(IInstallableUnit[] ius, boolean clone) {
        IInstallableUnit[] result = ius;
        if (clone) {
            result = new InstallableUnit[ius.length];
            System.arraycopy(ius, 0, result, 0, ius.length);
        }
        Arrays.sort(result, iuIdComparator);
        return result;
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-compare")) {
                this.compare = true;
            }
            if (args[i].equalsIgnoreCase("-list")) {
                this.list = true;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-source")) {
                    this.sourceLocation = new URI(arg);
                }
                if (args[i - 1].equalsIgnoreCase("-target")) {
                    this.targetLocation = new URI(arg);
                }
            }
            ++i;
        }
    }

    public void stop() {
    }
}

