/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PI_NAMESPACE = "org.eclipse.equinox.jmx.client";
    public static final String PT_TRANSPORT = "transport";
    static final String CONNECTION_PREFERENCE_DELIMITER = ",";
    static final String CONNECTION_PREFERENCE_NAME = "jmxserviceurl";
    static final String DELIM = ":";
    private static Activator singleton;

    public Activator() {
        singleton = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        singleton = null;
    }

    public static Activator getDefault() {
        return singleton;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PI_NAMESPACE, (String)path);
    }

    public static void log(String message, Throwable exception, int iStatusSeverity) {
        Activator.getDefault().getLog().log((IStatus)new Status(iStatusSeverity, PI_NAMESPACE, 0, message, exception));
    }

    public static void logError(String message, Throwable exception) {
        Activator.log(message, exception, 4);
    }

    public static void logError(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "Exception occurred.";
        }
        Activator.log(message, exception, 4);
    }

    public static void log(String message) {
        Activator.log(message, null, 1);
    }

    public static void log(Throwable exception) {
        Activator.logError(exception.getMessage(), exception);
    }

    public String[] getConnectionPreference() {
        return this.convertConnectionPreference();
    }

    private String[] convertConnectionPreference() {
        StringTokenizer st = new StringTokenizer(this.getPreferenceStore().getString(CONNECTION_PREFERENCE_NAME), CONNECTION_PREFERENCE_DELIMITER);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = st.nextToken();
            ++i;
        }
        return ret;
    }

    public String getDefaultConnectionPreference() {
        return this.getPreferenceStore().getDefaultString(CONNECTION_PREFERENCE_NAME);
    }

    public void setConnectionPreferences(String[] connections) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < connections.length) {
            sbuf.append(connections[i]).append(CONNECTION_PREFERENCE_DELIMITER);
            ++i;
        }
        this.getPreferenceStore().setValue(CONNECTION_PREFERENCE_NAME, sbuf.toString());
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(CONNECTION_PREFERENCE_NAME, "service:jmx:rmi:///jndi/rmi://127.0.0.1:8118/jmxserver");
    }
}

