/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.outline.QuickOutlinePopupDialog;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.PDESourceInfoProvider;
import org.eclipse.pde.internal.ui.editor.text.ReconcilingStrategy;
import org.eclipse.pde.internal.ui.editor.text.SourceInformationProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class ChangeAwareSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected PDESourcePage fSourcePage;
    protected IColorManager fColorManager;
    private MonoReconciler fReconciler;
    private InformationPresenter fInfoPresenter;
    private InformationPresenter fOutlinePresenter;
    static /* synthetic */ Class class$0;

    public ChangeAwareSourceViewerConfiguration(PDESourcePage page, IColorManager manager, IPreferenceStore store) {
        super(store);
        this.fColorManager = manager;
        this.fSourcePage = page;
    }

    public ChangeAwareSourceViewerConfiguration(PDESourcePage page, IColorManager manager) {
        this(page, manager, (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{PDEPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IBaseModel model;
        if (this.fSourcePage != null && this.fReconciler == null && (model = this.fSourcePage.getInputContext().getModel()) instanceof IReconcilingParticipant) {
            ReconcilingStrategy strategy = new ReconcilingStrategy();
            strategy.addParticipant((IReconcilingParticipant)model);
            ISortableContentOutlinePage outline = this.fSourcePage.getContentOutline();
            if (outline instanceof IReconcilingParticipant) {
                strategy.addParticipant((IReconcilingParticipant)outline);
            }
            this.fReconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            this.fReconciler.setDelay(500);
        }
        return this.fReconciler;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.fSourcePage == null) {
            return null;
        }
        if (this.fInfoPresenter == null && this.getInfoImplementationType() != 0) {
            IInformationControlCreator icc = this.getInformationControlCreator(false);
            this.fInfoPresenter = new InformationPresenter(icc);
            this.fInfoPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            SourceInformationProvider provider = new SourceInformationProvider(this.fSourcePage, icc, this.getInfoImplementationType());
            String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
            int i = 0;
            while (i < contentTypes.length) {
                this.fInfoPresenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
                ++i;
            }
            this.fInfoPresenter.setSizeConstraints(60, 10, true, true);
        }
        return this.fInfoPresenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        if (this.fSourcePage == null) {
            return null;
        }
        if (this.fOutlinePresenter != null) {
            return this.fOutlinePresenter;
        }
        this.fOutlinePresenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.pde.ui.quickOutline"));
        this.fOutlinePresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fOutlinePresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        PDESourceInfoProvider provider = new PDESourceInfoProvider(this.fSourcePage);
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            this.fOutlinePresenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
            ++i;
        }
        this.fOutlinePresenter.setSizeConstraints(50, 20, true, false);
        return this.fOutlinePresenter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                QuickOutlinePopupDialog dialog = new QuickOutlinePopupDialog(parent, shellStyle, ChangeAwareSourceViewerConfiguration.this.fSourcePage, ChangeAwareSourceViewerConfiguration.this.fSourcePage);
                return dialog;
            }
        };
    }

    protected int getInfoImplementationType() {
        return 0;
    }

    protected IInformationControlCreator getInformationControlCreator(final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, !cutDown);
            }
        };
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector additionalDetector;
        IHyperlinkDetector[] registeredDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (registeredDetectors == null) {
            return null;
        }
        if (this.fSourcePage == null) {
            return registeredDetectors;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.hyperlink.IHyperlinkDetector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((additionalDetector = (IHyperlinkDetector)this.fSourcePage.getAdapter(clazz)) == null) {
            return registeredDetectors;
        }
        IHyperlinkDetector[] allDetectors = new IHyperlinkDetector[registeredDetectors.length + 1];
        System.arraycopy(registeredDetectors, 0, allDetectors, 0, registeredDetectors.length);
        allDetectors[registeredDetectors.length] = additionalDetector;
        return allDetectors;
    }

    public abstract boolean affectsTextPresentation(PropertyChangeEvent var1);

    public abstract boolean affectsColorPresentation(PropertyChangeEvent var1);

    public abstract void adaptToPreferenceChange(PropertyChangeEvent var1);

    public abstract void dispose();
}

