/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.target.TargetCreationPage;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTargetDefinitionWizard
extends BasicNewResourceWizard {
    TargetDefinitionWizardPage fPage;
    TargetCreationPage ftargetCreationPage;
    IPath fInitialPath = null;
    IPath fFilePath = null;

    public void addPages() {
        this.ftargetCreationPage = new TargetCreationPage("profile");
        this.fPage = new TargetDefinitionWizardPage("profile", this.getSelection());
        if (this.fInitialPath != null) {
            this.fPage.setContainerFullPath(this.fInitialPath);
        }
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        try {
            int option = this.fPage.getInitializationOption();
            this.ftargetCreationPage.setTargetId(this.fPage.getTargetId());
            ITargetDefinition targetDef = this.ftargetCreationPage.createTarget(option);
            this.fFilePath = this.fPage.getContainerFullPath().append(this.fPage.getFileName());
            IFile targetFile = PDECore.getWorkspace().getRoot().getFile(this.fFilePath);
            WorkspaceFileTargetHandle wrkspcTargetHandle = new WorkspaceFileTargetHandle(targetFile);
            wrkspcTargetHandle.save(targetDef);
            IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
            if (ww != null) {
                IWorkbenchPage page = ww.getActivePage();
                IFile file = wrkspcTargetHandle.getTargetFile();
                if (page != null && file.exists()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(PDEUIMessages.NewTargetProfileWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_TARGET_WIZ);
    }

    public void setInitialPath(IPath path) {
        this.fInitialPath = path;
    }

    public IPath getFilePath() {
        return this.fFilePath;
    }
}

