/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.util.Date;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.internal.databinding.provisional.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.internal.databinding.provisional.fieldassist.ControlDecorationUpdater;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Snippet033CrossValidationControlDecoration {
    protected Shell shell;
    private DateTime startDate;
    private DateTime endDate;

    public static void main(String[] args) {
        try {
            Snippet033CrossValidationControlDecoration window = new Snippet033CrossValidationControlDecoration();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                Snippet033CrossValidationControlDecoration.this.createContents();
                Snippet033CrossValidationControlDecoration.this.shell.pack();
                Snippet033CrossValidationControlDecoration.this.shell.open();
                while (!Snippet033CrossValidationControlDecoration.this.shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    protected void createContents() {
        this.shell = new Shell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.shell.setLayout((Layout)layout);
        this.shell.setText("Snippet033CrossValidationControlDecoration.java");
        Label label = new Label((Composite)this.shell, 0);
        label.setLayoutData((Object)new GridData());
        label.setText("Start date");
        this.startDate = new DateTime((Composite)this.shell, 1024);
        GridData gd_startDate = new GridData();
        gd_startDate.horizontalIndent = 10;
        this.startDate.setLayoutData((Object)gd_startDate);
        Label startDateLabel = new Label((Composite)this.shell, 0);
        startDateLabel.setLayoutData((Object)new GridData());
        startDateLabel.setText("End date");
        this.endDate = new DateTime((Composite)this.shell, 1024);
        GridData gd_endDate = new GridData();
        gd_endDate.horizontalIndent = 10;
        this.endDate.setLayoutData((Object)gd_endDate);
        this.bindUI();
    }

    private void bindUI() {
        ISWTObservableValue startDateObservable = WidgetProperties.selection().observe((Widget)this.startDate);
        ISWTObservableValue endDateObservable = WidgetProperties.selection().observe((Widget)this.endDate);
        ControlDecorationSupport.create((ValidationStatusProvider)new DateRangeValidator((IObservableValue)startDateObservable, (IObservableValue)endDateObservable, "Start date must be on or before end date"), (int)0x1004000);
        ControlDecorationUpdater decorationUpdater = new ControlDecorationUpdater(){

            protected String getDescriptionText(IStatus status) {
                return "ERROR: " + super.getDescriptionText(status);
            }

            protected Image getImage(IStatus status) {
                return status.isOK() ? null : Display.getCurrent().getSystemImage(1);
            }
        };
        ControlDecorationSupport.create((ValidationStatusProvider)new DateRangeValidator(Observables.constantObservableValue((Object)new Date()), (IObservableValue)startDateObservable, "Choose a starting date later than today"), (int)16512, null, (ControlDecorationUpdater)decorationUpdater);
    }

    private static class DateRangeValidator
    extends MultiValidator {
        private final IObservableValue start;
        private final IObservableValue end;
        private final String errorMessage;

        public DateRangeValidator(IObservableValue start, IObservableValue end, String errorMessage) {
            this.start = start;
            this.end = end;
            this.errorMessage = errorMessage;
        }

        protected IStatus validate() {
            Date endDate;
            Date startDate = (Date)this.start.getValue();
            if (startDate.compareTo(endDate = (Date)this.end.getValue()) > 0) {
                return ValidationStatus.error((String)this.errorMessage);
            }
            return ValidationStatus.ok();
        }
    }
}

