/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String JPEG = "image/jpeg";
    private static final int JPEG_ID = ImageTransfer.registerType("image/jpeg");
    private static final String PNG = "image/png";
    private static final int PNG_ID = ImageTransfer.registerType("image/png");
    private static final String BMP = "image/bmp";
    private static final int BMP_ID = ImageTransfer.registerType("image/bmp");
    private static final String EPS = "image/eps";
    private static final int EPS_ID = ImageTransfer.registerType("image/eps");
    private static final String PCX = "image/pcx";
    private static final int PCX_ID = ImageTransfer.registerType("image/pcx");
    private static final String PPM = "image/ppm";
    private static final int PPM_ID = ImageTransfer.registerType("image/ppm");
    private static final String RGB = "image/ppm";
    private static final int RGB_ID = ImageTransfer.registerType("image/ppm");
    private static final String TGA = "image/tga";
    private static final int TGA_ID = ImageTransfer.registerType("image/tga");
    private static final String XBM = "image/xbm";
    private static final int XBM_ID = ImageTransfer.registerType("image/xbm");
    private static final String XPM = "image/xpm";
    private static final int XPM_ID = ImageTransfer.registerType("image/xpm");
    private static final String XV = "image/xv";
    private static final int XV_ID = ImageTransfer.registerType("image/xv");

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            return;
        }
        ImageData imgData = (ImageData)object;
        if (imgData == null) {
            SWT.error(4);
        }
        Image image = new Image((Device)Display.getCurrent(), imgData);
        long pixmap = image.pixmap;
        int width = imgData.width;
        int height = imgData.height;
        long pixbuf = OS.gdk_pixbuf_new(0, true, 8, width, height);
        if (pixbuf == 0L) {
            SWT.error(2);
        }
        long colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, pixmap, colormap, 0, 0, 0, 0, width, height);
        String typeStr = "";
        if (transferData.type == (long)JPEG_ID) {
            typeStr = "jpeg";
        }
        if (transferData.type == (long)PNG_ID) {
            typeStr = "png";
        }
        if (transferData.type == (long)BMP_ID) {
            typeStr = "bmp";
        }
        if (transferData.type == (long)EPS_ID) {
            typeStr = "eps";
        }
        if (transferData.type == (long)PCX_ID) {
            typeStr = "pcx";
        }
        if (transferData.type == (long)PPM_ID) {
            typeStr = "ppm";
        }
        if (transferData.type == (long)RGB_ID) {
            typeStr = "rgb";
        }
        if (transferData.type == (long)TGA_ID) {
            typeStr = "tga";
        }
        if (transferData.type == (long)XBM_ID) {
            typeStr = "xbm";
        }
        if (transferData.type == (long)XPM_ID) {
            typeStr = "xpm";
        }
        if (transferData.type == (long)XV_ID) {
            typeStr = "xv";
        }
        byte[] type = Converter.wcsToMbcs(null, typeStr, true);
        long[] buffer = new long[1];
        long[] len = new long[1];
        if (type == null) {
            return;
        }
        OS.gdk_pixbuf_save_to_bufferv(pixbuf, buffer, len, type, null, null, null);
        OS.g_object_unref(pixbuf);
        image.dispose();
        transferData.pValue = buffer[0];
        transferData.length = (int)(len[0] + 3L) / 4 * 4;
        transferData.result = 1;
        transferData.format = 32;
    }

    public Object nativeToJava(TransferData transferData) {
        ImageData imgData = null;
        if (transferData.length > 0) {
            long loader = OS.gdk_pixbuf_loader_new();
            OS.gdk_pixbuf_loader_write(loader, transferData.pValue, transferData.length, null);
            OS.gdk_pixbuf_loader_close(loader, null);
            long pixbuf = OS.gdk_pixbuf_loader_get_pixbuf(loader);
            if (pixbuf != 0L) {
                OS.g_object_ref(pixbuf);
                long[] pixmap_return = new long[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(pixbuf, pixmap_return, null, 0);
                long handle = pixmap_return[0];
                if (handle == 0L) {
                    SWT.error(2);
                }
                OS.g_object_unref(loader);
                Image img = Image.gtk_new(Display.getCurrent(), 0, handle, 0L);
                imgData = img.getImageData();
                img.dispose();
            }
        }
        return imgData;
    }

    protected int[] getTypeIds() {
        return new int[]{JPEG_ID, PNG_ID, BMP_ID, EPS_ID, PCX_ID, PPM_ID, RGB_ID, TGA_ID, XBM_ID, XPM_ID, XV_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{JPEG, PNG, BMP, EPS, PCX, "image/ppm", "image/ppm", TGA, XBM, XPM, XV};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

