/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedArchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintPanel;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPrintPanelDelegate;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int returnCode;
    static Callback dialogCallback5;
    static final byte[] SWT_OBJECT;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
    }

    public PrintDialog(Shell parent) {
        this(parent, 32768);
    }

    public PrintDialog(Shell parent, int style) {
        super(parent, PrintDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    static int checkStyle(Shell parent, int style) {
        int mask = 229376;
        if ((style & 0x10000000) != 0) {
            if (PrintDialog.getSheetEnabled()) {
                if (parent == null) {
                    style &= 0xEFFFFFFF;
                }
            } else {
                style &= 0xEFFFFFFF;
            }
            if ((style & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        return style;
    }

    public void setPrinterData(PrinterData data) {
        this.printerData = data;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public PrinterData open() {
        int response;
        PrinterData data = null;
        NSPrintPanel panel = NSPrintPanel.printPanel();
        NSPrintInfo printInfo = new NSPrintInfo(NSPrintInfo.sharedPrintInfo().copy());
        printInfo.setOrientation(this.printerData.orientation == 2 ? 1 : 0);
        NSMutableDictionary dict = printInfo.dictionary();
        dict.setValue(NSNumber.numberWithBool(this.printerData.collate), OS.NSPrintMustCollate);
        dict.setValue(NSNumber.numberWithInt(this.printerData.copyCount), OS.NSPrintCopies);
        if (this.printerData.printToFile) {
            dict.setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
        }
        if (this.printerData.fileName != null && this.printerData.fileName.length() > 0) {
            dict.setValue(NSString.stringWith(this.printerData.fileName), OS.NSPrintSavePath);
        }
        dict.setValue(NSNumber.numberWithBool(this.printerData.scope == 0), OS.NSPrintAllPages);
        if (this.printerData.scope == 1) {
            dict.setValue(NSNumber.numberWithInt(this.printerData.startPage), OS.NSPrintFirstPage);
            dict.setValue(NSNumber.numberWithInt(this.printerData.endPage), OS.NSPrintLastPage);
        }
        panel.setOptions(0x100L | panel.options());
        if ((this.getStyle() & 0x10000000) != 0) {
            this.initClasses();
            SWTPrintPanelDelegate delegate = (SWTPrintPanelDelegate)new SWTPrintPanelDelegate().alloc().init();
            long jniRef = OS.NewGlobalRef(this);
            if (jniRef == 0L) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(delegate.id, SWT_OBJECT, jniRef);
            this.returnCode = -1;
            Shell parent = this.getParent();
            panel.beginSheetWithPrintInfo(printInfo, parent.view.window(), delegate, OS.sel_panelDidEnd_returnCode_contextInfo_, 0L);
            NSApplication application = NSApplication.sharedApplication();
            while (this.returnCode == -1) {
                application.run();
            }
            if (delegate != null) {
                delegate.release();
            }
            if (jniRef != 0L) {
                OS.DeleteGlobalRef(jniRef);
            }
            response = this.returnCode;
        } else {
            response = (int)panel.runModalWithPrintInfo(printInfo);
        }
        if (response != 0) {
            NSPrinter printer = printInfo.printer();
            NSString str = printer.name();
            data = new PrinterData("Mac", str.getString());
            data.printToFile = printInfo.jobDisposition().isEqual(OS.NSPrintSaveJob);
            if (data.printToFile) {
                NSString filename = new NSString(dict.objectForKey(OS.NSPrintSavePath));
                data.fileName = filename.getString();
            }
            int n = data.scope = new NSNumber(dict.objectForKey(OS.NSPrintAllPages)).intValue() != 0 ? 0 : 1;
            if (data.scope == 1) {
                data.startPage = new NSNumber(dict.objectForKey(OS.NSPrintFirstPage)).intValue();
                data.endPage = new NSNumber(dict.objectForKey(OS.NSPrintLastPage)).intValue();
            }
            data.collate = new NSNumber(dict.objectForKey(OS.NSPrintMustCollate)).intValue() != 0;
            data.collate = false;
            data.copyCount = new NSNumber(dict.objectForKey(OS.NSPrintCopies)).intValue();
            data.copyCount = 1;
            data.orientation = printInfo.orientation() == 1L ? 2 : 1;
            NSData nsData = NSKeyedArchiver.archivedDataWithRootObject(printInfo);
            data.otherData = new byte[(int)nsData.length()];
            OS.memmove(data.otherData, nsData.bytes(), (long)data.otherData.length);
            this.printerData = data;
        }
        printInfo.release();
        return data;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    static long dialogProc(long id2, long sel, long arg0, long arg1, long arg2) {
        long[] jniRef = new long[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        if (sel == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            PrintDialog dialog = (PrintDialog)OS.JNIGetObject(jniRef[0]);
            if (dialog == null) {
                return 0L;
            }
            dialog.panelDidEnd_returnCode_contextInfo(id2, sel, arg0, arg1, arg2);
        }
        return 0L;
    }

    void initClasses() {
        String className = "SWTPrintPanelDelegate";
        if (OS.objc_lookUpClass(className) != 0L) {
            return;
        }
        dialogCallback5 = new Callback(this.getClass(), "dialogProc", 5);
        long dialogProc5 = dialogCallback5.getAddress();
        if (dialogProc5 == 0L) {
            SWT.error(3);
        }
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] types = byArray;
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        long cls = OS.objc_allocateClassPair(OS.class_NSObject, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(cls, OS.sel_panelDidEnd_returnCode_contextInfo_, dialogProc5, "@:@i@");
        OS.objc_registerClassPair(cls);
    }

    void panelDidEnd_returnCode_contextInfo(long id2, long sel, long alert, long returnCode, long contextInfo) {
        this.returnCode = (int)returnCode;
        NSApplication application = NSApplication.sharedApplication();
        application.stop(null);
    }

    public void setScope(int scope) {
        this.printerData.scope = scope;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int startPage) {
        this.printerData.startPage = startPage;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int endPage) {
        this.printerData.endPage = endPage;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean printToFile) {
        this.printerData.printToFile = printToFile;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            SWT.error(43);
        }
    }
}

