/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin.dialogs;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.ProfileGroup;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddProfileOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddProfileDialog
extends StatusDialog {
    private ProfileGroup profileGroup;
    private Button okButton;
    private String[] knownProfileIds;
    private String addedProfileId;

    public AddProfileDialog(Shell parentShell, String[] knownProfiles) {
        super(parentShell);
        this.knownProfileIds = knownProfiles;
        this.setTitle(ProvAdminUIMessages.AddProfileDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.profileGroup = new ProfileGroup(parent, null, new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AddProfileDialog.this.verifyComplete();
            }
        });
        Dialog.applyDialogFont((Control)this.profileGroup.getComposite());
        return this.profileGroup.getComposite();
    }

    protected void okPressed() {
        this.verifyComplete();
        if (this.okButton.isEnabled()) {
            this.addProfile();
            super.okPressed();
        }
    }

    private void addProfile() {
        IProfile profile = this.profileGroup.getProfile();
        if (profile != null) {
            return;
        }
        this.addedProfileId = this.profileGroup.getProfileId();
        Map profileProperties = this.profileGroup.getProfileProperties();
        ProvisioningOperationRunner.run((ProvisioningOperation)new AddProfileOperation(ProvAdminUIMessages.AddProfileDialog_OperationLabel, this.addedProfileId, profileProperties), (int)3);
    }

    void verifyComplete() {
        if (this.okButton == null) {
            return;
        }
        IStatus status = this.profileGroup.verify();
        if (!status.isOK()) {
            this.updateStatus(status);
            this.setOkEnablement(false);
            return;
        }
        if (this.isDuplicate()) {
            return;
        }
        this.okButton.setEnabled(true);
        this.updateStatus((IStatus)new Status(0, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, "", null));
    }

    private boolean isDuplicate() {
        if (this.knownProfileIds == null) {
            return false;
        }
        int i = 0;
        while (i < this.knownProfileIds.length) {
            if (this.knownProfileIds[i].equals(this.profileGroup.getProfileId())) {
                this.setOkEnablement(false);
                this.updateStatus((IStatus)new Status(4, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, ProvAdminUIMessages.AddProfileDialog_DuplicateProfileID, null));
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updateButtonsEnableState(IStatus status) {
        this.setOkEnablement(!status.matches(4));
    }

    protected void setOkEnablement(boolean enable) {
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(enable);
        }
    }

    public String getAddedProfileId() {
        return this.addedProfileId;
    }
}

