/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin.dialogs;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IRepositoryElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class RepositoryImplementationPropertyPage
extends PropertyPage {
    private IRepositoryElement repositoryElement;
    private Composite composite;
    private Text name;
    private Text location;
    private Text nickname;
    private Text description;
    private Table propertiesTable;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.repositoryElement = this.getRepositoryElement();
        if (this.repositoryElement == null) {
            Label label = new Label(parent, -1);
            label.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_NoRepositorySelected);
            return label;
        }
        this.noDefaultAndApplyButton();
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 350;
        this.composite.setLayoutData((Object)data);
        Label urlLabel = new Label(this.composite, 0);
        urlLabel.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_LocationLabel);
        this.location = new Text(this.composite, 72);
        this.location.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(this.composite, 0);
        nameLabel.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_NameLabel);
        this.name = new Text(this.composite, 72);
        this.name.setLayoutData((Object)new GridData(768));
        Label nicknameLabel = new Label(this.composite, 0);
        nicknameLabel.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_NicknameLabel);
        this.nickname = new Text(this.composite, 72);
        this.nickname.setLayoutData((Object)new GridData(768));
        Label descriptionLabel = new Label(this.composite, 0);
        descriptionLabel.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_DescriptionLabel);
        data = new GridData();
        data.verticalAlignment = 128;
        descriptionLabel.setLayoutData((Object)data);
        this.description = new Text(this.composite, 72);
        data = new GridData(768);
        data.verticalAlignment = 128;
        data.grabExcessVerticalSpace = true;
        this.description.setLayoutData((Object)data);
        Label propertiesLabel = new Label(this.composite, 0);
        propertiesLabel.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_PropertiesLabel);
        data = new GridData(768);
        data.horizontalSpan = 2;
        propertiesLabel.setLayoutData((Object)data);
        this.propertiesTable = new Table(this.composite, 2816);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.grabExcessVerticalSpace = true;
        this.propertiesTable.setLayoutData((Object)data);
        this.propertiesTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.propertiesTable, 0);
        nameColumn.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_NameColumnLabel);
        TableColumn valueColumn = new TableColumn(this.propertiesTable, 0);
        valueColumn.setText(ProvAdminUIMessages.RepositoryImplementationPropertyPage_ValueColumnLabel);
        this.initializeFields();
        this.initializeTable();
        nameColumn.pack();
        valueColumn.pack();
        return this.composite;
    }

    private void initializeFields() {
        IRepositoryElement element = this.getRepositoryElement();
        if (element != null) {
            String nick;
            IRepository repo = this.getRepositoryElement().getRepository(null);
            this.location.setText(repo.getLocation().toString());
            String value = repo.getName();
            if (value != null) {
                this.name.setText(value);
            }
            if ((value = repo.getDescription()) != null) {
                this.description.setText(value);
            }
            if (!(nick = element.getName()).equals(value) && !nick.equals(repo.getLocation().toString())) {
                this.nickname.setText(nick);
            }
        }
    }

    private void initializeTable() {
        Map repoProperties;
        if (this.getRepositoryElement() != null && (repoProperties = this.getRepositoryElement().getRepository(null).getProperties()) != null) {
            String[] propNames = repoProperties.keySet().toArray(new String[repoProperties.size()]);
            int i = 0;
            while (i < propNames.length) {
                TableItem item = new TableItem(this.propertiesTable, 0);
                item.setText(new String[]{propNames[i], repoProperties.get(propNames[i]).toString()});
                ++i;
            }
        }
    }

    private IRepositoryElement getRepositoryElement() {
        if (this.repositoryElement == null) {
            IAdaptable iAdaptable = this.getElement();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.ui.model.IRepositoryElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.repositoryElement = (IRepositoryElement)ProvUI.getAdapter((Object)iAdaptable, (Class)clazz);
        }
        return this.repositoryElement;
    }
}

