/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.internal.photon.PtWebClient2Data_t;
import org.eclipse.swt.internal.photon.PtWebDataReqCallback_t;
import org.eclipse.swt.internal.photon.PtWebMetaDataCallback_t;
import org.eclipse.swt.internal.photon.PtWebStatusCallback_t;
import org.eclipse.swt.internal.photon.PtWebWindowCallback_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class Voyager
extends WebBrowser {
    int webHandle;
    String url = "";
    String text = "";
    int textOffset;
    int currentProgress;
    int totalProgress = 25;
    Browser redirectBrowser;
    static int instanceCount = 0;
    static Callback callback;

    Voyager() {
    }

    public void create(Composite parent, int style) {
        int webProc;
        String server;
        String name;
        File netfront;
        int[] nArray = new int[6];
        nArray[0] = 10001;
        nArray[1] = 1440;
        nArray[2] = 1440;
        nArray[3] = 2002;
        nArray[4] = 0xFFFFFF;
        int[] args = nArray;
        this.webHandle = OS.PtCreateWidget(OS.PtWebClient(), this.browser.handle, args.length / 3, args);
        if (this.webHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        if ((netfront = new File("/usr/photon/bin/netfront")).exists() || OS.QNX_MAJOR >= 6 && OS.QNX_MINOR >= 3 && OS.QNX_MICRO >= 0) {
            name = "NetfrontServer";
            server = "netfront";
        } else {
            name = "VoyagerServer-2";
            server = "vserver";
        }
        byte[] nameBuffer = Converter.wcsToMbcs(null, name, true);
        int namePtr = OS.malloc(nameBuffer.length);
        OS.memmove(namePtr, nameBuffer, nameBuffer.length);
        OS.PtSetResource(this.webHandle, 99004, namePtr, 0);
        OS.free(namePtr);
        if (instanceCount == 0) {
            byte[] serverBuffer = Converter.wcsToMbcs(null, server, true);
            int serverPtr = OS.malloc(serverBuffer.length);
            OS.memmove(serverPtr, serverBuffer, serverBuffer.length);
            OS.PtSetResource(this.webHandle, 100009, serverPtr, 0);
            OS.free(serverPtr);
        }
        ++instanceCount;
        if (callback == null) {
            callback = new Callback(this.getClass(), "webProc", 3, false);
        }
        if ((webProc = callback.getAddress()) == 0) {
            SWT.error(3);
        }
        OS.PtAddCallback(this.webHandle, 100115, webProc, 100115);
        OS.PtAddCallback(this.webHandle, 100100, webProc, 100100);
        OS.PtAddCallback(this.webHandle, 100111, webProc, 100111);
        OS.PtAddCallback(this.webHandle, 100101, webProc, 100101);
        OS.PtAddCallback(this.webHandle, 100113, webProc, 100113);
        OS.PtAddCallback(this.webHandle, 100107, webProc, 100107);
        OS.PtAddCallback(this.webHandle, 100104, webProc, 100104);
        OS.PtAddCallback(this.webHandle, 100102, webProc, 100102);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Voyager.this.onDispose();
                        break;
                    }
                    case 15: {
                        Voyager.this.onFocusGained(event);
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 15};
        int i = 0;
        while (i < folderEvents.length) {
            this.browser.addListener(folderEvents[i], listener);
            ++i;
        }
        OS.PtRealizeWidget(this.webHandle);
    }

    static int webProc(int handle, int data, int info) {
        int parent;
        Display display = Display.getCurrent();
        Widget widget = display.findWidget(parent = OS.PtWidgetParent(handle));
        if (widget != null && widget instanceof Browser) {
            Browser browser = (Browser)widget;
            return ((Voyager)browser.webBrowser).webProc(data, info);
        }
        return 0;
    }

    public boolean back() {
        int ptr = OS.malloc(4);
        int[] nArray = new int[3];
        nArray[0] = 100001;
        nArray[1] = ptr;
        int[] args = nArray;
        OS.PtGetResources(this.webHandle, args.length / 3, args);
        int[] result = new int[1];
        OS.memmove(result, ptr, 4);
        OS.memmove(result, result[0], 4);
        OS.free(ptr);
        if ((result[0] & 0x40) == 0) {
            return false;
        }
        OS.PtSetResource(this.webHandle, 100001, 6, 0);
        return true;
    }

    int webProc(int data, int info) {
        switch (data) {
            case 100115: {
                return this.Pt_CB_WEB_CLOSE_WINDOW(info);
            }
            case 100100: {
                return this.Pt_CB_WEB_COMPLETE(info);
            }
            case 100111: {
                return this.Pt_CB_WEB_DATA_REQ(info);
            }
            case 100101: {
                return this.Pt_CB_WEB_METADATA(info);
            }
            case 100113: {
                return this.Pt_CB_WEB_NEW_WINDOW(info);
            }
            case 100107: {
                return this.Pt_CB_WEB_START(info);
            }
            case 100104: {
                return this.Pt_CB_WEB_STATUS(info);
            }
            case 100102: {
                return this.Pt_CB_WEB_URL(info);
            }
        }
        return 0;
    }

    public boolean execute(String script) {
        return false;
    }

    public boolean forward() {
        int ptr = OS.malloc(4);
        int[] nArray = new int[3];
        nArray[0] = 100001;
        nArray[1] = ptr;
        int[] args = nArray;
        OS.PtGetResources(this.webHandle, args.length / 3, args);
        int[] result = new int[1];
        OS.memmove(result, ptr, 4);
        OS.memmove(result, result[0], 4);
        OS.free(ptr);
        if ((result[0] & 0x20) == 0) {
            return false;
        }
        OS.PtSetResource(this.webHandle, 100001, 5, 0);
        return true;
    }

    public String getBrowserType() {
        return "voyager";
    }

    public String getText() {
        return "";
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isBackEnabled() {
        int ptr = OS.malloc(4);
        int[] nArray = new int[3];
        nArray[0] = 100001;
        nArray[1] = ptr;
        int[] args = nArray;
        OS.PtGetResources(this.webHandle, args.length / 3, args);
        int[] result = new int[1];
        OS.memmove(result, ptr, 4);
        OS.memmove(result, result[0], 4);
        OS.free(ptr);
        return (result[0] & 0x40) != 0;
    }

    public boolean isForwardEnabled() {
        int ptr = OS.malloc(4);
        int[] nArray = new int[3];
        nArray[0] = 100001;
        nArray[1] = ptr;
        int[] args = nArray;
        OS.PtGetResources(this.webHandle, args.length / 3, args);
        int[] result = new int[1];
        OS.memmove(result, ptr, 4);
        OS.memmove(result, result[0], 4);
        OS.free(ptr);
        return (result[0] & 0x20) != 0;
    }

    void onDispose() {
        OS.PtDestroyWidget(this.webHandle);
        this.webHandle = 0;
        --instanceCount;
    }

    void onFocusGained(Event e) {
        OS.PtContainerGiveFocus(this.webHandle, null);
    }

    int Pt_CB_WEB_CLOSE_WINDOW(int info) {
        WindowEvent event = new WindowEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(event);
            ++i;
        }
        this.browser.dispose();
        return 0;
    }

    int Pt_CB_WEB_COMPLETE(int info) {
        Display display = this.browser.getDisplay();
        LocationEvent event = new LocationEvent(this.browser);
        event.display = display;
        event.widget = this.browser;
        event.location = this.url;
        event.top = true;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(event);
            ++i;
        }
        ProgressEvent progress = new ProgressEvent(this.browser);
        progress.display = display;
        progress.widget = this.browser;
        progress.current = this.totalProgress;
        progress.total = this.totalProgress;
        int i2 = 0;
        while (i2 < this.progressListeners.length) {
            this.progressListeners[i2].completed(progress);
            ++i2;
        }
        StatusTextEvent statusevent = new StatusTextEvent(this.browser);
        statusevent.display = display;
        statusevent.widget = this.browser;
        statusevent.text = "";
        int i3 = 0;
        while (i3 < this.statusTextListeners.length) {
            this.statusTextListeners[i3].changed(statusevent);
            ++i3;
        }
        return 0;
    }

    int Pt_CB_WEB_DATA_REQ(int info) {
        PtCallbackInfo_t cbinfo_t = new PtCallbackInfo_t();
        OS.memmove(cbinfo_t, info, 16);
        PtWebDataReqCallback_t dataReq = new PtWebDataReqCallback_t();
        OS.memmove(dataReq, cbinfo_t.cbdata, 12);
        PtWebClient2Data_t clientData = new PtWebClient2Data_t();
        clientData.type = dataReq.type;
        clientData.data = 0;
        String data = null;
        switch (clientData.type) {
            case 1: {
                StringBuffer sb = new StringBuffer("Content-Type: text/html\n");
                sb.append("Content-Length: ");
                sb.append(this.text.length());
                sb.append("\n");
                data = sb.toString();
                break;
            }
            case 2: {
                if (this.text.length() - this.textOffset > 1024) {
                    data = this.text.substring(this.textOffset, this.textOffset + 1024);
                    this.textOffset += 1024;
                    break;
                }
                data = this.text.substring(this.textOffset);
                break;
            }
            case 3: {
                this.text = "";
            }
        }
        if (data != null) {
            byte[] buffer = Converter.wcsToMbcs(null, data, true);
            clientData.data = OS.malloc(buffer.length);
            OS.memmove(clientData.data, buffer, buffer.length);
            clientData.length = buffer.length - 1;
        }
        dataReq.url = clientData.url;
        int ptr = OS.malloc(16);
        OS.memmove(ptr, clientData, 16);
        OS.PtSetResource(this.webHandle, 100022, clientData.data, ptr);
        OS.free(ptr);
        if (clientData.data != 0) {
            OS.free(clientData.data);
        }
        return 0;
    }

    int Pt_CB_WEB_METADATA(int info) {
        PtCallbackInfo_t cbinfo_t = new PtCallbackInfo_t();
        OS.memmove(cbinfo_t, info, 16);
        PtWebMetaDataCallback_t webmeta_t = new PtWebMetaDataCallback_t();
        OS.memmove(webmeta_t, cbinfo_t.cbdata, 2176);
        String name = new String(webmeta_t.name, 0, OS.strlen(cbinfo_t.cbdata));
        if (name.equals("title")) {
            String title = new String(webmeta_t.value, 0, OS.strlen(cbinfo_t.cbdata + webmeta_t.name.length));
            TitleEvent newEvent = new TitleEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.title = title;
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(newEvent);
                ++i;
            }
        }
        return 0;
    }

    int Pt_CB_WEB_NEW_WINDOW(int info) {
        PtCallbackInfo_t cbinfo_t = new PtCallbackInfo_t();
        OS.memmove(cbinfo_t, info, 16);
        final PtWebWindowCallback_t webwin_t = new PtWebWindowCallback_t();
        OS.memmove(webwin_t, cbinfo_t.cbdata, 8);
        final Browser hidden = new Browser(this.browser.getParent(), 0);
        hidden.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                if (event.location.length() == 0) {
                    hidden.refresh();
                    return;
                }
                hidden.dispose();
            }

            public void changing(LocationEvent event) {
                Browser redirect = ((Voyager)hidden.webBrowser).redirectBrowser;
                if (redirect != null && !redirect.isDisposed()) {
                    WindowEvent newEvent = new WindowEvent(redirect);
                    newEvent.display = Voyager.this.browser.getDisplay();
                    newEvent.widget = redirect;
                    newEvent.location = null;
                    newEvent.size = webwin_t.size_w == 0 && webwin_t.size_h == 0 ? null : new Point(webwin_t.size_w, webwin_t.size_h);
                    int i = 0;
                    while (i < redirect.webBrowser.visibilityWindowListeners.length) {
                        redirect.webBrowser.visibilityWindowListeners[i].show(newEvent);
                        ++i;
                    }
                    redirect.setUrl(event.location);
                }
            }
        });
        WindowEvent event = new WindowEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.required = true;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            this.openWindowListeners[i].open(event);
            ++i;
        }
        if (event.browser != null && !event.browser.isDisposed()) {
            ((Voyager)hidden.webBrowser).redirectBrowser = event.browser;
        }
        return 0;
    }

    int Pt_CB_WEB_START(int info) {
        this.currentProgress = 1;
        ProgressEvent progress = new ProgressEvent(this.browser);
        progress.display = this.browser.getDisplay();
        progress.widget = this.browser;
        progress.current = this.currentProgress;
        progress.total = this.totalProgress;
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(progress);
            ++i;
        }
        return 0;
    }

    int Pt_CB_WEB_STATUS(int info) {
        PtCallbackInfo_t cbinfo_t = new PtCallbackInfo_t();
        PtWebStatusCallback_t webstatus = new PtWebStatusCallback_t();
        OS.memmove(cbinfo_t, info, 16);
        OS.memmove(webstatus, cbinfo_t.cbdata, 2056);
        switch (webstatus.type) {
            case 1: 
            case 3: {
                StatusTextEvent statusevent = new StatusTextEvent(this.browser);
                statusevent.display = this.browser.getDisplay();
                statusevent.widget = this.browser;
                statusevent.text = new String(webstatus.desc, 0, OS.strlen(cbinfo_t.cbdata));
                int i = 0;
                while (i < this.statusTextListeners.length) {
                    this.statusTextListeners[i].changed(statusevent);
                    ++i;
                }
                if (webstatus.type != 3) break;
                ++this.currentProgress;
                if (this.currentProgress >= this.totalProgress) {
                    this.currentProgress = 1;
                }
                ProgressEvent progress = new ProgressEvent(this.browser);
                progress.display = this.browser.getDisplay();
                progress.widget = this.browser;
                progress.current = this.currentProgress;
                progress.total = this.totalProgress;
                int i2 = 0;
                while (i2 < this.progressListeners.length) {
                    this.progressListeners[i2].changed(progress);
                    ++i2;
                }
                break;
            }
        }
        return 0;
    }

    int Pt_CB_WEB_URL(int info) {
        PtCallbackInfo_t cbinfo_t = new PtCallbackInfo_t();
        OS.memmove(cbinfo_t, info, 16);
        byte[] buffer = new byte[OS.strlen(cbinfo_t.cbdata) + 1];
        OS.memmove(buffer, cbinfo_t.cbdata, buffer.length);
        this.url = new String(Converter.mbcsToWcs(null, buffer));
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = this.url;
        event.doit = true;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changing(event);
            ++i;
        }
        if (this.browser.isDisposed()) {
            return 0;
        }
        if (!event.doit) {
            this.stop();
        }
        return 0;
    }

    public void refresh() {
        OS.PtSetResource(this.webHandle, 100006, 1, 0);
    }

    public boolean setText(String html) {
        this.text = html;
        this.textOffset = 0;
        byte[] buffer = Converter.wcsToMbcs(null, "client:", true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtSetResource(this.webHandle, 100000, ptr, 1);
        OS.free(ptr);
        return true;
    }

    public boolean setUrl(String url) {
        byte[] buffer = Converter.wcsToMbcs(null, url, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtSetResource(this.webHandle, 100000, ptr, 1);
        OS.free(ptr);
        return true;
    }

    public void stop() {
        OS.PtSetResource(this.webHandle, 100007, 1, 0);
    }
}

